/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.topo.build;

import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.InstanceObject;
import com.huawei.csr.framework.topo.build.TopoSource;
import com.huawei.csr.framework.topo.build.TopoSourceType;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.stream.Collectors;

public class TopoSourceFactory {
    public static TopoSource convertTopoSource(AppServiceInstance instance) {
        TopoSource source = new TopoSource();
        source.setPdId(instance.getInstanceId());
        source.setDrId(instance.getInstanceId());
        source.setProjectId(instance.getProjectId());
        source.setApplicationId(instance.getApplication().getId());
        source.setPdName(instance.getInstanceName());
        source.setDrName(instance.getInstanceName());
        source.setNodeType(instance.getServiceType());
        source.setPdNodeStatus(instance.getStatus());
        source.setDrNodeStatus(instance.getStatus());
        source.setResourceType(instance.getServiceType());
        source.setResourceId(instance.getInstanceId());
        source.setPdRegionId(instance.getPdRegionId());
        source.setDrRegionId(instance.getDrRegionId());
        source.setPdRegionName(instance.getPdRegionName());
        source.setDrRegionName(instance.getDrRegionName());
        source.setPdAzId(instance.getPdAzId());
        source.setDrAzId(instance.getDrAzId());
        source.setPdAzName(instance.getPdAzName());
        source.setDrAzName(instance.getDrAzName());
        source.setPdSiteId(instance.getPdSiteId());
        source.setDrSiteId(instance.getDrSiteId());
        source.setAddress(instance.getInstanceAddress());
        source.setReplicaStatus(instance.getReplicaStatus());
        if (!VerifyUtil.isEmpty(instance.getInstanceObjects())) {
            source.setChildSources(instance.getInstanceObjects().stream().map(TopoSourceFactory::convertTopoSource).collect(Collectors.toList()));
        }
        return source;
    }

    private static TopoSource convertTopoSource(InstanceObject instanceObject) {
        AppServiceInstance instance = instanceObject.getServiceInstance();
        TopoSource source = new TopoSource();
        source.setPdId(instanceObject.getPdId());
        source.setDrId(instanceObject.getDrId());
        source.setProjectId(instanceObject.getProjectId());
        source.setApplicationId(instance.getApplication().getId());
        source.setPdName(instanceObject.getPdName());
        source.setDrName(instanceObject.getDrName());
        source.setNodeType(TopoSourceType.VM.getValue());
        source.setPdNodeStatus(instanceObject.getPdStatus());
        source.setDrNodeStatus(instanceObject.getDrStatus());
        source.setResourceType(instance.getServiceType());
        source.setResourceId(instance.getInstanceId());
        source.setPdRegionId(instanceObject.getPdRegionId());
        source.setDrRegionId(instanceObject.getDrRegionId());
        source.setPdRegionName(instanceObject.getPdRegionName());
        source.setDrRegionName(instanceObject.getDrRegionName());
        source.setPdAzId(instanceObject.getPdAzId());
        source.setDrAzId(instanceObject.getDrAzId());
        source.setPdAzName(instanceObject.getPdAzName());
        source.setDrAzName(instanceObject.getDrAzName());
        source.setPdSiteId(instance.getPdSiteId());
        source.setDrSiteId(instance.getDrSiteId());
        return source;
    }
}

