/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.topo.listener;

import com.huawei.csr.framework.core.event.entity.AppEventEntity;
import com.huawei.csr.framework.core.event.listener.BaseEventListener;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.topo.build.BuildContext;
import com.huawei.csr.framework.topo.build.TopoBuildHelper;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Set;

public abstract class AbstractTopoListener
implements BaseEventListener<AppEvent> {
    private static final Log logger = LogFactory.getInstance(AbstractTopoListener.class);

    @Override
    public void onAfter(AppEvent event) {
        AppEventEntity eventEntity = (AppEventEntity)event.getSource();
        Application application = eventEntity.getApplication();
        logger.info((Object)"Begin update topo values, appEvent type:%s, appId:%s.", new Object[]{event.getEventType().getValue(), application.getId()});
        this.updateTopo(application);
        logger.info((Object)"End update topo values.");
    }

    protected abstract void updateTopo(Application var1);

    protected static BuildContext createTopoValues(Application application) {
        Set<AppServiceInstance> instanceList = application.getServiceInstances();
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        BuildContext context = TopoBuildHelper.buildTopoValues(instanceList);
        context.getTopoNodeList().forEach(appService::createTopoNode);
        context.getTopoLinkList().forEach(appService::createTopoLink);
        return context;
    }

    protected static void deleteTopoValues(Application application) {
        String applicationId = application.getId();
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        appService.clearAppTopoValue(applicationId);
    }
}

