/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.framework.topo.listener;

import com.huawei.csr.framework.common.model.TopoLinkQuery;
import com.huawei.csr.framework.core.event.objects.AppEvent;
import com.huawei.csr.framework.dao.model.Application;
import com.huawei.csr.framework.dao.model.TopoLink;
import com.huawei.csr.framework.dao.model.TopoNode;
import com.huawei.csr.framework.service.AppService;
import com.huawei.csr.framework.topo.build.BuildContext;
import com.huawei.csr.framework.topo.listener.AbstractTopoListener;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TopoAppRefreshListener
extends AbstractTopoListener {
    private static final Log logger = LogFactory.getInstance(TopoAppRefreshListener.class);

    @Override
    public boolean supportEvent(AppEvent event) {
        return event.getEventType().equals((Object)AppEvent.EventType.REFRESH_APP) || event.getEventType().equals((Object)AppEvent.EventType.ADD_INSTANCES) || event.getEventType().equals((Object)AppEvent.EventType.REMOVE_INSTANCES);
    }

    @Override
    protected void updateTopo(Application application) {
        logger.info((Object)"Update topo values for refreshing app(%s).", new Object[]{application.getId()});
        ArrayList<String> userTopoLinks = new ArrayList<String>();
        this.queryOldTopoValues(application, userTopoLinks);
        TopoAppRefreshListener.deleteTopoValues(application);
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        Application applicationInDB = appService.getApplicationById(application.getId());
        BuildContext context = TopoAppRefreshListener.createTopoValues(applicationInDB);
        HashMap<String, TopoNode> newTopoMap = new HashMap<String, TopoNode>();
        for (TopoNode topoNode : context.getTopoNodeList()) {
            newTopoMap.put(topoNode.getEntity(), topoNode);
        }
        this.rebuildUserLinks(application, userTopoLinks, newTopoMap);
    }

    private void queryOldTopoValues(Application application, List<String> userTopoLinks) {
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        TopoLinkQuery query = new TopoLinkQuery();
        query.setProjectId(application.getProjectId());
        query.setApplicationId(application.getId());
        query.setUserOpt(true);
        List<TopoLink> topoLinkList = appService.queryTopoLinks(query);
        for (TopoLink topoLink : topoLinkList) {
            TopoNode sourceNode = appService.queryTopoNode(topoLink.getSourceId());
            TopoNode targetNode = appService.queryTopoNode(topoLink.getTargetId());
            if (VerifyUtil.isEmpty((Object)sourceNode) || VerifyUtil.isEmpty((Object)targetNode)) {
                logger.error((Object)"Topo values error.Link source id: %s, target id: %s", new Object[]{topoLink.getSourceId(), topoLink.getTargetId()});
                continue;
            }
            userTopoLinks.add(sourceNode.getEntity());
            userTopoLinks.add(targetNode.getEntity());
        }
    }

    private void rebuildUserLinks(Application application, List<String> userTopoLinks, Map<String, TopoNode> newTopoMap) {
        AppService appService = (AppService)ServiceLocator.getInstance().getService(AppService.class);
        for (int i = 0; i < userTopoLinks.size(); i += 2) {
            String sourceEntity = userTopoLinks.get(i);
            String targetEntity = userTopoLinks.get(i + 1);
            TopoNode sourceNode = newTopoMap.get(sourceEntity);
            TopoNode targetNode = newTopoMap.get(targetEntity);
            if (VerifyUtil.isEmpty((Object)sourceNode) || VerifyUtil.isEmpty((Object)targetNode)) {
                logger.info((Object)"No need to rebuild user topo link, because source node or target node has been deleted");
                continue;
            }
            TopoLink topoLink = new TopoLink();
            topoLink.setProjectId(application.getProjectId());
            topoLink.setApplicationId(application.getId());
            topoLink.setUserOpt(true);
            topoLink.setSourceId(sourceNode.getId());
            topoLink.setTargetId(targetNode.getId());
            appService.createTopoLink(topoLink);
        }
    }
}

