/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.install.log;

import com.huawei.lego.install.log.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class LegoLogger
implements Log {
    private static final int NUM_65528 = 65528;
    private static final int NUM_0XC350 = 50000;
    private static final int NUM_0X2710 = 10000;
    private static final int NUM_0X1388 = 5000;
    private static final int NUM_5000 = 5000;
    private static final int NUM_10000 = 10000;
    private static final int NUM_2 = 2;
    private static final int NUM_3 = 3;
    private static final int NUM_4 = 4;
    private static final int NUM_5 = 5;
    private static final int NUM_0X4E20 = 20000;
    private static final int NUM_0X7530 = 30000;
    private static final int NUM_0X9C40 = 40000;
    private int logLevel = 65528;
    private Logger slfLogger;
    private String thisClassName = LegoLogger.class.getName();
    private boolean showLocSrc = true;

    public LegoLogger(String product) {
        this.slfLogger = LoggerFactory.getLogger((String)product);
    }

    @Override
    public void setShowLocSrc(boolean showLocSrc) {
        this.showLocSrc = showLocSrc;
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    @Override
    public int setLogLevel(int level) {
        this.logLevel = level | 0xC350;
        return this.logLevel;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.slfLogger.isDebugEnabled() && (this.logLevel & 0x2710) != 0;
    }

    @Override
    public boolean isTraceEnabled() {
        return (this.logLevel & 0x1388) != 0;
    }

    @Override
    public void debug(Object message) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.showLocSrc) {
            this.log(10000, this.replaceBlank(message), Thread.currentThread().getStackTrace());
        } else {
            this.log(10000, this.replaceBlank(message), null);
        }
    }

    @Override
    public void trace(Object message) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.showLocSrc) {
            this.log(5000, this.replaceBlank(message), Thread.currentThread().getStackTrace());
        } else {
            this.log(5000, this.replaceBlank(message), null);
        }
    }

    @Override
    public void info(Object message) {
        if ((this.logLevel & 0x4E20) == 0) {
            return;
        }
        if (this.showLocSrc) {
            this.log(20000, this.replaceBlank(message), Thread.currentThread().getStackTrace());
        } else {
            this.log(20000, this.replaceBlank(message), null);
        }
    }

    @Override
    public void warn(Object message) {
        if ((this.logLevel & 0x7530) == 0) {
            return;
        }
        if (this.showLocSrc) {
            this.log(30000, this.replaceBlank(message), Thread.currentThread().getStackTrace());
        } else {
            this.log(30000, this.replaceBlank(message), null);
        }
    }

    @Override
    public void error(Object message) {
        if ((this.logLevel & 0x9C40) == 0) {
            return;
        }
        if (this.showLocSrc) {
            this.log(40000, this.replaceBlank(message), Thread.currentThread().getStackTrace());
        } else {
            this.log(40000, this.replaceBlank(message), null);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if ((this.logLevel & 0x9C40) == 0) {
            return;
        }
        if (this.showLocSrc) {
            this.log(40000, this.replaceBlank(message), t, Thread.currentThread().getStackTrace());
        } else {
            this.log(40000, this.replaceBlank(message), null);
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.showLocSrc) {
            this.log(50000, this.replaceBlank(message), Thread.currentThread().getStackTrace());
        } else {
            this.log(50000, this.replaceBlank(message), null);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (this.showLocSrc) {
            this.log(50000, this.replaceBlank(message), t, Thread.currentThread().getStackTrace());
        } else {
            this.log(50000, this.replaceBlank(message), null);
        }
    }

    private void log(int level, Object message, StackTraceElement[] ste) {
        message = this.getStackMsg(ste) + message;
        String format = this.getFormat(level);
        if (level == 5000) {
            this.slfLogger.trace(format, new Object[]{"", message});
        } else if (level == 10000) {
            this.slfLogger.debug(format, new Object[]{"", message});
        } else if (level == 20000) {
            this.slfLogger.info(format, new Object[]{"", message});
        } else if (level == 30000) {
            this.slfLogger.warn(format, new Object[]{"", message});
        } else {
            this.slfLogger.error(format, new Object[]{"", message});
        }
    }

    private void log(int level, Object message, Throwable t, StackTraceElement[] ste) {
        if (ste != null) {
            message = this.getStackMsg(ste) + message;
        }
        String format = this.getFormat(level);
        String errorMsg = MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{"", message}).getMessage();
        if (level == 40000 || level == 50000) {
            this.slfLogger.error(errorMsg, t);
        }
    }

    private String getStackMsg(StackTraceElement[] ste) {
        if (ste == null) {
            return "[]";
        }
        boolean srcFlag = false;
        for (int i = 0; i < ste.length; ++i) {
            StackTraceElement s = ste[i];
            if (srcFlag) {
                return "[" + s.getClassName() + "][" + s.getMethodName() + "," + s.getLineNumber() + "]";
            }
            if (!this.thisClassName.equals(s.getClassName())) continue;
            srcFlag = true;
        }
        return null;
    }

    @Override
    public void debug(Object message, String coding) {
        if (!this.isDebugEnabled()) {
            return;
        }
        if (this.showLocSrc) {
            this.log(10000, this.replaceBlank(message), Thread.currentThread().getStackTrace(), this.replaceBlank(coding).toString());
        } else {
            this.log(10000, this.replaceBlank(message), null, this.replaceBlank(coding).toString());
        }
    }

    @Override
    public void trace(Object message, String coding) {
        if (!this.isTraceEnabled()) {
            return;
        }
        if (this.showLocSrc) {
            this.log(5000, this.replaceBlank(message), Thread.currentThread().getStackTrace(), this.replaceBlank(coding).toString());
        } else {
            this.log(5000, this.replaceBlank(message), null, this.replaceBlank(coding).toString());
        }
    }

    @Override
    public void info(Object message, String coding) {
        if ((this.logLevel & 0x4E20) == 0) {
            return;
        }
        if (this.showLocSrc) {
            this.log(20000, this.replaceBlank(message), Thread.currentThread().getStackTrace(), this.replaceBlank(coding).toString());
        } else {
            this.log(20000, this.replaceBlank(message), null, this.replaceBlank(coding).toString());
        }
    }

    @Override
    public void warn(Object message, String coding) {
        if ((this.logLevel & 0x7530) == 0) {
            return;
        }
        if (this.showLocSrc) {
            this.log(30000, this.replaceBlank(message), Thread.currentThread().getStackTrace(), this.replaceBlank(coding).toString());
        } else {
            this.log(30000, this.replaceBlank(message), null, this.replaceBlank(coding).toString());
        }
    }

    @Override
    public void error(Object message, String coding) {
        if ((this.logLevel & 0x9C40) == 0) {
            return;
        }
        if (this.showLocSrc) {
            this.log(40000, this.replaceBlank(message), Thread.currentThread().getStackTrace(), this.replaceBlank(coding).toString());
        } else {
            this.log(40000, this.replaceBlank(message), null, this.replaceBlank(coding).toString());
        }
    }

    @Override
    public void error(Object message, Throwable t, String coding) {
        if ((this.logLevel & 0x9C40) == 0) {
            return;
        }
        if (this.showLocSrc) {
            this.log(40000, this.replaceBlank(message), t, Thread.currentThread().getStackTrace(), this.replaceBlank(coding).toString());
        } else {
            this.log(40000, this.replaceBlank(message), null, this.replaceBlank(coding).toString());
        }
    }

    @Override
    public void fatal(Object message, String coding) {
        if (this.showLocSrc) {
            this.log(50000, this.replaceBlank(message), Thread.currentThread().getStackTrace(), this.replaceBlank(coding).toString());
        } else {
            this.log(50000, this.replaceBlank(message), null, this.replaceBlank(coding).toString());
        }
    }

    @Override
    public void fatal(Object message, Throwable t, String coding) {
        if (this.showLocSrc) {
            this.log(50000, this.replaceBlank(message), t, Thread.currentThread().getStackTrace(), this.replaceBlank(coding).toString());
        } else {
            this.log(50000, this.replaceBlank(message), null, this.replaceBlank(coding).toString());
        }
    }

    private void log(int level, Object message, StackTraceElement[] ste, String coding) {
        message = this.getStackMsg(ste) + message;
        String format = this.getFormat(level);
        if (level == 5000) {
            this.slfLogger.trace(format, new Object[]{coding, message});
        } else if (level == 20000) {
            this.slfLogger.info(format, new Object[]{coding, message});
        } else if (level == 30000) {
            this.slfLogger.warn(format, new Object[]{coding, message});
        } else if (level == 40000 || level == 50000) {
            this.slfLogger.error(format, new Object[]{coding, message});
        } else {
            this.slfLogger.debug(format, new Object[]{coding, message});
        }
    }

    private void log(int level, Object message, Throwable t, StackTraceElement[] ste, String coding) {
        if (ste != null) {
            message = this.getStackMsg(ste) + message;
        }
        String format = this.getFormat(level);
        String errorMsg = MessageFormatter.arrayFormat((String)format, (Object[])new Object[]{coding, message}).getMessage();
        if (level == 40000 || level == 50000) {
            this.slfLogger.error(errorMsg, t);
        }
    }

    private String getFormat(int level) {
        SimpleDateFormat df = new SimpleDateFormat("[yyyy/MM/dd HH:mm:ss]");
        String format = df.format(new Date()) + "[{}][" + Level.toLevel((int)level) + "]{}";
        return format;
    }

    private Object replaceBlank(Object value) {
        if (null != value && value instanceof String) {
            return value.toString().replaceAll("\t|\r|\n", "");
        }
        return value;
    }
}

