/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.util;

import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.ExceptionUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class CommonUtil {
    private static final int MAX_LEN = 0xFFFFFFE;
    private static final String SP = File.separator;
    private static Log logger = LogFactory.getInstance(CommonUtil.class);

    public static boolean isEmpty(String string) {
        return null == string || string.trim().isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return null == collection || collection.isEmpty();
    }

    public static void closeStream(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                logger.error((Object)("close strean failed, errmsg=" + ExceptionUtil.getErrorMessage(e)), "");
            }
        }
    }

    public static String getInstallPath() {
        File file = new File("/home/ICUser/RDInstalled.xml");
        if (!file.exists()) {
            logger.error((Object)"Can not find the RDInstalled.xml.", "");
            throw new RuntimeException("Can not find the RDInstalled.xml.");
        }
        try {
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures(sax);
            Document document = sax.read(file);
            String installPath = "";
            List list = document.selectNodes("/install/installpath");
            if (null != list && !list.isEmpty()) {
                Element ele = (Element)list.get(0);
                installPath = ele.attributeValue("path");
            }
            if (CommonUtil.isEmpty(installPath)) {
                throw new RuntimeException("Can not find the install path.");
            }
            File path = new File(installPath);
            if (!path.exists() || !path.isDirectory()) {
                logger.error((Object)"can not find the eReplcation install path.", "");
                throw new RuntimeException("Can not find the eReplication server install path.");
            }
            return installPath;
        }
        catch (Exception e) {
            logger.error((Object)("Failed to get install path info. errMsg=%s" + ExceptionUtil.getErrorMessage(e)), "");
            throw new RuntimeException();
        }
    }

    public static void setSecurityFeatures(SAXReader reader) throws SAXException {
        reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
        reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    public static void setSecurityFeatures(DocumentBuilderFactory factory) throws ParserConfigurationException {
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
    }

    public static String decrypt(String data) {
        String wccHome = CommonUtil.getInstallPath() + SP + "Runtime" + SP + "LegoRuntime" + SP + "conf" + SP + "wcc";
        File path = new File(wccHome);
        if (!path.exists() || !path.isDirectory()) {
            logger.error((Object)"init wcc failed, can not find the home path.", "");
            throw new RuntimeException();
        }
        try {
            KmcInstance.initComponent((String)wccHome);
            return KmcInstance.decrypt((String)data);
        }
        catch (Exception e) {
            logger.error((Object)"init wcc failed, can not find the home path.", "");
            e.printStackTrace();
            return null;
        }
    }

    public static String getLineFromFile(BufferedReader bufReader) throws IOException {
        StringBuffer strBuf = new StringBuffer();
        try {
            int tempChar;
            while ((tempChar = bufReader.read()) != -1) {
                if (strBuf.length() >= 0xFFFFFFE) {
                    throw new IOException("input too long");
                }
                if (tempChar == 13) {
                    tempChar = bufReader.read();
                    if (tempChar == 10) {
                        return strBuf.toString();
                    }
                    strBuf.append('\r');
                }
                if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                    strBuf.append((char)tempChar);
                    continue;
                }
                return strBuf.toString();
            }
        }
        catch (IOException e) {
            throw new IOException(e);
        }
        if (strBuf.length() > 0) {
            return strBuf.toString();
        }
        return null;
    }
}

