/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.elb;

import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.connector.http.RequestInvocation;
import com.huawei.sdk.connector.http.RestHttpClient;
import com.huawei.sdk.connector.utils.RequestUtil;
import com.huawei.sdk.elb.model.LoadBalancer;
import com.huawei.sdk.elb.model.Members;
import com.huawei.sdk.elb.model.request.ListListenerRequest;
import com.huawei.sdk.elb.model.request.ListLoadBalancerRequest;
import com.huawei.sdk.elb.model.request.ListMemberRequest;
import com.huawei.sdk.elb.model.response.ListListenerResponse;
import com.huawei.sdk.elb.model.response.ListLoadBalancerResponse;
import com.huawei.sdk.elb.model.response.ListMemberResponse;
import com.huawei.sdk.elb.model.response.LoadBalancerResponse;
import com.huawei.sdk.elb.model.v3.MemberResponseV3;
import java.io.IOException;
import java.util.List;

public class ElbClient {
    public List<LoadBalancer> queryLoadBalancerList(Credential credential, ListLoadBalancerRequest listLoadBalancerRequest) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("lbaas/loadbalancers?" + RequestUtil.buildQueryParamsStr((Object)listLoadBalancerRequest));
        ListLoadBalancerResponse loadBalancerListVo = (ListLoadBalancerResponse)client.get(invocation, ListLoadBalancerResponse.class);
        return loadBalancerListVo.getLoadBalancerList();
    }

    public LoadBalancer queryLoadBalancer(String loadBalancerId, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("lbaas/loadbalancers/" + loadBalancerId);
        return ((LoadBalancerResponse)client.get(invocation, LoadBalancerResponse.class)).getLoadBalancer();
    }

    public ListMemberResponse queryMemberList(String poolId, ListMemberRequest listMemberRequest, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("lbaas/pools/" + poolId + "/members?" + RequestUtil.buildQueryParamsStr((Object)listMemberRequest));
        return (ListMemberResponse)client.get(invocation, ListMemberResponse.class);
    }

    public MemberResponseV3 queryMemberListV3(String poolId, ListMemberRequest listMemberRequest, Credential credential) throws ResponseException, ClientException, IOException {
        String endpoint = credential.getEndpoint();
        String substring = endpoint.substring(0, endpoint.indexOf("/v2.0/"));
        credential.setEndpoint(substring);
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        String paramStr = null;
        if (!VerifyUtil.isEmpty((Object)listMemberRequest)) {
            paramStr = RequestUtil.buildQueryParamsStr((Object)listMemberRequest);
        }
        invocation.setUrl("/v3/" + credential.getProjectId() + "/elb/pools/" + poolId + "/exmembers?" + paramStr);
        return (MemberResponseV3)client.get(invocation, MemberResponseV3.class);
    }

    public Members queryMember(String poolId, String memberId, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("lbaas/pools/" + poolId + "/members/" + memberId);
        return (Members)client.get(invocation, Members.class);
    }

    public ListListenerResponse queryListeners(String loadBanancerId, Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        String requestUrl = "v2/" + credential.getProjectId() + "/elb/listeners";
        ListListenerRequest listenerRequest = new ListListenerRequest();
        listenerRequest.setLoadbalancerId(loadBanancerId);
        String parametersUrl = RequestUtil.buildQueryParamsStr((Object)listenerRequest);
        if (!VerifyUtil.isEmpty((String)parametersUrl)) {
            requestUrl = requestUrl + "?" + parametersUrl;
        }
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(requestUrl);
        return (ListListenerResponse)client.get(invocation, ListListenerResponse.class);
    }
}

