/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.rest.security;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ILogger;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Optional;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLTrustManager
implements X509TrustManager {
    private static final ILogger LOGGER = new CryptLogger();
    private final X509TrustManager trustManager;

    public SSLTrustManager() {
        TrustManager manager = SSLTrustManager.buildTrustManager();
        this.trustManager = manager instanceof X509TrustManager ? (X509TrustManager)manager : null;
    }

    public static TrustManager buildTrustManager() {
        TrustManager trustManager = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream inputStream = new FileInputStream(SSLTrustManager.getKeyStoreFile());){
                keyStore.load(inputStream, SSLTrustManager.getKeyStorePwd());
            }
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
            trustManager = trustManagerFactory.getTrustManagers()[0];
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "load keystore to trustManager failed. e: %s", e.getMessage()));
        }
        return trustManager;
    }

    private static char[] getKeyStorePwd() throws AppException {
        String pwd = SysPropertiesUtils.getPropertyValue("keyStore");
        return KmcInstance.decrypt(pwd).toCharArray();
    }

    private static String getKeyStoreFile() throws AppException {
        Optional<String> runtimePath = SysPropertiesUtils.getRuntimePath();
        if (runtimePath.isPresent()) {
            return runtimePath.get() + "/LegoRuntime/certs/bcm.keystore";
        }
        throw new AppException("get runtime path failed.");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }
}

