/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.kmc;

import com.huawei.kmc.common.ILogger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.BindException;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.acl.NotOwnerException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.MissingResourceException;
import java.util.jar.JarException;
import javax.naming.InsufficientResourcesException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.status.StatusLogger;

public class CryptLogger
extends ILogger {
    private static final String[] VALID_PACKAGE_PREFIX_NAMES = new String[]{"com.huawei"};
    private static final String LOG_FILE_NAME = "log4j2.xml";
    private static final String FQCN = CryptLogger.class.getName();
    private static final List<Class<? extends Throwable>> SPECIAL_EXCEPTION_CLASSES = Arrays.asList(SecurityException.class, GeneralSecurityException.class, ClassNotFoundException.class, FileNotFoundException.class, JarException.class, MissingResourceException.class, NotOwnerException.class, ConcurrentModificationException.class, InsufficientResourcesException.class, BindException.class, OutOfMemoryError.class, StackOverflowError.class, SQLException.class);
    private static Logger RUN_LOG = Logger.getLogger(CryptLogger.class);

    private static void logging(Level level, Object message) {
        if (message instanceof Throwable) {
            message = CryptLogger.getErrorMessage((Throwable)message);
        }
        RUN_LOG.log(FQCN, (Priority)level, message, null);
    }

    public void error(String message) {
        CryptLogger.logging(Level.ERROR, message);
    }

    public void warn(String message) {
        CryptLogger.logging(Level.WARN, message);
    }

    public void info(String message) {
        CryptLogger.logging(Level.INFO, message);
    }

    public void debug(String message) {
        CryptLogger.logging(Level.DEBUG, message);
    }

    public void trace(String message) {
        CryptLogger.logging(Level.TRACE, message);
    }

    public static String getErrorMessage(Throwable exception) {
        StringBuilder strBuilder = new StringBuilder();
        if (null == exception) {
            return strBuilder.toString();
        }
        strBuilder.append("\n");
        Throwable t = exception;
        int index = 0;
        do {
            if (0 < index) {
                strBuilder.append("Caused by: ");
            }
            String message = t.getMessage();
            if (CryptLogger.isSpecialException(t)) {
                message = "***";
            }
            strBuilder.append(t.getClass().getName() + ": " + message + "\n");
            StackTraceElement[] elements = t.getStackTrace();
            CryptLogger.retrieveStackTraces(elements, strBuilder);
            t = t.getCause();
            ++index;
        } while (null != t);
        return strBuilder.toString();
    }

    private static boolean isSpecialException(Throwable exception) {
        for (Class<? extends Throwable> clazz : SPECIAL_EXCEPTION_CLASSES) {
            if (!clazz.isInstance(exception)) continue;
            return true;
        }
        return false;
    }

    private static void retrieveStackTraces(StackTraceElement[] elements, StringBuilder strBuilder) {
        int index = 0;
        for (StackTraceElement element : elements) {
            String clsName = element.getClassName();
            if (1 != ++index && !CryptLogger.isValidClass(clsName)) continue;
            strBuilder.append("   at   " + element.toString() + "\n");
        }
    }

    private static boolean isValidClass(String clsName) {
        for (String validClsName : VALID_PACKAGE_PREFIX_NAMES) {
            if (!clsName.startsWith(validClsName)) continue;
            return true;
        }
        return false;
    }

    private static void init() {
        URL url;
        System.setProperty("log4j.configDebug", "false");
        ClassLoader classLoader = CryptLogger.class.getClassLoader();
        String logFilePath = null;
        try {
            logFilePath = new File("").getCanonicalPath() + File.separator + LOG_FILE_NAME;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File file = new File(logFilePath);
        if (file.exists()) {
            Configurator.initialize((String)CryptLogger.class.getName(), (String)logFilePath);
        } else if (null != classLoader && null != (url = classLoader.getResource(logFilePath))) {
            try {
                Configurator.initialize(null, (ClassLoader)classLoader, (URI)url.toURI());
            }
            catch (Throwable t) {
                StatusLogger.getLogger().error("File not exists, cause by %s", (Object)CryptLogger.getErrorMessage(t));
            }
        }
    }

    static {
        if (null == Logger.getLogger(CryptLogger.class)) {
            CryptLogger.init();
        }
    }
}

