/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.kms;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.ism.drm.wcc.rest.client.ResponseResult;
import com.huawei.ism.drm.wcc.rest.client.RestAdapter;
import com.huawei.ism.drm.wcc.rest.client.RestClient;
import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.ism.drm.wcc.util.kms.model.request.Auth;
import com.huawei.ism.drm.wcc.util.kms.model.request.CreateProjectRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.Domain;
import com.huawei.ism.drm.wcc.util.kms.model.request.Identity;
import com.huawei.ism.drm.wcc.util.kms.model.request.Password;
import com.huawei.ism.drm.wcc.util.kms.model.request.Project;
import com.huawei.ism.drm.wcc.util.kms.model.request.ProjectRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.Scope;
import com.huawei.ism.drm.wcc.util.kms.model.request.TokenRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.UpdateUser;
import com.huawei.ism.drm.wcc.util.kms.model.request.UpdateUserRequest;
import com.huawei.ism.drm.wcc.util.kms.model.request.User;
import com.huawei.ism.drm.wcc.util.kms.model.response.ProjectList;
import com.huawei.ism.drm.wcc.util.kms.model.response.ProjectResponse;
import com.huawei.ism.drm.wcc.util.kms.model.response.TokenResponse;
import com.huawei.ism.drm.wcc.util.utils.SysPropertiesUtils;
import com.huawei.kmc.common.AppException;
import com.huawei.kmc.common.ILogger;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.NameValuePair;

public class IamAccessMgr {
    private static final ILogger LOG = new CryptLogger();
    private static final String IAM_DOMAIN = "iam-cache-proxy." + SysPropertiesUtils.getPropertyValue("config.hcs.domain");
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Optional<String> getToken() {
        try {
            RestClient client = new RestClient(IAM_DOMAIN, "26335");
            TokenRequest request = IamAccessMgr.buildSvcProjectTokenRequest();
            String requestStr = OBJECT_MAPPER.writeValueAsString((Object)request);
            ResponseResult response = client.doPost("/v3/auth/tokens?nocatalog", new HashMap<String, String>(), requestStr);
            if (response.isSuccess()) {
                CloseableHttpResponse responseInfo = response.getResponse();
                return Optional.of(Arrays.stream(responseInfo.getHeaders()).filter(header -> "X-Subject-Token".equalsIgnoreCase(header.getName())).findAny().map(NameValuePair::getValue)).orElse(Optional.empty());
            }
            if (response.getResponse().getCode() == 400) {
                LOG.info("Get token failed. Try to create project.");
                IamAccessMgr.createProject(client, "");
                return IamAccessMgr.postToken(client, requestStr);
            }
            LOG.error("Get token failed.");
            return Optional.empty();
        }
        catch (Exception e) {
            LOG.error(String.format(Locale.ENGLISH, "Get token catch exception. e:%s", e.getMessage()));
            return Optional.empty();
        }
    }

    public static Optional<String> getDomainToken(String domain, String userName, String pwd) {
        try {
            RestClient client = new RestClient(IAM_DOMAIN, "26335");
            TokenRequest request = IamAccessMgr.getTokenRequest(domain, userName, pwd);
            String requestStr = OBJECT_MAPPER.writeValueAsString((Object)request);
            return IamAccessMgr.postToken(client, requestStr);
        }
        catch (AppException e) {
            LOG.error(String.format(Locale.ENGLISH, "Create rest client failed. e:%s", e.getMessage()));
        }
        catch (JsonProcessingException e) {
            LOG.error(String.format(Locale.ENGLISH, "Parse request failed. e:%s", e.getMessage()));
        }
        return Optional.empty();
    }

    private static Optional<String> postToken(RestClient client, String requestStr) throws AppException {
        ResponseResult res = client.doPost("/v3/auth/tokens?nocatalog", new HashMap<String, String>(), requestStr);
        if (res.isSuccess()) {
            CloseableHttpResponse responseInfo = res.getResponse();
            return Optional.of(Arrays.stream(responseInfo.getHeaders()).filter(header -> "X-Subject-Token".equalsIgnoreCase(header.getName())).findAny().map(NameValuePair::getValue)).orElse(Optional.empty());
        }
        return Optional.empty();
    }

    public static String getProject(String token) throws Exception {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw new AppException("Token empty. Get project id failed.");
        }
        RestClient client = new RestClient(IAM_DOMAIN, "26335");
        Map<String, String> header = Collections.singletonMap("X-Auth-Token", token);
        ResponseResult response = client.doGet("/v3/projects?name=project_svc", header);
        if (response.isSuccess()) {
            String res = RestAdapter.getResponseContent(response.getResponse().getEntity());
            ProjectList projects = (ProjectList)OBJECT_MAPPER.readValue(res, ProjectList.class);
            if (projects.getProjects().isEmpty()) {
                LOG.info("Need create default project_svc.");
                return IamAccessMgr.createProject(client, "");
            }
            return projects.getProjects().get(0).getId();
        }
        LOG.error("Get project id from iam failed.");
        throw new AppException("Get project id from iam failed.");
    }

    public static String createProject(RestClient client, String token) throws Exception {
        String serviceToken = StringUtils.isEmpty((CharSequence)token) ? IamAccessMgr.getServiceToken(client) : token;
        Map<String, String> header = Collections.singletonMap("X-Auth-Token", serviceToken);
        String domainId = IamAccessMgr.getDomainId(client);
        CreateProjectRequest project = CreateProjectRequest.builder().name("project_svc").domainId(domainId).build();
        ProjectRequest projectRequest = ProjectRequest.builder().project(project).build();
        String request = OBJECT_MAPPER.writeValueAsString((Object)projectRequest);
        ResponseResult response = client.doPost("/v3/projects", header, request);
        if (response.isSuccess()) {
            LOG.info("Create project success.");
            String res = RestAdapter.getResponseContent(response.getResponse().getEntity());
            ProjectResponse projectResponse = (ProjectResponse)OBJECT_MAPPER.readValue(res, ProjectResponse.class);
            return projectResponse.getProject().getId();
        }
        LOG.error("Create project_svc failed.");
        throw new AppException("Create project_svc failed.");
    }

    private static String getDomainId(RestClient client) throws AppException, IOException {
        TokenRequest request = IamAccessMgr.buildSvcTokenRequest();
        String requestStr = OBJECT_MAPPER.writeValueAsString((Object)request);
        ResponseResult response = client.doPost("/v3/auth/tokens?nocatalog", new HashMap<String, String>(), requestStr);
        if (response.isSuccess()) {
            LOG.info("Get domain info success.");
            String res = RestAdapter.getResponseContent(response.getResponse().getEntity());
            TokenResponse tokenResponse = (TokenResponse)OBJECT_MAPPER.readValue(res, TokenResponse.class);
            return tokenResponse.getToken().getDomain().getId();
        }
        LOG.error("Get svc domain id failed.");
        throw new AppException("Get svc domain id failed.");
    }

    private static String getServiceToken(RestClient client) throws Exception {
        TokenRequest request = IamAccessMgr.buildServiceTokenRequest();
        ResponseResult response = client.doPost("/v3/auth/tokens?nocatalog", new HashMap<String, String>(), OBJECT_MAPPER.writeValueAsString((Object)request));
        if (response.isSuccess()) {
            CloseableHttpResponse responseInfo = response.getResponse();
            return Arrays.stream(responseInfo.getHeaders()).filter(header -> "X-Subject-Token".equalsIgnoreCase(header.getName())).findAny().map(NameValuePair::getValue).orElseThrow(() -> new Exception("Get op_service token failed."));
        }
        LOG.error("Get op_service token failed.");
        throw new AppException("Get op_service token failed.");
    }

    private static TokenRequest buildSvcTokenRequest() throws AppException {
        String pwdCipher = SysPropertiesUtils.getPropertyValue("op.svc.eReplicationPwd");
        String pwd = KmcInstance.decrypt(pwdCipher);
        return IamAccessMgr.getTokenRequest("op_svc_eReplication", "op_svc_eReplication", pwd);
    }

    private static TokenRequest buildServiceTokenRequest() throws AppException {
        String pwdCipher = SysPropertiesUtils.getPropertyValue("IAM.service.password");
        String pwd = KmcInstance.decrypt(pwdCipher);
        String opUserName = SysPropertiesUtils.getPropertyValue("IAM.service.name");
        String[] opUsers = opUserName.split(",");
        return IamAccessMgr.getTokenRequest("op_service", opUsers[0], pwd);
    }

    private static TokenRequest getTokenRequest(String domainName, String userName, String pwd) {
        Domain domain = Domain.builder().name(domainName).build();
        User user = User.builder().name(userName).password(pwd).domain(domain).build();
        Password password = Password.builder().user(user).build();
        Identity identity = Identity.builder().methods(Collections.singletonList("password")).password(password).build();
        Scope scope = Scope.builder().domain(domain).build();
        Auth auth = Auth.builder().identity(identity).scope(scope).build();
        TokenRequest request = new TokenRequest();
        request.setAuth(auth);
        return request;
    }

    private static TokenRequest buildSvcProjectTokenRequest() throws AppException {
        String pwdCipher = SysPropertiesUtils.getPropertyValue("op.svc.eReplicationPwd");
        String pwd = KmcInstance.decrypt(pwdCipher);
        Domain domain = Domain.builder().name("op_svc_eReplication").build();
        User user = User.builder().name("op_svc_eReplication").password(pwd).domain(domain).build();
        Password password = Password.builder().user(user).build();
        Identity identity = Identity.builder().methods(Collections.singletonList("password")).password(password).build();
        Project project = Project.builder().name("project_svc").build();
        Scope scope = Scope.builder().project(project).build();
        Auth auth = Auth.builder().identity(identity).scope(scope).build();
        TokenRequest request = new TokenRequest();
        request.setAuth(auth);
        return request;
    }

    public static Optional<String> modifyPwd(String pwd) {
        try {
            TokenRequest request = IamAccessMgr.buildSvcTokenRequest();
            String requestStr = OBJECT_MAPPER.writeValueAsString((Object)request);
            RestClient client = new RestClient(IAM_DOMAIN, "26335");
            ResponseResult res = client.doPost("/v3/auth/tokens?nocatalog", new HashMap<String, String>(), requestStr);
            Optional<Object> token = Optional.empty();
            String userId = null;
            if (res.isSuccess()) {
                CloseableHttpResponse responseInfo = res.getResponse();
                token = Optional.of(Arrays.stream(responseInfo.getHeaders()).filter(header -> "X-Subject-Token".equalsIgnoreCase(header.getName())).findAny().map(NameValuePair::getValue)).orElseThrow(() -> new Exception("Get op_svc_eReplication token failed."));
                String content = RestAdapter.getResponseContent(res.getResponse().getEntity());
                TokenResponse tokenResponse = (TokenResponse)OBJECT_MAPPER.readValue(content, TokenResponse.class);
                userId = tokenResponse.getToken().getUser().getId();
            }
            if (!token.isPresent() || StringUtils.isEmpty(userId)) {
                return Optional.of("Get op_svc_eReplication token or user id failed.");
            }
            Map<String, String> header2 = Collections.singletonMap("X-Auth-Token", token.get());
            String url = "/v3-ext/users/{user_id}".replace("{user_id}", userId);
            UpdateUser user = UpdateUser.builder().password(pwd).build();
            UpdateUserRequest userRequest = UpdateUserRequest.builder().user(user).build();
            ResponseResult response = client.doPut(url, header2, OBJECT_MAPPER.writeValueAsString((Object)userRequest));
            if (!response.isSuccess()) {
                return Optional.of("Iam return failed for modify pwd.");
            }
        }
        catch (Exception exception) {
            LOG.error(String.format(Locale.ENGLISH, "Modify pwd failed. exception: %s", exception.getMessage()));
            return Optional.of(exception.getMessage());
        }
        return Optional.empty();
    }
}

