/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.wcc.util.utils;

import com.huawei.ism.drm.wcc.util.kmc.CryptLogger;
import com.huawei.ism.drm.wcc.util.utils.SecureDirDetector;
import com.huawei.kmc.common.ILogger;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;

public class FileUtils {
    static ILogger LOGGER = new CryptLogger();

    public static boolean write(File targetFile, ByteBuffer contentBuffer) {
        if (targetFile == null || !targetFile.exists()) {
            LOGGER.error("file to write content to targetFile");
            return false;
        }
        if (contentBuffer == null) {
            LOGGER.error("can not write empty content to targetFile.");
            return false;
        }
        long fileLength = targetFile.length();
        try (RandomAccessFile raw = new RandomAccessFile(targetFile, "rws");){
            FileDescriptor fd = raw.getFD();
            raw.seek(fileLength);
            raw.write(contentBuffer.array());
            fd.sync();
        }
        catch (Exception e) {
            LOGGER.error("force writing script failed.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean checkFile(File targetFile) {
        if (targetFile == null) {
            LOGGER.error("targetFile check result is null.");
            return false;
        }
        if (!targetFile.exists()) {
            return false;
        }
        return targetFile.isFile();
    }

    public static boolean createFile(String descFileName) {
        File file = new File(descFileName);
        if (file.exists()) {
            LOGGER.info(descFileName + " is already exist.");
            return true;
        }
        if (descFileName.endsWith(File.separator)) {
            LOGGER.info(descFileName + " is dir , can not create dir.");
            return false;
        }
        if (!file.getParentFile().exists()) {
            if (!file.getParentFile().mkdirs()) {
                LOGGER.info("create file's path failed.");
            }
            try {
                SecureDirDetector.alterPermission(file.getParentFile().getCanonicalPath(), true);
            }
            catch (IOException e) {
                LOGGER.error("change dir permission failed");
                e.printStackTrace();
            }
        }
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

