/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.cce;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.sdk.cce.model.request.UpdateDeploymentStatusRequest;
import com.huawei.sdk.cce.model.response.cluster.ClusterList;
import com.huawei.sdk.cce.model.response.deployment.Deployment;
import com.huawei.sdk.cce.model.response.deployment.DeploymentList;
import com.huawei.sdk.cce.model.response.service.ServiceList;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.connector.http.RequestInvocation;
import com.huawei.sdk.connector.http.RestHttpClient;
import java.io.IOException;

public class CceClient {
    private static final Log LOG = LogFactory.getInstance(CceClient.class);

    public ClusterList getClusterList(Credential credential) throws ResponseException, ClientException, IOException {
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("api/v3/projects/" + credential.getProjectId() + "/clusters");
        LOG.info((Object)"Get cluster list url: %s", new Object[]{invocation.getUrl()});
        return (ClusterList)client.get(invocation, ClusterList.class);
    }

    public DeploymentList getDeploymentList(String clusterId, Credential credential) throws ResponseException, ClientException, IOException {
        String httpHead = "https://";
        String endpoint = credential.getEndpoint().replaceAll(httpHead, "");
        RestHttpClient client = new RestHttpClient(httpHead + clusterId + "." + endpoint, credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("apis/apps/v1/deployments");
        LOG.info((Object)"Get cluster: %s deployment list", new Object[]{clusterId});
        return (DeploymentList)client.get(invocation, DeploymentList.class);
    }

    public void updateDeployment(UpdateDeploymentStatusRequest request, Credential credential) throws ResponseException, ClientException, IOException {
        RequestInvocation invocation = new RequestInvocation();
        invocation.setHeader("Content-Type", "application/json-patch+json");
        invocation.setUrl("apis/apps/v1/namespaces/" + request.getNamespace() + "/deployments/" + request.getName() + "/scale");
        String reqStr = "[{\"op\": \"add\", \"path\": \"/spec/replicas\", \"value\": " + request.getReplicas() + "}]";
        invocation.setJsonStr(reqStr);
        LOG.info((Object)"Update deployment url %s, request body %s", new Object[]{invocation.getUrl(), reqStr});
        String httpHead = "https://";
        String endpoint = credential.getEndpoint().replaceAll(httpHead, "");
        RestHttpClient client = new RestHttpClient(httpHead + request.getClusterId() + "." + endpoint, credential);
        client.patch(invocation, Deployment.class);
    }

    public ServiceList getServiceList(String clusterId, Credential credential) throws ResponseException, ClientException, IOException {
        String httpHead = "https://";
        String endpoint = credential.getEndpoint().replaceAll(httpHead, "");
        RestHttpClient client = new RestHttpClient(httpHead + clusterId + "." + endpoint, credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl("api/v1/services");
        return (ServiceList)client.get(invocation, ServiceList.class);
    }
}

