/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.report.service.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroupLog;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.report.sdk.model.ProtectGroupStatisticInfo;
import com.huawei.ism.drm.report.sdk.service.IProtectGroupReportService;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;

@Service(Name="com.huawei.ism.drm.report.sdk.service.IProtectGroupReportService", Desc="", Interface=IProtectGroupReportService.class)
public class ProtectGroupReportServiceImpl
extends IsmBaseService
implements IProtectGroupReportService {
    private static final long ADMIN_USER_ID = 1L;
    private static final int MAX_CLOUMN = 6;
    private static Log logger = LogFactory.getInstance(ProtectGroupReportServiceImpl.class);
    private static final List<Integer> PROTECTGROUP_NOT_STATIST_TEMPLATES = Arrays.asList(0, 15, 23, 24);

    public List<ProtectGroupStatisticInfo> getAllProtectGroupExecutedInfo() {
        return this.getProtectPolicyExecutedInfos(DrmEnumDefine.REPORT_TIME_RANGE_E.ALL_TIME);
    }

    public List<ProtectGroupStatisticInfo> getAllProtectGroupExecutedInfo(Long userId) {
        return this.getProtectPolicyExecutedInfos(DrmEnumDefine.REPORT_TIME_RANGE_E.ALL_TIME, userId);
    }

    public Page pageQueryProtectGroupStatisticInfoByTimeRange(DrmEnumDefine.REPORT_TIME_RANGE_E rangeType, String orderBy, int pageSize, int currentPage, boolean isAsc) {
        logger.debug((Object)("rangeType:" + rangeType + ", orderBy:" + orderBy + ", pageSize:" + pageSize));
        List<ProtectGroupStatisticInfo> ppStatisticInfos = this.getProtectPolicyExecutedInfos(rangeType);
        Collections.sort(ppStatisticInfos, new CommonComparator(orderBy, isAsc));
        return Page.createPage((int)currentPage, (int)pageSize, ppStatisticInfos);
    }

    public Page pageQueryProtectGroupStatisticInfoByTimeRange(DrmEnumDefine.REPORT_TIME_RANGE_E rangeType, String orderBy, int pageSize, int currentPage, boolean isAsc, Long userId) {
        List<ProtectGroupStatisticInfo> ppStatisticInfos = this.getProtectGroupStatistics(userId);
        if (VerifyUtil.isEmpty(ppStatisticInfos)) {
            logger.debug((Object)"ppStatisticInfos is empty!");
            return new Page();
        }
        this.createProtectGroupStatistics(rangeType, ppStatisticInfos);
        Collections.sort(ppStatisticInfos, new CommonComparator(orderBy, isAsc));
        return Page.createPage((int)currentPage, (int)pageSize, ppStatisticInfos);
    }

    private List<ProtectGroupStatisticInfo> getProtectPolicyExecutedInfos(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange) {
        List<ProtectGroupStatisticInfo> statsList = this.getProtectGroupStatistics(1L);
        if (VerifyUtil.isEmpty(statsList)) {
            logger.debug((Object)("statsList is empty!timeRange:" + timeRange));
            return new ArrayList<ProtectGroupStatisticInfo>(0);
        }
        this.createProtectGroupStatistics(timeRange, statsList);
        return statsList;
    }

    private List<ProtectGroupStatisticInfo> getProtectPolicyExecutedInfos(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, Long userId) {
        List<ProtectGroupStatisticInfo> statsList = this.getProtectGroupStatistics(userId);
        if (VerifyUtil.isEmpty(statsList)) {
            logger.debug((Object)("statsList is empty!timeRange:" + timeRange));
            return new ArrayList<ProtectGroupStatisticInfo>(0);
        }
        this.createProtectGroupStatistics(timeRange, statsList);
        return statsList;
    }

    private List<ProtectGroupStatisticInfo> getProtectGroupStatistics(Long userId) {
        List<ProtectGroupStatisticInfo> allProtectGroupStatisticInfos = this.getAllPgExecuteReport(userId);
        List<ProtectGroupStatisticInfo> remoteProtectGroupStatisticInfos = this.getRemotePgExecuteReport(userId);
        ArrayList<ProtectGroupStatisticInfo> localProtectGroupStatisticInfos = new ArrayList<ProtectGroupStatisticInfo>();
        for (ProtectGroupStatisticInfo allProtectGroupStatisticInfo : allProtectGroupStatisticInfos) {
            boolean isExist = false;
            for (ProtectGroupStatisticInfo remoteProtectGroupStatisticInfo : remoteProtectGroupStatisticInfos) {
                if (!allProtectGroupStatisticInfo.getPgId().equals(remoteProtectGroupStatisticInfo.getPgId())) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            ProtectGroupStatisticInfo localProtectGroupStatisticInfo = new ProtectGroupStatisticInfo();
            localProtectGroupStatisticInfo.setPgId(allProtectGroupStatisticInfo.getPgId());
            localProtectGroupStatisticInfo.setPgName(allProtectGroupStatisticInfo.getPgName());
            localProtectGroupStatisticInfo.setProductSite(allProtectGroupStatisticInfo.getProductSite());
            localProtectGroupStatisticInfo.setRecoverySite(allProtectGroupStatisticInfo.getRecoverySite());
            localProtectGroupStatisticInfo.setReplicationType(allProtectGroupStatisticInfo.getReplicationType());
            localProtectGroupStatisticInfo.setPoType(allProtectGroupStatisticInfo.getPoType());
            localProtectGroupStatisticInfos.add(localProtectGroupStatisticInfo);
        }
        if (!VerifyUtil.isEmpty(localProtectGroupStatisticInfos)) {
            remoteProtectGroupStatisticInfos.addAll(localProtectGroupStatisticInfos);
        }
        return remoteProtectGroupStatisticInfos;
    }

    private List<ProtectGroupStatisticInfo> getAllPgExecuteReport(Long userId) {
        Object[] params = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("select distinct pg.pgId as id,pg.name as name,").append(" proSite.name as productSite, ").append(" pg.template.type as templateType, pg.poType as poType").append(" from ProtectGroup as pg,UserBizObject as ubo,Site as proSite where ");
        IBizScopeManager scopManager = (IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class);
        boolean isAdmin = scopManager.checkIsAdmin(userId);
        if (!isAdmin) {
            buffer.append("ubo.userId=? and ");
            params = new Object[]{userId, DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus()};
        } else {
            params = new Object[]{DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus()};
        }
        buffer.append("pg.uuid=ubo.objectId and proSite.siteId=pg.productSiteId ").append(" and pg.status<>? order by pg.name");
        List results = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(buffer.toString(), params);
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.debug((Object)"results is empty!");
            return new ArrayList<ProtectGroupStatisticInfo>(0);
        }
        ArrayList<ProtectGroupStatisticInfo> protectGroupStatisticInfos = new ArrayList<ProtectGroupStatisticInfo>(results.size());
        HashMap<String, ProtectGroupStatisticInfo> pg = new HashMap<String, ProtectGroupStatisticInfo>();
        for (Object obj : results) {
            Object[] pgValues;
            if (!(obj instanceof Object[]) || (pgValues = (Object[])obj).length != 5) continue;
            Object templateTypeStr = pgValues[3];
            if (templateTypeStr instanceof Integer && PROTECTGROUP_NOT_STATIST_TEMPLATES.contains((Integer)templateTypeStr)) {
                logger.debug((Object)("the protectgroup cannot be exported!templateTypeStr:" + templateTypeStr));
                continue;
            }
            ProtectGroupStatisticInfo protectGroupStatisticInfoStats = new ProtectGroupStatisticInfo();
            protectGroupStatisticInfos.add(protectGroupStatisticInfoStats);
            this.degradeMethod(pg, pgValues, protectGroupStatisticInfoStats);
            this.setRPO(protectGroupStatisticInfoStats);
        }
        return protectGroupStatisticInfos;
    }

    private List<ProtectGroupStatisticInfo> getRemotePgExecuteReport(Long userId) {
        Object[] params = null;
        StringBuffer buffer = new StringBuffer();
        buffer.append("select distinct pg.pgId as id,pg.name as name,").append("proSite.name as productSite,").append("pg.template.type as templateType,pg.poType as poType, recSite.name as recoverySite ").append(" from ProtectGroup as pg,UserBizObject as ubo,Site as proSite,").append("Site as recSite,ProtectGroupReplica as replica where ");
        IBizScopeManager scopManager = (IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class);
        boolean isAdmin = scopManager.checkIsAdmin(userId);
        if (!isAdmin) {
            buffer.append("ubo.userId=? and ");
            params = new Object[]{userId, DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus()};
        } else {
            params = new Object[]{DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus()};
        }
        buffer.append("pg.uuid=ubo.objectId and proSite.siteId=pg.productSiteId ").append(" and pg.pgId=replica.pg.pgId").append(" and recSite.siteId=replica.recoverySite and pg.status<>? order by pg.name");
        List results = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(buffer.toString(), params);
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.debug((Object)"results is empty!");
            return new ArrayList<ProtectGroupStatisticInfo>(0);
        }
        ArrayList<ProtectGroupStatisticInfo> protectGroupStatisticInfos = new ArrayList<ProtectGroupStatisticInfo>(results.size());
        HashMap<String, ProtectGroupStatisticInfo> pg = new HashMap<String, ProtectGroupStatisticInfo>();
        for (Object obj : results) {
            Object[] pgValues;
            if (!(obj instanceof Object[]) || (pgValues = (Object[])obj).length != 6) continue;
            Object templateTypeStr = pgValues[3];
            if (templateTypeStr instanceof Integer && PROTECTGROUP_NOT_STATIST_TEMPLATES.contains((Integer)templateTypeStr)) {
                logger.debug((Object)("the protectgroup cannot be exported!templateTypeStr:" + templateTypeStr));
                continue;
            }
            if (pgValues[0] instanceof String && pg.containsKey((String)pgValues[0])) {
                this.specialDealRecoverySite(pg, pgValues, templateTypeStr);
                continue;
            }
            ProtectGroupStatisticInfo protectGroupStatisticInfoStats = new ProtectGroupStatisticInfo();
            protectGroupStatisticInfos.add(protectGroupStatisticInfoStats);
            this.degradeMethod(pg, pgValues, protectGroupStatisticInfoStats);
            this.setRPO(protectGroupStatisticInfoStats);
        }
        return protectGroupStatisticInfos;
    }

    private void specialDealRecoverySite(Map<String, ProtectGroupStatisticInfo> pg, Object[] pgValues, Object templateTypeStr) {
        logger.debug((Object)("templateTypeStr:" + templateTypeStr));
        ProtectGroupStatisticInfo tmp = pg.get((String)pgValues[0]);
        if (tmp == null) {
            logger.warn((Object)"ProtectGroupStatisticInfo is null.");
            return;
        }
        if (templateTypeStr instanceof Integer) {
            int templateType = (Integer)templateTypeStr;
            Object recoverySite = pgValues[5];
            String recoverySiteStr = (String)recoverySite;
            List<Integer> doubleSiteTypes = Arrays.asList(19, 17, 28, 30, 31);
            if (doubleSiteTypes.contains(templateType)) {
                if (!tmp.getProductSite().equals(recoverySite)) {
                    tmp.setRecoverySite(recoverySiteStr);
                }
            } else {
                tmp.setRecoverySite(tmp.getRecoverySite() + "," + (String)recoverySite);
            }
        }
    }

    private void setRPO(ProtectGroupStatisticInfo protectGroupStatisticInfoStats) {
        String sql = "select PGID, PROPNAME, PROPVALUE from ti_protectgroup_prop where PGID = :PGID";
        String pgId = protectGroupStatisticInfoStats.getPgId();
        Map<String, Map<String, String>> props = this.groupPropItems(this.executeNativeSql(sql, "PGID", pgId));
        if (!VerifyUtil.isEmpty(props) && props.containsKey(pgId)) {
            logger.debug((Object)("props:" + props + ", pgId:" + pgId));
            Map<String, String> prop = props.get(pgId);
            protectGroupStatisticInfoStats.setProps(prop);
        }
    }

    private void degradeMethod(Map<String, ProtectGroupStatisticInfo> pg, Object[] pgValues, ProtectGroupStatisticInfo protectGroupStatisticInfoStats) {
        if (pgValues[0] instanceof String) {
            protectGroupStatisticInfoStats.setPgId((String)pgValues[0]);
            pg.put(protectGroupStatisticInfoStats.getPgId(), protectGroupStatisticInfoStats);
        }
        if (pgValues[1] instanceof String) {
            protectGroupStatisticInfoStats.setPgName((String)pgValues[1]);
        }
        if (pgValues[2] instanceof String) {
            protectGroupStatisticInfoStats.setProductSite((String)pgValues[2]);
        }
        if (pgValues[3] instanceof Integer) {
            protectGroupStatisticInfoStats.setReplicationType(((Integer)pgValues[3]).intValue());
        }
        if (pgValues[4] instanceof Integer) {
            protectGroupStatisticInfoStats.setPoType(((Integer)pgValues[4]).intValue());
        }
        if (pgValues.length == 5) {
            return;
        }
        if (pgValues[5] instanceof String) {
            protectGroupStatisticInfoStats.setRecoverySite((String)pgValues[5]);
        }
    }

    private void createProtectGroupStatistics(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, List<ProtectGroupStatisticInfo> statsList) {
        logger.debug((Object)("timeRange:" + timeRange));
        for (ProtectGroupStatisticInfo info : statsList) {
            this.setSuccessAndTotalNum(timeRange, info.getPgId(), info);
        }
    }

    private void setSuccessAndTotalNum(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, String protectGroupId, ProtectGroupStatisticInfo protectGroupStatistic) {
        logger.debug((Object)("timeRange:" + timeRange + ", protectGroupId:" + protectGroupId));
        int totalNum = 0;
        int successNum = 0;
        List<ProtectGroupLog> historyLogs = this.getAllHistoryLog(protectGroupId);
        if (!VerifyUtil.isEmpty(historyLogs)) {
            for (ProtectGroupLog historyLog : historyLogs) {
                Date curDate = new Date();
                long startTime = NumberUtil.convertToLong((Object)historyLog.getStartTime());
                if (DrmEnumDefine.REPORT_TIME_RANGE_E.ALL_TIME != timeRange && curDate.getTime() - timeRange.getValue() > startTime || 0 == historyLog.getFlag()) continue;
                ++totalNum;
                if (1L != historyLog.getResult()) continue;
                ++successNum;
            }
        }
        protectGroupStatistic.setSuccessNum(successNum);
        protectGroupStatistic.setTotalNum(totalNum);
    }

    private List<ProtectGroupLog> getAllHistoryLog(String protectGroupId) {
        String queryHQL = "select log.result as result,log.startTime as startTime,log.endTime as endTime,log.flag as flagVal from ProtectGroup as pg,ProtectGroupLog as log  where pg.pgId=? and pg.pgId=log.pgId";
        List results = CommonDAOLocator.getBaseDao().getHibernateTemplate().find(queryHQL, new Object[]{protectGroupId});
        if (VerifyUtil.isEmpty((Collection)results)) {
            logger.debug((Object)"results is empty!");
            return new ArrayList<ProtectGroupLog>(0);
        }
        ArrayList<ProtectGroupLog> historyLogs = new ArrayList<ProtectGroupLog>();
        for (Object obj : results) {
            Object[] logValues;
            if (!(obj instanceof Object[]) || (logValues = (Object[])obj).length != 4) continue;
            ProtectGroupLog historyLog = new ProtectGroupLog();
            historyLogs.add(historyLog);
            if (logValues[0] instanceof Long) {
                historyLog.setResult(((Long)logValues[0]).longValue());
            }
            if (logValues[1] instanceof String) {
                historyLog.setStartTime((String)logValues[1]);
            }
            if (logValues[2] instanceof String) {
                historyLog.setEndTime((String)logValues[2]);
            }
            if (!(logValues[3] instanceof Integer)) continue;
            historyLog.setFlag((Integer)logValues[3]);
        }
        return historyLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page pageQueryProtectGroupLog(int pageNum, int pageSize, Long userId) {
        List<Object> protectGroupLogs;
        Session session;
        block8: {
            session = null;
            protectGroupLogs = new ArrayList();
            try {
                session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
                String querySQL = "select pl.HISTORYLOGID, pl.INFO, pl.STARTTIME, pl.ENDTIME, case when pl.Flag=0 then 2 else pl.RESULT end as RESULT, pl.REPLICAID, pl.PGID, pg.PRODUCTSITEID, pg.PGNAME from TI_PROTECTGROUP pg inner join TI_PROTECTGROUPLOG pl on pl.PGID=pg.PGID  where pg.STATUS<>:pgStatus and pl.STARTTIME=(select MAX(STARTTIME) from TI_PROTECTGROUPLOG  where PGID=pg.PGID) order by pl.STARTTIME desc ";
                NativeQuery query = session.createSQLQuery(querySQL);
                query.setInteger("pgStatus", DrmEnumDefine.PROTECT_GROUP_STATUS.INVALID.getStatus());
                List list = query.list();
                if (VerifyUtil.isEmpty((Collection)list)) break block8;
                protectGroupLogs = this.constructProtectGroupLogs(list);
            }
            catch (Exception e) {
                try {
                    logger.error((Object)("pageQueryRecoveryLog failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
                }
                catch (Throwable throwable) {
                    DBOperationUtil.closeSession(session);
                    throw throwable;
                }
                DBOperationUtil.closeSession((Session)session);
            }
        }
        DBOperationUtil.closeSession((Session)session);
        ArrayList filterLogs = new ArrayList();
        filterLogs.addAll(protectGroupLogs);
        if (!VerifyUtil.isEmpty(protectGroupLogs)) {
            for (ProtectGroupLog protectGroupLog : protectGroupLogs) {
                try {
                    ((IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class)).checkUserGrantedObject(userId, protectGroupLog.getPgId());
                }
                catch (Exception e) {
                    filterLogs.remove(protectGroupLog);
                }
            }
        }
        return Page.createPage((int)pageNum, (int)pageSize, filterLogs);
    }

    public ProtectGroupStatisticInfo getProtectGroupExecutedInfo(String protectGroupId, DrmEnumDefine.REPORT_TIME_RANGE_E range, Long userId) {
        logger.debug((Object)("protectGroupId:" + protectGroupId + ", range:" + range));
        ProtectGroupStatisticInfo protectGroupStatisticInfo = new ProtectGroupStatisticInfo();
        this.setSuccessAndTotalNum(range, protectGroupId, protectGroupStatisticInfo);
        return protectGroupStatisticInfo;
    }

    public ProtectGroupStatisticInfo getRemoteProtectGroupExecutedInfo(String protectGroupId, DrmEnumDefine.REPORT_TIME_RANGE_E range, Long userId) {
        ProtectGroup protectGroup = ((IProtectGroupService)ServiceContext.getInstance().lookup("DRM_Base/" + IProtectGroupService.class.getName())).getProtectGroupByID(protectGroupId, false);
        String siteId = protectGroup.getProductSiteId();
        ProtectGroupStatisticInfo protectGroupStatisticInfo = new ProtectGroupStatisticInfo();
        Site site = ((ISiteService)ServiceContext.getInstance().lookup("DRM_Base/" + ISiteService.class.getName())).getSiteById(siteId);
        RestClient srcClient = SiteUtil.initClient((Site)site);
        try {
            protectGroupStatisticInfo = (ProtectGroupStatisticInfo)srcClient.getSerializableObject("/ws/protectgroups/getProtectGroupStatisticInfo?protectGroupId=" + protectGroupId + "&range=" + DrmEnumDefine.REPORT_TIME_RANGE_E.LAST_24_HOURS + "&userId=" + userId, ProtectGroupStatisticInfo.class);
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return protectGroupStatisticInfo;
    }

    protected Map<String, Map<String, String>> groupPropItems(List<?> props) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        if (null == props) {
            return map;
        }
        for (Object prop : props) {
            String id;
            HashMap<String, String> attrs;
            int i = 0;
            Object[] items = (Object[])prop;
            if (items == null || items.length < 3) {
                logger.error((Object)"ProtectGroupReportServiceImpl: items length error.", 90160758786989L);
                continue;
            }
            if ((attrs = (HashMap<String, String>)map.get(id = (String)items[i++])) == null) {
                attrs = new HashMap<String, String>();
                map.put(id, attrs);
            }
            attrs.put((String)items[i++], (String)items[i]);
        }
        return map;
    }

    protected List<ProtectGroupLog> constructProtectGroupLogs(List<?> results) {
        ArrayList<ProtectGroupLog> pgLogs = new ArrayList<ProtectGroupLog>();
        for (Object object : results) {
            Object[] values;
            if (!(object instanceof Object[]) || 9 != (values = (Object[])object).length) continue;
            ProtectGroupLog pgLog = new ProtectGroupLog();
            pgLog.setHistoryLogId(CommUtil.convertToInteger((Object)values[0]));
            pgLog.setInfo(CommUtil.convertToString((Object)values[1]));
            pgLog.setStartTime(CommUtil.convertToString((Object)values[2]));
            pgLog.setEndTime(CommUtil.convertToString((Object)values[3]));
            pgLog.setResult(CommUtil.convertToLong((Object)values[4]).longValue());
            pgLog.setReplicaId(CommUtil.convertToString((Object)values[5]));
            pgLog.setPgId(CommUtil.convertToString((Object)values[6]));
            pgLog.setPgName(CommUtil.convertToString((Object)values[8]));
            String productSiteId = CommUtil.convertToString((Object)values[7]);
            Site productSite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
            if (VerifyUtil.isEmpty((Object)productSite)) {
                logger.error((Object)("constructProtectGroupLogs error, site is null, siteId:" + productSiteId), 90160758787071L);
                continue;
            }
            pgLogs.add(pgLog);
        }
        return pgLogs;
    }

    private List<?> executeNativeSql(String sql, String name, Object value) {
        return this.executeNativeSql(sql, new String[]{name}, new Object[]{value});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> executeNativeSql(String sql, String[] names, Object[] values) {
        if (names.length != values.length) {
            logger.debug((Object)("names.length != values.length.names.length:" + names.length + ",values.length:" + values.length));
            throw new LegoCheckedException(-1L, "Skimble-scamble length");
        }
        Session session = CommonDAOLocator.getBaseDao().getHibernateTemplate().getSessionFactory().openSession();
        try {
            NativeQuery query = session.createSQLQuery(sql);
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                Object value = values[i];
                if (value instanceof Object[]) {
                    query.setParameterList(name, (Object[])value);
                    continue;
                }
                if (value instanceof Collection) {
                    query.setParameterList(name, (Collection)value);
                    continue;
                }
                query.setParameter(name, value);
            }
            List list = query.list();
            return list;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Execute native sql failed.", (long)-1L, null, (Log)logger);
            List<?> list = null;
            return list;
        }
        finally {
            DBOperationUtil.closeSession((Session)session);
        }
    }
}

