/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.report.service.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.CommonComparator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.constant.RecoveryPlanUse;
import com.huawei.ism.drm.drp.sdk.model.RecoveryLog;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryPlanService;
import com.huawei.ism.drm.report.sdk.model.TestStatisticInfo;
import com.huawei.ism.drm.report.sdk.service.ITestReportService;
import com.huawei.ism.drm.security.sdk.service.IBizScopeManager;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.hibernate.query.NativeQuery;

@Service(Name="com.huawei.ism.drm.report.sdk.service.ITestReportService", Desc="", Interface=ITestReportService.class)
public class TestReportServiceImpl
extends IsmBaseService
implements ITestReportService {
    private static final long ADMIN_USER_ID = 1L;
    private static final int MAX_COLUMN = 5;
    private static final int NUM_INDEX_ZERO = 0;
    private static final int NUM_SEVEN = 7;
    private static final long FIFTEENMIN = 900000L;
    private static final long THIRTYMIN = 1800000L;
    private static final long SIXTYMIN = 3600000L;
    private static Log logger = LogFactory.getInstance(TestReportServiceImpl.class);

    public List<TestStatisticInfo> getAllTestStatisticInfo() {
        return this.getAllTestStatisticInfo(DrmEnumDefine.REPORT_TIME_RANGE_E.ALL_TIME);
    }

    public List<TestStatisticInfo> getAllTestStatisticInfo(Long userId) {
        return this.getAllTestStatisticInfo(DrmEnumDefine.REPORT_TIME_RANGE_E.ALL_TIME, userId);
    }

    public Page pageQueryTestStatisticInfoByTimeRange(DrmEnumDefine.REPORT_TIME_RANGE_E rangeType, String orderBy, int pageSize, int currentPage, boolean isAsc) {
        List<TestStatisticInfo> testStatInfos = this.getAllTestStatisticInfo(rangeType);
        Collections.sort(testStatInfos, new CommonComparator(orderBy, isAsc));
        return Page.createPage((int)currentPage, (int)pageSize, testStatInfos);
    }

    public Page pageQueryTestStatisticInfoByTimeRange(DrmEnumDefine.REPORT_TIME_RANGE_E rangeType, String orderBy, int pageSize, int currentPage, boolean isAsc, Long userId) {
        List<TestStatisticInfo> testStats = this.getTestStatsByRecoveryPlan(userId);
        if (VerifyUtil.isEmpty(testStats)) {
            logger.trace((Object)"the testStats is null");
            return new Page();
        }
        Page page = Page.createPage((int)currentPage, (int)pageSize, testStats);
        Collections.sort(page.getResult(), new CommonComparator(orderBy, isAsc));
        this.createTestStatsByRp(rangeType, page.getResult());
        return page;
    }

    public List<TestStatisticInfo> getAllTestStatisticInfo(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange) {
        List<TestStatisticInfo> testStats = this.getTestStatsByRecoveryPlan(1L);
        if (VerifyUtil.isEmpty(testStats)) {
            logger.trace((Object)"the testStats is null");
            return new ArrayList<TestStatisticInfo>(0);
        }
        this.createTestStatsByRp(timeRange, testStats);
        return testStats;
    }

    public List<TestStatisticInfo> getAllTestStatisticInfo(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, Long userId) {
        List<TestStatisticInfo> testStats = this.getTestStatsByRecoveryPlan(userId);
        if (VerifyUtil.isEmpty(testStats)) {
            logger.trace((Object)"the testStats is null");
            return new ArrayList<TestStatisticInfo>(0);
        }
        this.createTestStatsByRp(timeRange, testStats);
        return testStats;
    }

    public List<TestStatisticInfo> getAllTestStatisticInfo(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, Long userId, String siteId) {
        List<TestStatisticInfo> testStats = this.getTestStatsByRecoveryPlan(userId, siteId);
        if (VerifyUtil.isEmpty(testStats)) {
            logger.debug((Object)("the testStats is null, the siteId is " + siteId));
            return new ArrayList<TestStatisticInfo>(0);
        }
        this.createTestStatsByRp(timeRange, testStats);
        return testStats;
    }

    public List<TestStatisticInfo> getOnlyTestStatisticInfo(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, Long userId, String siteId) {
        List<TestStatisticInfo> testStats = this.getTestStatsByRecoveryPlan(userId, siteId);
        if (VerifyUtil.isEmpty(testStats)) {
            logger.debug((Object)"the testStats is null, the siteId is %s ", new Object[]{siteId});
            return new ArrayList<TestStatisticInfo>(0);
        }
        for (TestStatisticInfo testStat : testStats) {
            this.setTestStatisticPropertiesInfo(timeRange, testStat);
        }
        return testStats;
    }

    private void createTestStatsByRp(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, List<TestStatisticInfo> testStats) {
        for (TestStatisticInfo testStat : testStats) {
            this.setTestStatisticPropertiesInfo(timeRange, testStat);
        }
    }

    private IRecoveryPlanService getRPService() {
        IRecoveryPlanService rpService = (IRecoveryPlanService)ServiceLocator.getInstance().getService(IRecoveryPlanService.class);
        return rpService;
    }

    private void setTestStatisticPropertiesInfo(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, TestStatisticInfo testStat) {
        List testRecoveryPlanLogs = this.getRPService().getHistoryRecoveryLogsByPlanIdAndTypeAndResult(timeRange, testStat.getPlanId(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER, null, testStat.getRecoverySiteId());
        String reProtectEndTime = this.getHeavyProtectionTime(testStat.getPlanId());
        if (!VerifyUtil.isEmpty((String)reProtectEndTime)) {
            List recoveryPlanLogs = this.getRPService().getHistoryRecoveryLogsByPlanIdAndTypeAndResult(timeRange, testStat.getPlanId(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER, testStat.getRecoverySiteId(), testStat.getProductSiteId());
            if (VerifyUtil.isEmpty((Collection)testRecoveryPlanLogs)) {
                logger.error((Object)"the recoveryPlanLogs is null");
                return;
            }
            List<RecoveryLog> repRecoveryPlanLogs = this.addToTestLogs(recoveryPlanLogs, reProtectEndTime);
            repRecoveryPlanLogs.addAll(testRecoveryPlanLogs);
            testRecoveryPlanLogs = repRecoveryPlanLogs.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<RecoveryLog>(Comparator.comparing(o -> o.getLogId()))), ArrayList::new));
        }
        this.setProperties(timeRange, testStat, testRecoveryPlanLogs);
    }

    private void setTestStatisticProperties(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, TestStatisticInfo testStat) {
        List recoveryPlanLogs = this.getRPService().getHistoryReocveryLogsByPlanId(testStat.getPlanId());
        ArrayList<RecoveryLog> testRecoveryPlanLogs = new ArrayList();
        ArrayList<RecoveryLog> heavyProtectionLogs = new ArrayList<RecoveryLog>();
        for (RecoveryLog recoverylog : recoveryPlanLogs) {
            if (recoverylog.getLogType() != 7 || recoverylog.getLogStatus() != 0) continue;
            heavyProtectionLogs.add(recoverylog);
        }
        if (!VerifyUtil.isEmpty(heavyProtectionLogs)) {
            testRecoveryPlanLogs = this.addToTestLogs(testStat, recoveryPlanLogs, heavyProtectionLogs);
        } else {
            for (RecoveryLog recoverylog : recoveryPlanLogs) {
                String recoverySiteId = recoverylog.getRecoverySiteId();
                Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
                if (!site.getName().equals(testStat.getRecoverySite())) continue;
                testRecoveryPlanLogs.add(recoverylog);
            }
        }
        if (VerifyUtil.isEmpty((Collection)recoveryPlanLogs)) {
            logger.trace((Object)"the recoveryPlanLogs is null");
            return;
        }
        this.setProperties(timeRange, testStat, testRecoveryPlanLogs);
    }

    private List<RecoveryLog> addToTestLogs(TestStatisticInfo testStat, List<RecoveryLog> recoveryPlanLogs, List<RecoveryLog> heavyProtectionLogs) {
        String endStartTime = this.getHeavyProtectionTime(heavyProtectionLogs);
        ArrayList<RecoveryLog> logs = new ArrayList<RecoveryLog>();
        for (RecoveryLog recoverylog : recoveryPlanLogs) {
            String recoverySiteId = recoverylog.getRecoverySiteId();
            Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(recoverySiteId);
            String productSiteId = recoverylog.getProductionSiteId();
            Site prosite = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(productSiteId);
            if (!this.checkLogParam(testStat, endStartTime, recoverylog, site, prosite)) continue;
            logs.add(recoverylog);
        }
        ArrayList<RecoveryLog> testRecoveryPlanLogs = logs;
        logger.trace((Object)("testRecoveryPlanLogs size: " + testRecoveryPlanLogs.size()));
        return testRecoveryPlanLogs;
    }

    private List<RecoveryLog> addToTestLogs(List<RecoveryLog> recoveryPlanLogs, String endStartTime) {
        ArrayList<RecoveryLog> logs = new ArrayList<RecoveryLog>();
        for (RecoveryLog recoverylog : recoveryPlanLogs) {
            if (NumberUtil.convertToLong((Object)recoverylog.getStartTime()) <= NumberUtil.convertToLong((Object)endStartTime)) continue;
            logs.add(recoverylog);
        }
        logger.debug((Object)"testRecoveryPlanLogs size: %s", (long)logs.size());
        return logs;
    }

    private boolean checkLogParam(TestStatisticInfo testStat, String endStartTime, RecoveryLog recoverylog, Site site, Site prosite) {
        return NumberUtil.convertToLong((Object)recoverylog.getStartTime()) > NumberUtil.convertToLong((Object)endStartTime) && (site.getName().equals(testStat.getProductSite()) && prosite.getName().equals(testStat.getRecoverySite()) || site.getName().equals(testStat.getRecoverySite()));
    }

    private String getHeavyProtectionTime(List<RecoveryLog> heavyProtectionLogs) {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(heavyProtectionLogs);
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j <= i; ++j) {
                if (NumberUtil.convertToLong((Object)((RecoveryLog)list.get(j)).getStartTime()) >= NumberUtil.convertToLong((Object)((RecoveryLog)list.get(i)).getStartTime())) continue;
                RecoveryLog temp = (RecoveryLog)list.get(i);
                list.set(i, list.get(j));
                list.set(j, temp);
            }
        }
        logger.trace((Object)("heavyProtectionLogs size is: " + list.size()));
        return ((RecoveryLog)list.get(0)).getEndTime();
    }

    private String getHeavyProtectionTime(String planId) {
        List results = (List)CommonDAOLocator.getBaseDao().getHibernateTemplate().execute(session -> {
            StringBuffer buffer = new StringBuffer();
            buffer.append("select endtime from ti_recoverylog where logtype=").append(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue()).append("and logstatus = ").append(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            if (!VerifyUtil.isEmpty((String)planId)) {
                buffer.append("and planId=:planId ");
            }
            buffer.append("order by startTime limit 1");
            NativeQuery q = session.createSQLQuery(buffer.toString());
            if (!VerifyUtil.isEmpty((String)planId)) {
                q.setParameter("planId", (Object)planId);
            }
            return q.list();
        });
        if (null == results || results.isEmpty()) {
            logger.debug((Object)"results is null");
            return null;
        }
        return results.get(0).toString();
    }

    private void setProperties(DrmEnumDefine.REPORT_TIME_RANGE_E timeRange, TestStatisticInfo testStat, List<RecoveryLog> recoveryPlanLogs) {
        int totalNum = 0;
        int successNum = 0;
        long minTime = 0L;
        long maxTime = 0L;
        double sumTime = 0.0;
        boolean isMinInit = true;
        boolean isMaxInit = true;
        for (int index = 0; index < recoveryPlanLogs.size(); ++index) {
            RecoveryLog recoveryLog = recoveryPlanLogs.get(index);
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() != recoveryLog.getLogType()) continue;
            int exeResult = recoveryLog.getLogStatus();
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue() == exeResult) continue;
            Date curDate = new Date();
            long startTime = NumberUtil.convertToLong((Object)recoveryLog.getStartTime());
            if (DrmEnumDefine.REPORT_TIME_RANGE_E.ALL_TIME != timeRange && curDate.getTime() - timeRange.getValue() > startTime) continue;
            ++totalNum;
            long endTime = NumberUtil.convertToLong((Object)recoveryLog.getEndTime());
            long exeTime = endTime - startTime;
            sumTime += (double)exeTime;
            if (isMinInit) {
                minTime = exeTime;
                isMinInit = false;
            }
            if (isMaxInit) {
                maxTime = exeTime;
                isMaxInit = false;
            }
            if (exeTime < minTime) {
                minTime = exeTime;
            }
            if (exeTime > maxTime) {
                maxTime = exeTime;
            }
            if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue() != exeResult) continue;
            ++successNum;
            this.setTestTimeConsumDistributing(exeTime, testStat);
        }
        double aveTime = 0 == totalNum ? 0.0 : sumTime / (double)totalNum;
        testStat.setAverageTime(aveTime);
        testStat.setMaximumTime(maxTime);
        testStat.setMinimumTime(minTime);
        testStat.setSuccessNum(successNum);
        testStat.setTotalNum(totalNum);
        logger.trace((Object)("testStat is: " + testStat.getPlanId()));
    }

    private void setTestTimeConsumDistributing(long exeTime, TestStatisticInfo testStat) {
        logger.trace((Object)("exeTime: " + exeTime));
        if (exeTime > 3600000L) {
            int extendSixty = testStat.getOtherTimes();
            testStat.setOtherTimes(++extendSixty);
        } else if (exeTime > 1800000L) {
            int time30To60 = testStat.getLess60minTimes();
            testStat.setLess60minTimes(++time30To60);
        } else if (exeTime > 900000L) {
            int time15To30 = testStat.getLess30minTimes();
            testStat.setLess30minTimes(++time15To30);
        } else {
            int time0To15 = testStat.getLess15minTimes();
            testStat.setLess15minTimes(++time0To15);
        }
    }

    private List<TestStatisticInfo> getTestStatsByRecoveryPlan(Long userId) {
        return this.getTestStatsByRecoveryPlan(userId, null);
    }

    private List<TestStatisticInfo> getTestStatsByRecoveryPlan(Long userId, String siteId) {
        List results = (List)CommonDAOLocator.getBaseDao().getHibernateTemplate().execute(session -> {
            IBizScopeManager scopManager = (IBizScopeManager)ServiceLocator.getInstance().getService(IBizScopeManager.class);
            boolean isAdmin = scopManager.checkIsAdmin(userId);
            StringBuffer buffer = new StringBuffer();
            buffer.append("select distinct rp.PLANID as id,rp.PLANNAME as name,").append("proSite.siteName as productSite,recSite.siteName as recoverySite,").append("pg.poType as poType,").append("recSite.siteId as proSiteId,").append("recSite.siteId as recSiteId, ").append("policytemplate.Type as pgType ").append("from ti_protectgroup as pg,ti_recoveryplan as rp,").append("ti_site as proSite,ti_site as recSite,ti_protectgroupreplica as replica ,ti_policytemplate as policytemplate,").append("ti_drp_r_pg as drp_pg,ti_user_r_biz as ubo where ");
            if (!isAdmin) {
                buffer.append("ubo.USERID=:_userId and ");
            }
            if (!VerifyUtil.isEmpty((String)siteId)) {
                buffer.append("proSite.siteId=:_siteId and ");
            }
            buffer.append("rp.UUID=ubo.OBJECTID and  ").append("proSite.siteId=(select drs.siteId from ti_dr_resource drs ").append("where drs.devicesn=replica.PROARRAYID) ").append("and recSite.siteId=replica.RECSITEID ").append("and pg.PGID=replica.PGID ").append("and drp_pg.PLANID=rp.PLANID and drp_pg.PGID=pg.PGID and rp.PLANUSE != " + RecoveryPlanUse.INTERNAL_USE.getValue()).append(" and rp.PLANID in (select distinct rproc.planId from ti_RecoveryProcessDefinition as rproc where rproc.procType=7) ").append("and pg.PGID not in (select distinct pgId from ti_protectgroup_prop as pgProp where pgProp.PROPNAME ='PROP_KEY_VSTORE_PAIR_ID') ").append("and pg.PTID=policytemplate.uuid ").append("order by rp.PLANNAME");
            NativeQuery q = session.createSQLQuery(buffer.toString());
            if (!isAdmin) {
                q.setParameter("_userId", (Object)userId);
            }
            if (!VerifyUtil.isEmpty((String)siteId)) {
                q.setParameter("_siteId", (Object)siteId);
            }
            return q.list();
        });
        if (null == results || results.isEmpty()) {
            logger.trace((Object)"results is null");
            return new ArrayList<TestStatisticInfo>(0);
        }
        return this.constructTestStatsWithFilter(results);
    }

    private List<TestStatisticInfo> constructTestStats(List<?> results) {
        ArrayList<TestStatisticInfo> testStats = new ArrayList<TestStatisticInfo>(results.size());
        for (Object obj : results) {
            Object[] recoverPlanValues;
            if (!(obj instanceof Object[]) || (recoverPlanValues = (Object[])obj).length != 5) continue;
            TestStatisticInfo testStatsInfo = new TestStatisticInfo();
            testStats.add(testStatsInfo);
            this.setProperties(recoverPlanValues, testStatsInfo);
        }
        logger.trace((Object)("testStats size: " + testStats.size()));
        return testStats;
    }

    private List<TestStatisticInfo> constructTestStatsWithFilter(List<?> results) {
        ArrayList<TestStatisticInfo> testStats = new ArrayList<TestStatisticInfo>(results.size());
        for (Object obj : results) {
            Object[] recoverPlanValues;
            if (!(obj instanceof Object[]) || (recoverPlanValues = (Object[])obj).length != 8) continue;
            TestStatisticInfo testStatsInfo = new TestStatisticInfo();
            this.setProperties(recoverPlanValues, testStatsInfo);
            if (!this.existDrilling(testStatsInfo)) continue;
            testStats.add(testStatsInfo);
        }
        logger.debug((Object)("testStats size: " + testStats.size()));
        return testStats;
    }

    private boolean existDrilling(TestStatisticInfo testStatsInfo) {
        boolean existDrilling = true;
        if (PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(testStatsInfo.getPgType())) {
            existDrilling = !testStatsInfo.getProductSite().equals(testStatsInfo.getRecoverySite());
        }
        return existDrilling;
    }

    private void setProperties(Object[] recoverPlanValues, TestStatisticInfo testStatsInfo) {
        if (recoverPlanValues[0] instanceof String) {
            testStatsInfo.setPlanId((String)recoverPlanValues[0]);
        }
        if (recoverPlanValues[1] instanceof String) {
            testStatsInfo.setPlanName((String)recoverPlanValues[1]);
        }
        if (recoverPlanValues[2] instanceof String) {
            testStatsInfo.setProductSite((String)recoverPlanValues[2]);
        }
        if (recoverPlanValues[3] instanceof String) {
            testStatsInfo.setRecoverySite((String)recoverPlanValues[3]);
        }
        if (recoverPlanValues[4] instanceof BigDecimal) {
            testStatsInfo.setPoType(((BigDecimal)recoverPlanValues[4]).intValue());
        } else if (recoverPlanValues[4] instanceof Integer) {
            testStatsInfo.setPoType(((Integer)recoverPlanValues[4]).intValue());
        }
        if (recoverPlanValues[5] instanceof String) {
            testStatsInfo.setProductSiteId((String)recoverPlanValues[5]);
        }
        if (recoverPlanValues[6] instanceof String) {
            testStatsInfo.setRecoverySiteId((String)recoverPlanValues[6]);
        }
        if (recoverPlanValues[7] instanceof BigDecimal) {
            testStatsInfo.setPgType(((BigDecimal)recoverPlanValues[7]).intValue());
        } else if (recoverPlanValues[7] instanceof Integer) {
            testStatsInfo.setPgType(((Integer)recoverPlanValues[7]).intValue());
        }
    }
}

