/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.cce.executor;

import com.huawei.csr.app.cce.dao.CceInfoDao;
import com.huawei.csr.app.cce.dao.model.CceInfo;
import com.huawei.csr.app.cce.service.CceService;
import com.huawei.csr.framework.common.constants.RecoverStepAction;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.utils.EndpointUtil;
import com.huawei.csr.framework.core.executor.AbstractStepExecutor;
import com.huawei.csr.framework.core.executor.PollingStrategy;
import com.huawei.csr.framework.core.executor.StepExecuteContext;
import com.huawei.csr.framework.core.identifier.StepIdentifier;
import com.huawei.csr.framework.dao.ServiceInstanceDao;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.csr.framework.dao.model.RecoverStep;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.cce.CceClient;
import com.huawei.sdk.cce.model.request.UpdateDeploymentStatusRequest;
import com.huawei.sdk.cce.model.response.deployment.Deployment;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;

public class StopContainerExecutor
extends AbstractStepExecutor {
    private static final Log logger = LogFactory.getInstance(StopContainerExecutor.class);
    private CceService cceService;
    private PollingStrategy ccePoller;
    private CceInfoDao cceInfoDao;

    public StopContainerExecutor() {
        this.setStepIdentifier(new StepIdentifier(ServiceType.CCE.getValue(), RecoverStepAction.STOP_CONTAINER.getValue()));
    }

    public void work(RecoverStep step, StepExecuteContext executeContext) throws ResponseException, ClientException, IOException {
        AppServiceInstance instance = ((ServiceInstanceDao)ServiceLocator.getInstance().getService(ServiceInstanceDao.class)).getServiceInstanceById(step.getServiceInstanceId());
        CceInfo cceInfo = this.cceInfoDao.getCceInfo(instance.getInstanceId());
        if (VerifyUtil.isEmpty((Object)cceInfo) || cceInfo.getReplicaCount() == 0) {
            logger.error((Object)"Query cce result is null or replicaCount is zero.");
            return;
        }
        UpdateDeploymentStatusRequest request = new UpdateDeploymentStatusRequest();
        request.setClusterId(cceInfo.getClusterId());
        request.setNamespace(cceInfo.getNameSpace());
        request.setName(cceInfo.getName());
        request.setReplicas(0);
        CceClient client = (CceClient)ServiceLocator.getInstance().getService(CceClient.class);
        Credential credential = new Credential(executeContext.getRequestContext().getProjectId(), executeContext.getRequestContext().getAuthToken(), EndpointUtil.getEndpoint((String)step.getServiceType(), (String)instance.getPdRegionId()));
        client.updateDeployment(request, credential);
        this.ccePoller.executePoller(executeContext, context -> {
            Deployment result = this.cceService.getDeploymentById(instance.getInstanceId(), credential, true);
            if (VerifyUtil.isEmpty((Object)result)) {
                logger.debug((Object)"Query deployment result is null.");
                return false;
            }
            return result.getStatus().getReplicas() == 0;
        });
    }

    public CceService getCceService() {
        return this.cceService;
    }

    public void setCceService(CceService cceService) {
        this.cceService = cceService;
    }

    public PollingStrategy getCcePoller() {
        return this.ccePoller;
    }

    public void setCcePoller(PollingStrategy ccePoller) {
        this.ccePoller = ccePoller;
    }

    public CceInfoDao getCceInfoDao() {
        return this.cceInfoDao;
    }

    public void setCceInfoDao(CceInfoDao cceInfoDao) {
        this.cceInfoDao = cceInfoDao;
    }
}

