/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.csr.app.cce.service;

import com.huawei.csr.app.cce.dao.CceInfoDao;
import com.huawei.csr.app.cce.dao.model.CceInfo;
import com.huawei.csr.app.cce.service.CceService;
import com.huawei.csr.framework.common.constants.ServiceType;
import com.huawei.csr.framework.common.model.plugin.ServiceInstanceFilter;
import com.huawei.csr.framework.common.statusopt.status.ReplicaStatus;
import com.huawei.csr.framework.common.statusopt.status.ServiceInstanceStatus;
import com.huawei.csr.framework.dao.model.AppServiceInstance;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.cce.CceClient;
import com.huawei.sdk.cce.model.ClusterSpec;
import com.huawei.sdk.cce.model.DeploymentMatchLabels;
import com.huawei.sdk.cce.model.DeploymentMetadata;
import com.huawei.sdk.cce.model.DeploymentSelector;
import com.huawei.sdk.cce.model.DeploymentSpec;
import com.huawei.sdk.cce.model.response.cluster.Cluster;
import com.huawei.sdk.cce.model.response.cluster.ClusterList;
import com.huawei.sdk.cce.model.response.deployment.Deployment;
import com.huawei.sdk.cce.model.response.deployment.DeploymentList;
import com.huawei.sdk.cce.model.response.service.Service;
import com.huawei.sdk.cce.model.response.service.ServiceList;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;

public class CceServiceImpl
implements CceService {
    private static final Log logger = LogFactory.getInstance(CceServiceImpl.class);
    private static final String MULTI_AZ = "multi_az";
    private static final String CLUSTER_IP = "ClusterIP";
    private CceClient cceClient;
    private CceInfoDao cceInfoDao;

    @Override
    public List<AppServiceInstance> queryClusterList(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        logger.debug((Object)"Start queryClusterList, pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s, projectId: %s, endpoint: %s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId(), credential.getProjectId(), credential.getEndpoint()});
        ClusterList clusterList = this.cceClient.getClusterList(credential);
        return this.convertCluster2ServiceInstances(clusterList, filter);
    }

    @Override
    public List<AppServiceInstance> queryDeploymentList(ServiceInstanceFilter filter, Credential credential) throws ResponseException, ClientException, IOException {
        logger.debug((Object)"Start queryDeploymentList, pdRegionId: %s, drRegionId: %s, pdAzId: %s, drAzId:%s, projectId: %s, endpoint: %s", new Object[]{filter.getPdRegionId(), filter.getDrRegionId(), filter.getPdAzId(), filter.getDrAzId(), credential.getProjectId(), credential.getEndpoint()});
        if (!this.checkRegionAz(filter)) {
            logger.error((Object)"cce(%s) checkRegionAz failed.", new Object[]{filter.getInstanceId()});
            return Collections.emptyList();
        }
        List<AppServiceInstance> clusterList = this.queryClusterList(filter, credential);
        ArrayList<AppServiceInstance> deploymentListResponse = new ArrayList<AppServiceInstance>();
        for (AppServiceInstance cluster : clusterList) {
            DeploymentList deploymentList = this.cceClient.getDeploymentList(cluster.getInstanceId(), credential);
            ServiceList serviceList = this.cceClient.getServiceList(cluster.getInstanceId(), credential);
            List<AppServiceInstance> instances = this.convertDeployment2ServiceInstanceList(deploymentList, serviceList, filter);
            deploymentListResponse.addAll(instances);
        }
        return deploymentListResponse;
    }

    @Override
    public AppServiceInstance queryDeployment(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        logger.debug((Object)"Start queryDeployment, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        Deployment deployment = this.getDeploymentById(serviceInstanceId, credential, false);
        AppServiceInstance appServiceInstance = new AppServiceInstance();
        if (!Optional.ofNullable(deployment).map(Deployment::getMetadata).isPresent()) {
            return appServiceInstance;
        }
        CceInfo cceInfo = this.cceInfoDao.getCceInfo(deployment.getMetadata().getUid());
        ServiceList serviceList = this.cceClient.getServiceList(cceInfo.getClusterId(), credential);
        List<Service> services = serviceList.getItems().stream().filter(service -> CLUSTER_IP.equals(service.getSpec().getType())).collect(Collectors.toList());
        appServiceInstance = this.convertDeployment2ServiceInstance(deployment, services, null);
        appServiceInstance.setReplicaStatus(ReplicaStatus.NORMAL.getValue());
        return appServiceInstance;
    }

    @Override
    public Deployment getDeploymentById(String serviceInstanceId, Credential credential, boolean isChecking) throws ResponseException, ClientException, IOException {
        logger.debug((Object)"Start getDeploymentById, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        Pair<Deployment, String> pair = this.getDeploymentInClusters(serviceInstanceId, credential);
        if (VerifyUtil.isEmpty((Object)pair.getLeft())) {
            logger.error((Object)"Pair is empty, serviceInstanceId: %s", new Object[]{serviceInstanceId});
            return new Deployment();
        }
        if (!isChecking) {
            this.saveCceInfo((Deployment)pair.getLeft(), (String)pair.getRight(), credential.getProjectId());
        }
        return (Deployment)pair.getLeft();
    }

    private Pair<Deployment, String> getDeploymentInClusters(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        logger.debug((Object)"Start getDeploymentInClusters, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        ClusterList clusterList = this.cceClient.getClusterList(credential);
        for (Cluster cluster : clusterList.getItems()) {
            String clusterId = cluster.getMetadata().getUid();
            DeploymentList deploymentList = this.cceClient.getDeploymentList(clusterId, credential);
            for (Deployment deployment : deploymentList.getItems()) {
                if (!serviceInstanceId.equals(deployment.getMetadata().getUid())) continue;
                return Pair.of((Object)deployment, (Object)clusterId);
            }
        }
        return Pair.of(null, null);
    }

    @Override
    public boolean isProtectableServiceInstance(String serviceInstanceId, Credential credential) throws ResponseException, ClientException, IOException {
        logger.debug((Object)"Start isProtectableServiceInstance, serviceInstanceId: %s, projectId: %s, endpoint: %s", new Object[]{serviceInstanceId, credential.getProjectId(), credential.getEndpoint()});
        Deployment deployment = this.getDeploymentById(serviceInstanceId, credential, false);
        return deployment.getStatus().getReplicas() > 0 && deployment.getStatus().getReplicas() == deployment.getStatus().getAvailableReplicas();
    }

    private void saveCceInfo(Deployment deployment, String clusterId, String projectId) {
        if (deployment.getStatus().getReplicas() == 0) {
            return;
        }
        CceInfo cceInfo = new CceInfo();
        cceInfo.setDeploymentId(deployment.getMetadata().getUid());
        cceInfo.setNameSpace(deployment.getMetadata().getNamespace());
        cceInfo.setProjectId(projectId);
        cceInfo.setReplicaCount(deployment.getStatus().getReplicas());
        cceInfo.setClusterId(clusterId);
        cceInfo.setName(deployment.getMetadata().getName());
        this.cceInfoDao.save(cceInfo);
    }

    private List<AppServiceInstance> convertCluster2ServiceInstances(ClusterList clusterList, ServiceInstanceFilter filter) {
        return clusterList.getItems().stream().filter(cluster -> {
            ClusterSpec spec = cluster.getSpec();
            String az = spec.getAz();
            if (az.equals(MULTI_AZ)) {
                return spec.getMasters().stream().anyMatch(clusterMasterSpec -> clusterMasterSpec.getAvailabilityZone().equals(filter.getPdAzId()));
            }
            return az.equals(filter.getPdAzId());
        }).map(cluster -> {
            AppServiceInstance instance = new AppServiceInstance();
            instance.setInstanceName(cluster.getMetadata().getName());
            instance.setInstanceId(cluster.getMetadata().getUid());
            instance.setStatus(cluster.getStatus().getPhase());
            instance.setServiceType(ServiceType.CCE.getValue());
            return instance;
        }).collect(Collectors.toList());
    }

    private List<AppServiceInstance> convertDeployment2ServiceInstanceList(DeploymentList deploymentList, ServiceList serviceList, ServiceInstanceFilter filter) {
        List services = serviceList.getItems().stream().filter(service -> CLUSTER_IP.equals(service.getSpec().getType())).collect(Collectors.toList());
        Stream<Object> stream = deploymentList.getItems().stream();
        if (!VerifyUtil.isEmpty((String)filter.getInstanceId())) {
            stream = stream.filter(deployment -> deployment.getMetadata().getUid().contains(filter.getInstanceId()));
        }
        if (!VerifyUtil.isEmpty((String)filter.getInstanceName())) {
            stream = stream.filter(deployment -> deployment.getMetadata().getName().contains(filter.getInstanceName()));
        }
        return stream.map(deployment -> this.convertDeployment2ServiceInstance((Deployment)deployment, services, filter)).filter(instance -> instance.getStatus().equals(ServiceInstanceStatus.NORMAL.getValue())).collect(Collectors.toList());
    }

    private AppServiceInstance convertDeployment2ServiceInstance(Deployment deployment, List<Service> services, ServiceInstanceFilter filter) {
        AppServiceInstance appServiceInstance = new AppServiceInstance();
        appServiceInstance.setInstanceName(deployment.getMetadata().getName());
        appServiceInstance.setInstanceId(deployment.getMetadata().getUid());
        appServiceInstance.setServiceType(ServiceType.CCE.getValue());
        int availableReplicasNum = deployment.getStatus().getAvailableReplicas();
        int replicasNum = deployment.getStatus().getReplicas();
        if (replicasNum == availableReplicasNum && replicasNum > 0) {
            appServiceInstance.setStatus(ServiceInstanceStatus.NORMAL.getValue());
        } else {
            appServiceInstance.setStatus(ServiceInstanceStatus.ERROR.getValue());
        }
        appServiceInstance.setInstanceObjectCount(Integer.valueOf(deployment.getStatus().getReplicas()));
        appServiceInstance.setReplicaStatus(ReplicaStatus.NORMAL.getValue());
        if (!VerifyUtil.isEmpty((Object)filter)) {
            appServiceInstance.setPdRegionId(filter.getPdRegionId());
            appServiceInstance.setPdAzId(filter.getPdAzId());
            appServiceInstance.setDrType(filter.getDrType().getValue());
        }
        if (VerifyUtil.isEmpty(services)) {
            return appServiceInstance;
        }
        String app = Optional.ofNullable(deployment.getSpec()).map(DeploymentSpec::getSelector).map(DeploymentSelector::getMatchLabels).map(DeploymentMatchLabels::getApp).orElse(null);
        String namespace = Optional.ofNullable(deployment.getMetadata()).map(DeploymentMetadata::getNamespace).orElse(null);
        if (!VerifyUtil.isEmpty((String)namespace) && !VerifyUtil.isEmpty((String)app)) {
            ArrayList ipAddress = new ArrayList();
            services.stream().filter(service -> service.getMetadata().getNamespace().equals(namespace)).filter(service -> !VerifyUtil.isEmpty((Object)service.getSpec().getSelector())).filter(service -> service.getSpec().getSelector().getApp().equals(app)).forEach(service -> ipAddress.add(service.getSpec().getClusterIP()));
            appServiceInstance.setInstanceAddress(String.join((CharSequence)",", ipAddress));
        }
        return appServiceInstance;
    }

    private boolean checkRegionAz(ServiceInstanceFilter filter) {
        return !VerifyUtil.isEmpty((String)filter.getPdRegionId()) && !VerifyUtil.isEmpty((String)filter.getPdAzId());
    }

    public void setCceClient(CceClient cceClient) {
        this.cceClient = cceClient;
    }

    public void setCceInfoDao(CceInfoDao cceInfoDao) {
        this.cceInfoDao = cceInfoDao;
    }
}

