/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.dao.impl;

import com.huawei.ism.cbb.base.dao.IBaseDao;
import com.huawei.ism.cbb.base.dao.impl.HibernateEntityDao;
import com.huawei.ism.cbb.base.dao.impl.HibernateGenericDao;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class BaseDao<T, PK extends Serializable>
implements IBaseDao<T, PK> {
    private Class<T> entityClass;
    private HibernateEntityDao<T, PK> hedao;
    private HibernateGenericDao hgdao;
    private TransactionTemplate transactionTemplate;

    public BaseDao() {
    }

    public BaseDao(Class<T> type) {
        this.entityClass = type;
    }

    public void setHedao(HibernateEntityDao<T, PK> hedao) {
        hedao.setEntityClass(this.entityClass);
        this.hedao = hedao;
    }

    public void setHgdao(HibernateGenericDao hgdao) {
        this.hgdao = hgdao;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public T get(PK id) {
        return this.hedao.get(id);
    }

    @Override
    public List<T> getAll() {
        return this.hedao.getAll();
    }

    @Override
    public List<T> getAll(String orderBy, boolean isAsc) {
        return this.hedao.getAll(orderBy, isAsc);
    }

    @Override
    public List<T> findBy(Map<String, Object> props) {
        return this.hedao.findBy(props);
    }

    @Override
    public T findUniqueBy(Map<String, Object> props) {
        return this.hedao.findUniqueBy(props);
    }

    @Override
    public void evict(T entity) {
        this.hedao.evict(entity);
    }

    @Override
    public void save(T entity) {
        this.hedao.save(entity);
    }

    @Override
    public void update(T entity) {
        this.hedao.update(entity);
    }

    @Override
    public void remove(T entity) {
        this.hedao.remove(entity);
    }

    @Override
    public void removeById(PK id) {
        this.hedao.removeById(id);
    }

    @Override
    public void flush() {
        this.hgdao.flush();
    }

    @Override
    public void clear() {
        this.hgdao.clear();
    }

    @Override
    public <T extends Serializable> List<T> createCriteria(Class<?> clazz, Criterion ... criterions) {
        return this.hedao.createCriteria(clazz, criterions);
    }

    @Override
    public <T extends Serializable> List<T> createCriteria(Class<?> clazz, String orderBy, boolean isAsc, Criterion ... criterions) {
        return this.hedao.createCriteria(clazz, orderBy, isAsc, criterions);
    }

    @Override
    public Page pagedQuery(Criteria criteria, int pageNo, int pageSize) {
        return this.hedao.pagedQuery(criteria, pageNo, pageSize);
    }

    @Override
    public Page pagedQuery(String hql, int pageNo, int pageSize, Object ... values) {
        return this.hgdao.pagedQuery(hql, pageNo, pageSize, values);
    }

    @Override
    public Page dataQuery(String hql, int start, int pageSize, Object ... values) {
        return this.hgdao.dataQuery(hql, start, pageSize, values);
    }

    @Override
    public List<?> find(String hql, Object ... values) {
        return this.hgdao.find(hql, values);
    }

    @Override
    public List<?> executeNativeSql(String sql, Object ... params) {
        return this.hgdao.executeNativeSql(sql, params);
    }

    @Override
    public void saveOrUpdateAll(Collection<?> entities) {
        if (null != entities) {
            for (Object entity : entities) {
                this.hgdao.getHibernateTemplate().saveOrUpdate(entity);
            }
        }
    }

    @Override
    public HibernateTemplate getHibernateTemplate() {
        return this.hgdao.getHibernateTemplate();
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    @Override
    public List<Criterion> translatePropsToCriterions(Map<String, Object> props) {
        return this.hedao.translatePropsToCriterions(props);
    }

    @Override
    public List<Criterion> translatePropsToCriterions(List<QueryCondition> props) {
        return this.hedao.translatePropsToCriterions(props);
    }

    @Override
    public long getTotalCount(String hql) {
        return this.hgdao.getTotalCount(hql);
    }

    @Override
    public Page pagedQuery(Class<?> clazz, int pageNo, int pageSize, List<Criterion> criterionList) {
        return this.hedao.pagedQuery(clazz, pageNo, pageSize, criterionList);
    }

    @Override
    public Page pagedQuery(Class<?> clazz, int pageNo, int pageSize, List<Criterion> criterionList, String orderBy, boolean isAsc) {
        return this.hedao.pagedQuery(clazz, pageNo, pageSize, criterionList, orderBy, isAsc);
    }

    @Override
    public int insert(String nativeSql, Object ... parameters) {
        return this.hgdao.insert(nativeSql, parameters);
    }

    @Override
    public int delete(String nativeSql, Object ... parameters) {
        return this.hgdao.delete(nativeSql, parameters);
    }

    @Override
    public int update(String nativeSql, Object ... parameters) {
        return this.hgdao.update(nativeSql, parameters);
    }
}

