/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.dao.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.ism.cbb.util.IsmBeanUtils;
import com.huawei.ism.cbb.util.StringEscapeUtil;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.util.Assert;

public class HibernateEntityDao<T, PK extends Serializable>
extends HibernateDaoSupportWrapper {
    private static final int NUM_TWO = 2;
    private static final Log logger = LogFactory.getInstance(HibernateEntityDao.class);
    private Class<T> entityClass;

    public void setEntityClass(Class<T> type) {
        this.entityClass = type;
    }

    protected Class<T> getEntityClass() {
        return this.entityClass;
    }

    public T get(PK id) {
        return (T)this.getHibernateTemplate().get(this.getEntityClass(), id);
    }

    public List<T> getAll() {
        return this.getHibernateTemplate().loadAll(this.getEntityClass());
    }

    public List<T> getAll(String orderBy, boolean isAsc) {
        Assert.hasText((String)orderBy);
        if (isAsc) {
            return this.getHibernateTemplate().findByCriteria(DetachedCriteria.forClass(this.getEntityClass()).addOrder(Order.asc((String)orderBy)));
        }
        return this.getHibernateTemplate().findByCriteria(DetachedCriteria.forClass(this.getEntityClass()).addOrder(Order.desc((String)orderBy)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> findBy(Map<String, Object> props) {
        Assert.notNull(props);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        List list = new ArrayList();
        Session session = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            Criterion[] criterions = criterionList.toArray(new Criterion[criterionList.size()]);
            Criteria criteria = session.createCriteria(this.getEntityClass());
            for (Criterion c : criterions) {
                criteria.add(c);
            }
            list = criteria.list();
        }
        catch (Exception e) {
            logger.error((Object)("createCriteria error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784002L);
        }
        finally {
            this.closeSession(session);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findUniqueBy(Map<String, Object> props) {
        Assert.notNull(props);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        Session session = null;
        Object result = null;
        try {
            Criterion[] criterions;
            session = this.getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(this.getEntityClass());
            for (Criterion c : criterions = criterionList.toArray(new Criterion[criterionList.size()])) {
                criteria.add(c);
            }
            result = criteria.uniqueResult();
        }
        catch (Exception e) {
            logger.error((Object)("findUnique error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784002L);
        }
        finally {
            this.closeSession(session);
        }
        return (T)result;
    }

    private void closeSession(Session session) {
        HibernateUtil.closeSession((Session)session);
    }

    public void remove(T entity) {
        this.getHibernateTemplate().delete(entity);
    }

    public void removeById(PK id) {
        this.remove(this.get(id));
    }

    public void save(T entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    public void update(T entity) {
        this.getHibernateTemplate().update(entity);
    }

    public void evict(T entity) {
        this.getHibernateTemplate().evict(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> List<T> createCriteria(Class<?> clazz, Criterion ... criterions) {
        Assert.notNull(clazz);
        List list = new ArrayList();
        Session session = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(clazz);
            for (Criterion c : criterions) {
                criteria.add(c);
            }
            list = criteria.list();
        }
        catch (Exception e) {
            logger.error((Object)("createCriteria error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784002L);
        }
        finally {
            this.closeSession(session);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Serializable> List<T> createCriteria(Class<?> clazz, String orderBy, boolean isAsc, Criterion ... criterions) {
        Assert.notNull(clazz);
        Assert.hasText((String)orderBy);
        List list = new ArrayList();
        Session session = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            Criteria criteria = session.createCriteria(clazz);
            for (Criterion c : criterions) {
                criteria.add(c);
            }
            if (isAsc) {
                criteria.addOrder(Order.asc((String)orderBy));
            } else {
                criteria.addOrder(Order.desc((String)orderBy));
            }
            list = criteria.list();
        }
        catch (Exception e) {
            logger.error((Object)("createCriteria error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784002L);
        }
        finally {
            this.closeSession(session);
        }
        return list;
    }

    public Page pagedQuery(Criteria criteria, int pageNo, int pageSize) {
        List orderEntries;
        Assert.notNull((Object)criteria);
        Assert.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"pageNo should start from 0");
        CriteriaImpl impl = (CriteriaImpl)criteria;
        Projection projection = impl.getProjection();
        try {
            orderEntries = (List)IsmBeanUtils.forceGetProperty((Object)impl, (String)"orderEntries");
            IsmBeanUtils.forceSetProperty((Object)impl, (String)"orderEntries", new ArrayList());
        }
        catch (Exception e) {
            throw new LegoCheckedException(" Runtime Exception impossibility throw ", (Throwable)e);
        }
        int totalCount = (Integer)criteria.setProjection(Projections.rowCount()).uniqueResult();
        criteria.setProjection(projection);
        if (projection == null) {
            criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        try {
            IsmBeanUtils.forceSetProperty((Object)impl, (String)"orderEntries", (Object)orderEntries);
        }
        catch (Exception e) {
            throw new LegoCheckedException(" Runtime Exception impossibility throw ", (Throwable)e);
        }
        if (totalCount < 1) {
            return new Page();
        }
        int startIndex = Page.getStartOfPage((int)pageNo, (int)pageSize);
        List list = criteria.setFirstResult(startIndex).setMaxResults(pageSize).list();
        return new Page((long)startIndex, (long)totalCount, pageSize, list);
    }

    public Page pagedQuery(Class<?> clazz, int pageNo, int pageSize, List<Criterion> criterionList, String orderBy, boolean isAsc) {
        Assert.hasText((String)orderBy);
        Assert.notNull(clazz);
        Session session = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            int[] page = new int[]{pageNo, pageSize};
            Page page2 = this.getPageQueryResult(clazz, page, criterionList, orderBy, isAsc, session);
            return page2;
        }
        catch (Exception e) {
            throw new LegoCheckedException(" Runtime Exception impossibility throw ", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private Page getPageQueryResult(Class<?> clazz, int[] page, List<Criterion> criterionList, String orderBy, boolean isAsc, Session session) {
        List orderEntries;
        Criterion[] criterions;
        int pageNo = page[0];
        int pageSize = page[1];
        Criteria criteria = session.createCriteria(clazz);
        for (Criterion c : criterions = criterionList.toArray(new Criterion[criterionList.size()])) {
            criteria.add(c);
        }
        if (isAsc) {
            criteria.addOrder(Order.asc((String)orderBy));
        } else {
            criteria.addOrder(Order.desc((String)orderBy));
        }
        Assert.notNull((Object)criteria);
        Assert.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"pageNo should start from 0");
        CriteriaImpl impl = (CriteriaImpl)criteria;
        Projection projection = impl.getProjection();
        try {
            orderEntries = (List)IsmBeanUtils.forceGetProperty((Object)impl, (String)"orderEntries");
            IsmBeanUtils.forceSetProperty((Object)impl, (String)"orderEntries", new ArrayList());
        }
        catch (Exception e1) {
            throw new LegoCheckedException(" Runtime Exception impossibility throw ", (Throwable)e1);
        }
        int totalCount = ((Long)criteria.setProjection(Projections.rowCount()).uniqueResult()).intValue();
        criteria.setProjection(projection);
        if (projection == null) {
            criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        try {
            IsmBeanUtils.forceSetProperty((Object)impl, (String)"orderEntries", (Object)orderEntries);
        }
        catch (Exception e2) {
            throw new LegoCheckedException(" Runtime Exception impossibility throw ", (Throwable)e2);
        }
        if (totalCount < 1) {
            return new Page();
        }
        int startIndex = Page.getStartOfPage((int)pageNo, (int)pageSize);
        List list = criteria.setFirstResult(startIndex).setMaxResults(pageSize).list();
        return new Page((long)startIndex, (long)totalCount, pageSize, list);
    }

    public Page pagedQuery(Class<?> clazz, int pageNo, int pageSize, List<Criterion> criterionList) {
        Assert.notNull(clazz);
        Session session = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            Page page = this.getPageQueryResult(clazz, pageNo, pageSize, criterionList, session);
            return page;
        }
        catch (Exception e) {
            throw new LegoCheckedException(" Runtime Exception impossibility throw ", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private Page getPageQueryResult(Class<?> clazz, int pageNo, int pageSize, List<Criterion> criterionList, Session session) {
        List orderEntries;
        Criterion[] criterions;
        Criteria criteria = session.createCriteria(clazz);
        for (Criterion c : criterions = criterionList.toArray(new Criterion[criterionList.size()])) {
            criteria.add(c);
        }
        Assert.notNull((Object)criteria);
        Assert.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"pageNo should start from 0");
        CriteriaImpl impl = (CriteriaImpl)criteria;
        Projection projection = impl.getProjection();
        try {
            orderEntries = (List)IsmBeanUtils.forceGetProperty((Object)impl, (String)"orderEntries");
            IsmBeanUtils.forceSetProperty((Object)impl, (String)"orderEntries", new ArrayList());
        }
        catch (Exception e1) {
            throw new LegoCheckedException(" Runtime Exception impossibility throw ", (Throwable)e1);
        }
        int totalCount = (Integer)criteria.setProjection(Projections.rowCount()).uniqueResult();
        criteria.setProjection(projection);
        if (projection == null) {
            criteria.setResultTransformer(CriteriaSpecification.ROOT_ENTITY);
        }
        try {
            IsmBeanUtils.forceSetProperty((Object)impl, (String)"orderEntries", (Object)orderEntries);
        }
        catch (Exception e2) {
            throw new LegoCheckedException(" Runtime Exception impossibility throw ", (Throwable)e2);
        }
        if (totalCount < 1) {
            return new Page();
        }
        int startIndex = Page.getStartOfPage((int)pageNo, (int)pageSize);
        List list = criteria.setFirstResult(startIndex).setMaxResults(pageSize).list();
        return new Page((long)startIndex, (long)totalCount, pageSize, list);
    }

    public PK getId(Class<T> entityClazz, T entity) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Assert.notNull(entity);
        Assert.notNull(entityClazz);
        return (PK)((Serializable)PropertyUtils.getProperty(entity, (String)this.getIdName(entityClazz)));
    }

    public String getIdName(Class<T> clazz) {
        Assert.notNull(clazz);
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(clazz);
        Assert.notNull((Object)meta, (String)("Class " + clazz + " not define in hibernate session factory."));
        String idName = meta.getIdentifierPropertyName();
        Assert.hasText((String)idName, (String)(clazz.getSimpleName() + " has no identifier property define."));
        return idName;
    }

    public List<Criterion> translatePropsToCriterions(Map<String, Object> props) {
        ArrayList<Criterion> criterionList = new ArrayList<Criterion>();
        if (null == props) {
            return criterionList;
        }
        Set<Map.Entry<String, Object>> entrySet = props.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String propertyName = entry.getKey();
            Object propertyValue = entry.getValue();
            if (propertyValue instanceof String) {
                String tempPropertyValue = propertyValue.toString();
                criterionList.add((Criterion)Restrictions.eq((String)propertyName, (Object)tempPropertyValue));
                continue;
            }
            if (propertyValue instanceof Object[]) {
                criterionList.add(Restrictions.in((String)propertyName, (Object[])((Object[])propertyValue)));
                continue;
            }
            criterionList.add((Criterion)Restrictions.eq((String)propertyName, (Object)propertyValue));
        }
        return criterionList;
    }

    public List<Criterion> translatePropsToCriterions(List<QueryCondition> props) {
        ArrayList<Criterion> criterionList = new ArrayList<Criterion>();
        if (null == props) {
            return criterionList;
        }
        for (QueryCondition prop : props) {
            int coType = prop.getCoType();
            if (coType == 2) {
                criterionList.add((Criterion)Restrictions.ne((String)prop.getPropName(), (Object)prop.getPropValue()));
                continue;
            }
            String propName = prop.getPropName();
            Object propValue = prop.getPropValue();
            if (propValue instanceof String) {
                if (prop.isWholeWorld()) {
                    criterionList.add((Criterion)Restrictions.eq((String)propName, (Object)propValue));
                    continue;
                }
                String propEscapeStringValue = StringEscapeUtil.escapeSql((String)propValue.toString());
                if (prop.isCaseSensitive()) {
                    criterionList.add((Criterion)Restrictions.like((String)propName, (Object)("%" + propEscapeStringValue + "%")));
                    continue;
                }
                criterionList.add(Restrictions.ilike((String)propName, (Object)("%" + propEscapeStringValue + "%")));
                continue;
            }
            if (propValue instanceof Object[]) {
                criterionList.add(Restrictions.in((String)propName, (Object[])((Object[])propValue)));
                continue;
            }
            criterionList.add((Criterion)Restrictions.eq((String)propName, (Object)propValue));
        }
        return criterionList;
    }
}

