/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.dao.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.Serializable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class HibernateGenericDao
extends HibernateDaoSupportWrapper {
    private static final Log logger = LogFactory.getInstance(HibernateGenericDao.class);

    public void flush() {
        this.getHibernateTemplate().flush();
    }

    public void clear() {
        this.getHibernateTemplate().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page pagedQuery(String hql, int pageNo, int pageSize, Object ... values) {
        if (!StringUtils.hasText((String)hql)) {
            throw new IllegalArgumentException("This String argument must have text; it must not be null, empty, or blank");
        }
        Assert.isTrue((pageNo >= 0 ? 1 : 0) != 0, (String)"pageNo should start from 0");
        String countQueryString = " select count (*) " + HibernateGenericDao.removeSelect(HibernateGenericDao.removeOrders(hql));
        List countlist = this.getHibernateTemplate().find(countQueryString, values);
        long totalCount = 0L;
        if (!VerifyUtil.isEmpty((Collection)countlist)) {
            totalCount = (Long)countlist.get(0);
        }
        if (totalCount < 1L) {
            return new Page();
        }
        int startIndex = Page.getStartOfPage((int)pageNo, (int)pageSize);
        Session session = null;
        List list = new ArrayList();
        try {
            session = this.getSessionFactory().getCurrentSession();
            Query query = session.createQuery(hql);
            for (int i = 0; i < values.length; ++i) {
                query.setParameter(i, values[i]);
            }
            list = query.setFirstResult(startIndex).setMaxResults(pageSize).list();
        }
        catch (Exception e) {
            logger.error((Object)("executeNativehql error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784002L);
        }
        finally {
            this.closeSession(session);
        }
        return new Page((long)startIndex, totalCount, pageSize, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page dataQuery(String hql, int start, int pageSize, Object ... querys) {
        if (!StringUtils.hasText((String)hql)) {
            throw new IllegalArgumentException("This String argument must have text; it must not be null, empty, or blank");
        }
        String countQueryString = " select count (*) " + HibernateGenericDao.removeSelect(HibernateGenericDao.removeOrders(hql));
        List countlist = this.getHibernateTemplate().find(countQueryString, querys);
        long totalCount = 0L;
        if (!VerifyUtil.isEmpty((Collection)countlist)) {
            totalCount = (Long)countlist.get(0);
        }
        if (totalCount < 1L) {
            return new Page();
        }
        Session session = null;
        int startIndex = start;
        List list = new ArrayList();
        try {
            session = this.getSessionFactory().getCurrentSession();
            Query query = session.createQuery(hql);
            for (int i = 0; i < querys.length; ++i) {
                query.setParameter(i, querys[i]);
            }
            list = query.setFirstResult(startIndex).setMaxResults(pageSize).list();
        }
        catch (Exception e) {
            logger.error((Object)("Execute native hql error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784002L);
        }
        finally {
            this.closeSession(session);
        }
        return new Page((long)startIndex, totalCount, pageSize, list);
    }

    public List<?> find(String hql, Object ... values) {
        if (!StringUtils.hasText((String)hql)) {
            throw new IllegalArgumentException("This String argument must have text; it must not be null, empty, or blank");
        }
        return this.getHibernateTemplate().find(hql, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> executeNativeSql(String sql, Object ... parameters) {
        Session session = null;
        List resultList = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            NativeQuery query = session.createSQLQuery(sql);
            for (int i = 0; i < parameters.length; ++i) {
                query.setParameter(i, parameters[i]);
            }
            resultList = query.list();
            HibernateUtil.commit((Session)session);
        }
        catch (Exception e) {
            HibernateUtil.rollbackSession((Session)session);
            logger.error((Object)("executeNativeSql error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784002L);
        }
        finally {
            this.closeSession(session);
        }
        return resultList;
    }

    public int insert(String nativeSql, Object ... parameters) {
        return this.execute(nativeSql, parameters);
    }

    public int delete(String nativeSql, Object ... parameters) {
        return this.execute(nativeSql, parameters);
    }

    public int update(String nativeSql, Object ... parameters) {
        return this.execute(nativeSql, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int execute(String nativeSql, Object ... parameters) {
        Assert.notNull((Object)nativeSql);
        Assert.notNull((Object)parameters);
        int result = 0;
        Session session = null;
        try {
            session = this.getSessionFactory().getCurrentSession();
            HibernateUtil.beginTransaction((Session)session);
            NativeQuery query = session.createSQLQuery(nativeSql);
            for (int i = 0; i < parameters.length; ++i) {
                query.setParameter(i, parameters[i]);
            }
            result = query.executeUpdate();
            HibernateUtil.commit((Session)session);
        }
        catch (Exception e) {
            HibernateUtil.rollbackSession((Session)session);
            logger.error((Object)("executeNativeSql error" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784002L);
        }
        finally {
            this.closeSession(session);
        }
        return result;
    }

    private static String removeSelect(String hql) {
        int beginPos = hql.toLowerCase(Locale.ENGLISH).indexOf("from");
        if (beginPos == -1) {
            throw new IllegalArgumentException(" hql : " + hql + " must has a keyword 'from'");
        }
        return hql.substring(beginPos);
    }

    private static String removeOrders(String hql) {
        Pattern pattern = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher matcher = pattern.matcher(Normalizer.normalize(hql, Normalizer.Form.NFKC));
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "");
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public Serializable save(Object entity) {
        return super.getHibernateTemplate().save(entity);
    }

    public void delete(Object entity) {
        super.getHibernateTemplate().delete(super.getHibernateTemplate().merge(entity));
    }

    public void update(Object entity) {
        super.getHibernateTemplate().merge(entity);
    }

    public Object get(Class<?> entityClass, Serializable id) {
        return super.getHibernateTemplate().get(entityClass, id);
    }

    public <T> List getObjects(Class<?> clazz, Properties prop) {
        List usrObjects;
        Session session = super.getSessionFactory().getCurrentSession();
        try {
            Criteria criteria = session.createCriteria(clazz.getName());
            Enumeration<Object> en = prop.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                String value = prop.getProperty(key);
                criteria.add((Criterion)Restrictions.like((String)key, (Object)value));
            }
            usrObjects = criteria.list();
        }
        catch (Exception e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        return usrObjects;
    }

    private void closeSession(Session session) {
        if (null != session) {
            try {
                session.flush();
            }
            catch (HibernateException ex) {
                logger.error((Object)ex, 90160758784002L);
            }
            HibernateUtil.closeSession((Session)session);
        }
    }

    public long getTotalCount(String hql) {
        ListIterator listIterator = super.getHibernateTemplate().find(hql, new Object[0]).listIterator();
        if (listIterator.hasNext()) {
            return (Long)listIterator.next();
        }
        logger.warn((Object)"the result iterator has no element, maybe the sql is not a count statement");
        return 0L;
    }
}

