/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.dao.impl;

import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.dao.impl.BaseDao;
import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.bo.QueryCondition;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class MoDao
extends BaseDao<ManagedObject, Long>
implements IMoDao {
    private static final String TOP_MO_UUID = "topMoUuid";
    private static final int VALUE_2 = 2;
    private IResourceService reService = null;
    private IDiscoveryService disService = null;

    public MoDao() {
        super.setEntityClass(ManagedObject.class);
    }

    public IResourceService getReService() {
        return this.reService;
    }

    public void setReService(IResourceService reService) {
        this.reService = reService;
    }

    public IDiscoveryService getDisService() {
        return this.disService;
    }

    public void setDisService(IDiscoveryService disService) {
        this.disService = disService;
    }

    @Override
    @Deprecated
    public <T extends ManagedObject> T getMo(Class<T> clazz, String propertyName, Object propertyValue) {
        HashMap<String, Object> parms = new HashMap<String, Object>();
        parms.put(propertyName, propertyValue);
        List<T> result = this.findMoBy(clazz, parms);
        if (result != null && !result.isEmpty()) {
            return (T)((ManagedObject)result.get(0));
        }
        return null;
    }

    @Override
    public <T extends ManagedObject> List<T> getMoList(Class<T> clazz, String propertyName, Object propertyValue) {
        HashMap<String, Object> parms = new HashMap<String, Object>();
        parms.put(propertyName, propertyValue);
        return this.findMoBy(clazz, parms);
    }

    @Override
    public <T extends ManagedObject> List<T> findMoBy(Class<T> clazz, List<QueryCondition> props) {
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    @Override
    public <T extends ManagedObject> List<T> findMoBy(Class<T> clazz, Map<String, Object> props) {
        if (null == props) {
            props = new HashMap<String, Object>();
        }
        props.put("managed", true);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    @Override
    public <T extends ManagedObject> List<T> findMoBy(Class<T> clazz, String orderBy, boolean isAsc, List<QueryCondition> props) {
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, orderBy, isAsc, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    @Override
    public <T extends ManagedObject> List<T> findMoBy(Class<T> clazz, String orderBy, boolean isAsc, Map<String, Object> props) {
        if (null == props) {
            props = new HashMap<String, Object>();
        }
        props.put("managed", true);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, orderBy, isAsc, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    public <T extends ManagedObject> List<T> findSubMoByTopUuid(long topUuid, Class<T> clazz, List<QueryCondition> props) {
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        props.add(new QueryCondition(TOP_MO_UUID, (Object)topUuid));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    @Override
    public <T extends ManagedObject> List<T> findSubMoBy(long parentId, Class<T> clazz, List<QueryCondition> props) {
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        props.add(new QueryCondition("parentMo.moId", (Object)parentId));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    @Override
    public <T extends ManagedObject> List<T> findSubMoBy(long parentId, Class<T> clazz, Map<String, Object> props) {
        if (null == props) {
            props = new HashMap<String, Object>();
        }
        props.put("managed", true);
        props.put("parentMo.moId", parentId);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    @Override
    public <T extends ManagedObject> List<T> findSubMoBy(long parentId, Class<T> clazz, String orderBy, boolean isAsc, List<QueryCondition> props) {
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        props.add(new QueryCondition("parentMo.moId", (Object)parentId));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, orderBy, isAsc, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    @Override
    public <T extends ManagedObject> List<T> findSubMoBy(long parentId, Class<T> clazz, String orderBy, boolean isAsc, Map<String, Object> props) {
        if (null == props) {
            props = new HashMap<String, Object>();
        }
        props.put("managed", true);
        props.put("parentMo.moId", parentId);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.createCriteria(clazz, orderBy, isAsc, criterionList.toArray(new Criterion[criterionList.size()]));
    }

    @Override
    public <T extends ManagedObject> List<T> getAllMo(Class<T> clazz) {
        return this.createCriteria(clazz, new Criterion[]{Restrictions.eq((String)"managed", (Object)true)});
    }

    @Override
    public <T extends ManagedObject> List<T> getAllSubMo(long parentId, Class<T> clazz) {
        return this.createCriteria(clazz, new Criterion[]{Restrictions.eq((String)"managed", (Object)true), Restrictions.eq((String)"parentMo.moId", (Object)parentId)});
    }

    @Override
    public Page pagedQueryMo(Class<?> clazz, int pageNo, int pageSize, List<QueryCondition> props) {
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.pagedQuery(clazz, pageNo, pageSize, criterionList);
    }

    @Override
    public Page pagedQueryMo(Class<?> clazz, int pageNo, int pageSize, Map<String, Object> props) {
        if (null == props) {
            props = new HashMap<String, Object>();
        }
        props.put("managed", true);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.pagedQuery(clazz, pageNo, pageSize, criterionList);
    }

    @Override
    public Page pagedQueryMo(Class<?> clazz, int pageNo, int pageSize, String orderBy, boolean isAsc, List<QueryCondition> props) {
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.pagedQuery(clazz, pageNo, pageSize, criterionList, orderBy, isAsc);
    }

    @Override
    public Page pagedQueryMo(Class<?> clazz, int pageNo, int pageSize, String orderBy, boolean isAsc, Map<String, Object> props) {
        if (null == props) {
            props = new HashMap<String, Object>();
        }
        props.put("managed", true);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.pagedQuery(clazz, pageNo, pageSize, criterionList, orderBy, isAsc);
    }

    @Override
    public Page pagedQuerySubMo(long parentId, Class<?> clazz, int pageNo, int pageSize, List<QueryCondition> props) {
        if (null == props) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        props.add(new QueryCondition("parentMo.moId", (Object)parentId));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.pagedQuery(clazz, pageNo, pageSize, criterionList);
    }

    @Override
    public Page pagedQuerySubMo(long parentId, Class<?> clazz, int pageNo, int pageSize, Map<String, Object> props) {
        if (null == props) {
            props = new HashMap<String, Object>();
        }
        props.put("managed", true);
        props.put("parentMo.moId", parentId);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.pagedQuery(clazz, pageNo, pageSize, criterionList);
    }

    @Override
    public Page pagedQuerySubMo(long parentId, Class<?> clazz, String orderBy, boolean isAsc, List<QueryCondition> props, int ... args) {
        if (null == props || args.length != 2) {
            props = new ArrayList<QueryCondition>();
        }
        props.add(new QueryCondition("managed", (Object)true));
        props.add(new QueryCondition("parentMo.moId", (Object)parentId));
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.pagedQuery(clazz, args[0], args[1], criterionList, orderBy, isAsc);
    }

    @Override
    public Page pagedQuerySubMo(long parentId, Class<?> clazz, String orderBy, boolean isAsc, Map<String, Object> props, int ... args) {
        if (null == props || args.length != 2) {
            props = new HashMap<String, Object>();
        }
        props.put("managed", true);
        props.put("parentMo.moId", parentId);
        List<Criterion> criterionList = this.translatePropsToCriterions(props);
        return this.pagedQuery(clazz, args[0], args[1], criterionList, orderBy, isAsc);
    }

    @Override
    public Long saveOrUpdateMo(ManagedObject mo) {
        return this.reService.addMo(mo);
    }

    @Override
    public List<Long> saveOrUpdateMoList(List<ManagedObject> moList) {
        return this.reService.addMo(moList);
    }

    @Override
    public void addMoAndSubMo(ManagedObject mo) {
        this.reService.addMoAndSubMo(mo);
    }

    @Override
    public void addMoAndSubMoWithoutMsg(ManagedObject mo, Map<Long, Long> msgMap) {
        this.reService.addMoAndSubMoWithoutMsg(mo, msgMap);
    }

    @Override
    public void addMoAndSubMoWithoutDelete(ManagedObject mo) {
        this.reService.addMoAndSubMoWithoutDelete(mo);
    }

    @Override
    public void addMoAndSubMoWithoutDeleteWithoutMsg(ManagedObject mo, Map<Long, Long> msgMap) {
        this.reService.addMoAndSubMoWithoutDeleteWithoutMsg(mo, msgMap);
    }

    @Override
    public void deleteMo(Long moId) {
        this.disService.deleteDevice(Collections.singletonList(moId));
    }

    @Override
    public void deleteMoWithoutMsg(List<Long> moIds) {
        for (Long moId : moIds) {
            this.reService.deleteMoWithoutMsg(moId);
        }
    }

    @Override
    public void deleteMoList(List<Long> moIdList) {
        this.disService.deleteDevice(moIdList);
    }

    @Override
    public void deleteDeviceNewWithoutMsg(List<Long> moIdList) {
        this.disService.deleteDeviceNewWithoutMsg(moIdList);
    }

    @Override
    public ManagedObject getMoByUuid(String uuid, Boolean managed) {
        return this.reService.getMoByUuid(uuid, managed);
    }

    @Override
    public void save(ManagedObject entity) {
        this.saveOrUpdateMo(entity);
    }

    @Override
    public void update(ManagedObject entity) {
        this.saveOrUpdateMo(entity);
    }

    @Override
    public void onlyUpdate(ManagedObject entity) {
        this.reService.updateMo(entity);
    }

    @Override
    public void remove(ManagedObject entity) {
        this.deleteMo(entity.getMoId());
    }

    @Override
    public void removeById(Long id) {
        this.deleteMo(id);
    }

    @Override
    public void unlockDevice(Long id) {
        this.disService.unlockDeviceAfterRefresh(id);
    }

    @Override
    public void deleteMoWithoutMsg(Long moId) {
        this.reService.deleteMoWithoutMsg(moId);
    }

    @Override
    public void onlyUpdateWithoutMsg(ManagedObject mo) {
        this.reService.updateMoWithoutMsg(mo);
    }

    @Override
    public void addMoAndSubMoEx(ManagedObject mo, Map<Long, Long> msgMap) {
        this.reService.addMoAndSubMoEx(mo, msgMap);
    }
}

