/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.jms;

import com.huawei.ism.cbb.base.jms.IMessageReceiver;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AbstractMessageSubscriber
extends MessageTaskManager {
    private static Log logger = LogFactory.getInstance(AbstractMessageSubscriber.class);
    private List<MessageRegister> messageRegisterList = new ArrayList<MessageRegister>();
    private List<IMessageReceiver> messageReceiverList = new ArrayList<IMessageReceiver>();
    private Set<Long> cmdCodeSet = new HashSet<Long>();

    public AbstractMessageSubscriber(int threadNum, String appName) {
        super(threadNum, appName);
    }

    public AbstractMessageSubscriber() {
    }

    public MessageRegister[] getTypes() {
        logger.info((Object)("Class name is : " + ((Object)((Object)this)).getClass().getName() + ", messageReceiverList is " + this.messageReceiverList), 90160758784000L);
        return this.messageRegisterList.toArray(new MessageRegister[this.messageRegisterList.size()]);
    }

    public void onMessage(MessageUnit messageUnit) {
        this.processMessageUnit(messageUnit);
    }

    protected void initMessageReceivers(List<IMessageReceiver> tmpMsgReceiverList) {
        if (VerifyUtil.isEmpty(tmpMsgReceiverList)) {
            logger.error((Object)"Error : messageReceiverList is empty.", 90160758784001L);
            return;
        }
        this.messageReceiverList.addAll(tmpMsgReceiverList);
        int size = tmpMsgReceiverList.size();
        for (int i = 0; i < size; ++i) {
            IMessageReceiver messageReceiver = tmpMsgReceiverList.get(i);
            List<MessageRegister> messageRegisters = messageReceiver.getMessageRegister();
            this.messageRegisterList.addAll(messageRegisters);
            if (null == messageRegisters) continue;
            for (MessageRegister messageRegister : messageRegisters) {
                List cmdCodeList = messageRegister.getMessageCodes();
                this.cmdCodeSet.addAll(cmdCodeList);
            }
        }
        logger.info((Object)("messageRegisterList is " + this.messageRegisterList), 90160758784000L);
        logger.info((Object)("CMD_CODE_SET is " + this.cmdCodeSet), 90160758784000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessageUnit(MessageUnit messageUnit) {
        Long cmdCode = messageUnit.getCmdcode();
        Set<Long> set = this.cmdCodeSet;
        synchronized (set) {
            if (!this.cmdCodeSet.contains(cmdCode)) {
                logger.debug((Object)"The cmdCode is not in cmdCodeSet", 90160758784000L);
                return;
            }
        }
        MessageTopic oMessageTopic = messageUnit.getMt();
        if (null == oMessageTopic) {
            logger.error((Object)"Error: MessageUnit's messageTopic is null", 90160758784000L);
            return;
        }
        for (IMessageReceiver iMessageReceiver : this.messageReceiverList) {
            List<MessageRegister> messageRegisters = iMessageReceiver.getMessageRegister();
            if (VerifyUtil.isEmpty(messageRegisters)) continue;
            for (MessageRegister messageRegister : messageRegisters) {
                MessageTopic receiverMsgTopic = messageRegister.getMessageTopic();
                List cmdCodes = messageRegister.getMessageCodes();
                if (!receiverMsgTopic.equals((Object)oMessageTopic) || !cmdCodes.contains(cmdCode)) continue;
                try {
                    iMessageReceiver.process(messageUnit);
                }
                catch (Exception e) {
                    logger.error((Object)("process error: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
                }
            }
        }
    }
}

