/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.manager.proxy;

import com.huawei.ism.cbb.base.sdk.service.IManagedObjectManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ManagedObjectManagerProxy
implements IManagedObjectManager {
    private static final Log logger = LogFactory.getInstance(ManagedObjectManagerProxy.class);
    private static ManagedObjectManagerProxy instance = new ManagedObjectManagerProxy();
    private Map<String, IManagedObjectManager> moManagerMapping = new ConcurrentHashMap<String, IManagedObjectManager>();

    private ManagedObjectManagerProxy() {
    }

    public static ManagedObjectManagerProxy getInstance() {
        return instance;
    }

    public int getTimeout() {
        return 2400;
    }

    public void onBind(IManagedObjectManager moManager, Map<?, ?> properties) {
        this.moManagerMapping.put(moManager.getType(), moManager);
    }

    public void onUnbind(IManagedObjectManager moManager, Map<?, ?> properties) {
        this.moManagerMapping.remove(moManager.getType());
    }

    public String getType() {
        return null;
    }

    public IManagedObjectManager getMgr(String deviceMainType) {
        if (VerifyUtil.isEmpty((String)deviceMainType)) {
            logger.info((Object)("deviceMainType is empty: " + deviceMainType));
            return this;
        }
        IManagedObjectManager mgr = this.moManagerMapping.get(deviceMainType);
        if (null == mgr) {
            logger.info((Object)("mgr is null, mainType=" + deviceMainType));
            mgr = this;
        }
        return mgr;
    }

    public IManagedObjectManager getMgr(ManagedObject mo) {
        if (mo instanceof TopoObject) {
            return this.getMgr(((TopoObject)mo).getMainType());
        }
        logger.info((Object)("mo info: " + mo));
        return this;
    }
}

