/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.poll;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.poll.ITaskScheduler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;

public final class PollController {
    private static Log logger = LogFactory.getInstance(PollController.class);
    private static final int USE_CONFIG_DELAY = -1;
    private Map<String, Future<?>> pollers = new HashMap();
    private ITaskScheduler scheduler;

    public PollController(ITaskScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public synchronized void addPollerConfig(Map<String, String> pollConfig) {
        this.scheduler.addConfig(pollConfig);
    }

    public void addPoller(IPoller poller) {
        this.addPoller(poller, -1, -1);
    }

    public void addPoller(IPoller poller, int initDelay) {
        this.addPoller(poller, initDelay, -1);
    }

    public synchronized void addPoller(IPoller poller, int initDelay, int delay) {
        try {
            if (this.pollers.containsKey(poller.getPollerID())) {
                logger.warn((Object)("Add duplicate poller, id=" + poller.getPollerID()));
                return;
            }
            ScheduledFuture<?> future = this.scheduler.submit(poller, initDelay, delay);
            this.pollers.put(poller.getPollerID(), future);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to add poller with id=" + poller.getPollerID() + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }

    public synchronized void stopPoller(String pollerId, boolean termined) {
        try {
            Future<?> future = this.pollers.get(pollerId);
            if (future != null) {
                boolean success = future.cancel(termined);
                this.pollers.remove(pollerId);
                logger.info((Object)("Stop poller result=" + success + ", id=" + pollerId));
            } else {
                logger.warn((Object)("Cant not find poller with id=" + pollerId));
            }
        }
        catch (Exception e) {
            logger.error((Object)("Stop poller failed, id=" + pollerId + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }
}

