/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.poll;

import com.huawei.ism.cbb.base.poll.IPoller;
import com.huawei.ism.cbb.base.poll.ITaskScheduler;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class TaskScheduler
implements ITaskScheduler {
    private static Log logger = LogFactory.getInstance(TaskScheduler.class);
    private static final int DEFAULT_DELAY = 600;
    private static final int DEFAULT_INITIAL_DELAY = 30;
    private static final String DEFAULT_POOL_NAME = "Task Scheduler";
    private static final int DEFAULT_POOL_SIZE = 10;
    private static final String DELAY_PROPS = "fixDelay";
    private static final String INITDELAY_PROPS = "initDelay";
    private static final String POOL_NAME_PROPS = "poolName";
    private static final String POOLSIZE_PROPS = "poolSize";
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private static final int USE_CONFIG_DELAY = -1;
    private Properties config;
    private ScheduledExecutorService pools;

    public TaskScheduler(Properties properties) {
        if (properties == null) {
            logger.error((Object)"properties is null.");
            throw new IllegalArgumentException();
        }
        this.initConfig(properties);
        String poolSize = this.config.getProperty(POOLSIZE_PROPS);
        String poolName = this.config.getProperty(POOL_NAME_PROPS);
        this.pools = Executors.newScheduledThreadPool(NumberUtil.convertToInteger((Object)poolSize), new TaskSchedulerThreadFactory(poolName));
    }

    private String getConfigValue(String c, String defaultValue) {
        String value = c;
        if (value == null || value.length() < 1) {
            value = defaultValue;
        }
        return value;
    }

    private void initConfig(Properties tempCfg) {
        logger.info((Object)"TaskScheduler initialize ... ", 90160758784000L);
        String poolName = this.getConfigValue(tempCfg.getProperty(POOL_NAME_PROPS), DEFAULT_POOL_NAME);
        logger.info((Object)("TaskScheduler config : pool name > " + poolName), 90160758784000L);
        tempCfg.setProperty(POOL_NAME_PROPS, poolName);
        String poolSize = this.getConfigValue(tempCfg.getProperty(POOLSIZE_PROPS), String.valueOf(10));
        logger.info((Object)("TaskScheduler config : pool size " + poolSize), 90160758784000L);
        tempCfg.setProperty(POOLSIZE_PROPS, poolSize);
        String initDelay = this.getConfigValue(tempCfg.getProperty(INITDELAY_PROPS), String.valueOf(30));
        logger.info((Object)("TaskScheduler config : init delay " + initDelay), 90160758784000L);
        tempCfg.setProperty(INITDELAY_PROPS, initDelay);
        String delay = this.getConfigValue(tempCfg.getProperty(DELAY_PROPS), String.valueOf(600));
        logger.info((Object)("TaskScheduler config : fix delay " + delay), 90160758784000L);
        tempCfg.setProperty(DELAY_PROPS, delay);
        this.config = tempCfg;
    }

    @Override
    public void addConfig(Map<String, String> customizeConfigs) {
        if (null == customizeConfigs) {
            return;
        }
        if (null == this.config) {
            this.config = new Properties();
        }
        for (Map.Entry<String, String> entry : customizeConfigs.entrySet()) {
            if (VerifyUtil.isEmpty((String)entry.getKey()) || NumberUtil.parseInteger((Object)entry.getValue()) <= 0) continue;
            this.config.setProperty("fixDelay_" + entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void shutdown() {
        this.pools.shutdown();
    }

    @Override
    public ScheduledFuture<?> submit(IPoller poller) {
        return this.submit(poller, -1, -1);
    }

    @Override
    public ScheduledFuture<?> submit(IPoller poller, int initDelay) {
        return this.submit(poller, initDelay, -1);
    }

    @Override
    public ScheduledFuture<?> submit(IPoller poller, int initDelay, int delay) {
        int delayTime;
        int initTime = initDelay;
        if (initTime < 1) {
            String initTimeConf = this.getConfigValue(this.config.getProperty("fixDelay_initDelay_" + poller.getPollerType()), this.config.getProperty(INITDELAY_PROPS));
            initTime = NumberUtil.convertToInteger((Object)initTimeConf);
        }
        if ((delayTime = delay) < 1) {
            String delayConf = this.getConfigValue(this.config.getProperty("fixDelay_" + poller.getPollerType()), this.config.getProperty(DELAY_PROPS));
            delayTime = NumberUtil.convertToInteger((Object)delayConf);
        }
        logger.info((Object)("Submit poller, pollerId=" + poller.getPollerID() + ", poller Type=" + poller.getPollerType() + ", initialDelay seconds=" + initTime + ", interval seconds=" + delayTime));
        return this.pools.scheduleWithFixedDelay(poller, initTime, delayTime, TIME_UNIT);
    }

    private static final class TaskSchedulerThreadFactory
    implements ThreadFactory {
        private String poolName;
        private int threadInitNumber;

        public TaskSchedulerThreadFactory(String poolName) {
            this.poolName = poolName;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.poolName + " - " + this.nextThreadNum());
        }

        private synchronized int nextThreadNum() {
            return this.threadInitNumber++;
        }
    }
}

