/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.service;

import com.huawei.ism.cbb.base.util.AlarmUtil;
import com.huawei.ism.cbb.util.CapacityUnitUtil;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.unit.CapabilityUnitType;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class LogsThresholdAlarm {
    private static final Log LOGGER = LogFactory.getInstance(LogsThresholdAlarm.class);
    private Properties config;

    public Properties getConfig() {
        return this.config;
    }

    public void setConfig(Properties config) {
        this.config = config;
    }

    public void dealThresholdAlarm(ManagedObject entity) {
        String currPath;
        try {
            currPath = new File(System.getProperty("user.dir")).getCanonicalPath();
            if (null == currPath) {
                LOGGER.error((Object)"filePathFE is not validate.", 90160767696915L);
                return;
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("get current path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), 90160767696915L);
            return;
        }
        File file = new File(currPath);
        String parentPath = file.getParent();
        parentPath = parentPath + "//Tomcat6//logs";
        this.dealSendAlarm(entity, parentPath, "logFilesSizeFE", "0xE012C0014");
        String filePathBE = currPath + "//logs";
        this.dealSendAlarm(entity, filePathBE, "logFilesSizeBE", "0xE012C0015");
    }

    private void dealSendAlarm(ManagedObject entity, String filePathFE, String logFileSize, String alarmId) {
        ArrayList<File> listFileFE = new ArrayList<File>();
        long size = 0L;
        this.getFileList(filePathFE, listFileFE);
        for (File file : listFileFE) {
            size += file.length();
        }
        String id = entity.getMoId() + alarmId;
        LegoAlarm oldAlarmFE = this.getAlarm(id);
        if (null == oldAlarmFE && size >= NumberUtil.convertToLong((Object)this.config.getProperty(logFileSize))) {
            this.sendAlarm(entity, id, alarmId, NumberUtil.convertToLong((Object)this.config.getProperty(logFileSize)), size);
        } else if (null != oldAlarmFE && size >= NumberUtil.convertToLong((Object)this.config.getProperty(logFileSize)) && oldAlarmFE.getClearStatus() == FaultEnum.ClearState.CLEARED) {
            this.sendAlarm(entity, id, alarmId, NumberUtil.convertToLong((Object)this.config.getProperty(logFileSize)), size);
        } else if (null != oldAlarmFE && size < NumberUtil.convertToLong((Object)this.config.getProperty(logFileSize)) && oldAlarmFE.getClearStatus() == FaultEnum.ClearState.UNCLEARED) {
            this.sendRestoreAlarm(entity, id, alarmId, NumberUtil.convertToLong((Object)this.config.getProperty(logFileSize)), size);
        }
    }

    private void getFileList(String filePath, List<File> listFile) {
        if (null == filePath || filePath.indexOf("..") != -1) {
            LOGGER.error((Object)"filePath is not validate.", 90160767696915L);
            return;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            LOGGER.error((Object)"The file is not exist.", 90160767696915L);
            return;
        }
        File[] subFile = file.listFiles();
        if (null == subFile) {
            LOGGER.info((Object)"The subfile is not exist.", 90160767696915L);
            return;
        }
        for (int i = 0; i < subFile.length; ++i) {
            if (subFile[i].isDirectory()) {
                try {
                    this.getFileList(subFile[i].getCanonicalPath(), listFile);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"getCanonicalPath error!", 250L);
                }
                continue;
            }
            listFile.add(subFile[i]);
        }
    }

    private LegoAlarm getAlarm(String id) {
        LegoAlarm oldAlarm;
        IAlarmService alarmservice = (IAlarmService)ServiceLocator.getInstance().getService(IAlarmService.class);
        try {
            oldAlarm = alarmservice.getAlarm(id);
        }
        catch (Exception e) {
            LOGGER.info((Object)("Cannot find Alarm by alarmId : " + id), 90160767696916L);
            oldAlarm = null;
        }
        return oldAlarm;
    }

    private void sendAlarm(ManagedObject entity, String id, String alarmId, long threshold, long size) {
        TopoObject mo = (TopoObject)entity;
        LegoAlarm alarm = new LegoAlarm();
        alarm.setMoId(entity.getMoId().longValue());
        alarm.setMoIP(mo.getIpAddress());
        alarm.setMoName(entity.getName());
        alarm.setMoUuid(entity.getUuid());
        alarm.setAlarmId(alarmId);
        alarm.setAlarmTime(System.currentTimeMillis());
        alarm.setAlarmLevel(FaultEnum.AlarmSeverity.MINOR);
        String[] alramParams = new String[]{CapacityUnitUtil.getCapacityAndUnit((Double)Double.valueOf(size), (CapabilityUnitType)CapabilityUnitType.Byte), String.valueOf(CapacityUnitUtil.getCapacityAndUnit((Double)NumberUtil.convertToDouble((Object)String.valueOf(threshold)), (CapabilityUnitType)CapabilityUnitType.Byte))};
        alarm.setAlarmParam(alramParams);
        alarm.setEntity(id);
        alarm.setClearStatus(FaultEnum.ClearState.UNCLEARED);
        LOGGER.info((Object)("Alarm : Send authenticate failed alarm,from resourse:" + mo.getIpAddress()), 90160767696898L);
        ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateAlarm(alarm);
    }

    private void sendRestoreAlarm(ManagedObject entity, String id, String alarmId, long threshold, long size) {
        TopoObject mo = (TopoObject)entity;
        LegoAlarm alarm = new LegoAlarm();
        alarm.setMoId(entity.getMoId().longValue());
        alarm.setMoIP(mo.getIpAddress());
        alarm.setMoName(entity.getName());
        alarm.setMoUuid(entity.getUuid());
        alarm.setAlarmId(alarmId);
        alarm.setAlarmLevel(FaultEnum.AlarmSeverity.MINOR);
        String[] alramParams = new String[]{CapacityUnitUtil.getCapacityAndUnit((Double)Double.valueOf(size), (CapabilityUnitType)CapabilityUnitType.Byte), String.valueOf(CapacityUnitUtil.getCapacityAndUnit((Double)NumberUtil.convertToDouble((Object)String.valueOf(threshold)), (CapabilityUnitType)CapabilityUnitType.Byte))};
        alarm.setAlarmParam(alramParams);
        alarm.setEntity(id);
        LegoAlarm oldalarm = AlarmUtil.getAlarm(id);
        if (null == oldalarm) {
            LOGGER.error((Object)("Send restoreAlarm fail! The oldalarm cannot found by id:" + id), 90160767696916L);
            return;
        }
        alarm.setAlarmTime(oldalarm.getAlarmTime());
        alarm.setClearStatus(FaultEnum.ClearState.CLEARED);
        alarm.setClearTime(System.currentTimeMillis());
        alarm.setClearUser("system");
        LOGGER.info((Object)("Alarm : Send logs size threshold resume alarm,from resourse:" + mo.getIpAddress()), 90160767696899L);
        ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateRestoreAlarm(alarm);
    }
}

