/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.service.impl;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.service.LogsThresholdAlarm;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class GlobalAlarmSyncService
implements SystemStatusChangedListener {
    private static final Log LOGGER = LogFactory.getInstance(GlobalAlarmSyncService.class);
    private static final int PERIOD_TIME = 1800000;
    private IMessageCenter messageCenter;
    private IMoDao moDao;
    private LogsThresholdAlarm alarmer;

    public IMoDao getMoDao() {
        return this.moDao;
    }

    public void setMoDao(IMoDao moDao) {
        this.moDao = moDao;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (!Status.STATUS_STARTED.equals((Object)event.getStatus())) {
            return;
        }
        this.process();
        ManagedObject mo = this.moDao.getMo(ManagedObject.class, "name", "Management System");
        this.queryLogFilesSizeAndSendAlarm(mo);
    }

    public boolean process() {
        LOGGER.info((Object)"sync alarm for all networkentitys after server started...", 90160784211976L);
        List<NetworkEntity> networkEntitys = this.moDao.findMoBy(NetworkEntity.class, new HashMap<String, Object>());
        if (VerifyUtil.isEmpty(networkEntitys)) {
            LOGGER.info((Object)"can't get networkentity from database", 90160784211977L);
            LOGGER.info((Object)"sync alarm for all networkentitys after server end...", 90160784211984L);
            return true;
        }
        for (NetworkEntity entity : networkEntitys) {
            MessageUnit mu = new MessageUnit();
            mu.setSourceAppName("CBB_BASE");
            mu.setCmdcode(5001L);
            mu.setObj((Object)entity);
            mu.setMt(MessageTopic.COMMAND);
            this.messageCenter.sendMessage(mu);
        }
        LOGGER.info((Object)"sync alarm for all networkentitys after server end...", 90160784211984L);
        return true;
    }

    public void queryLogFilesSizeAndSendAlarm(ManagedObject entity) {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new MyTimerTask(entity, this.getAlarmer()), 0L, 1800000L);
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public LogsThresholdAlarm getAlarmer() {
        return this.alarmer;
    }

    public void setAlarmer(LogsThresholdAlarm alarmer) {
        this.alarmer = alarmer;
    }

    private static final class MyTimerTask
    extends TimerTask {
        private ManagedObject entity;
        private LogsThresholdAlarm logsAlarm;

        public MyTimerTask(ManagedObject entity, LogsThresholdAlarm logsAlarm) {
            this.entity = entity;
            this.logsAlarm = logsAlarm;
        }

        @Override
        public void run() {
            try {
                this.logsAlarm.dealThresholdAlarm(this.entity);
            }
            catch (Exception e) {
                LOGGER.error((Object)("log alarm failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }
}

