/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.service.impl;

import com.huawei.ism.base.sdk.model.NeMgrProtocolExtend;
import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.database.sdk.model.DatabaseInstance;
import com.huawei.ism.host.sdk.model.Host;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.List;
import java.util.Map;

@Service(Name="com.huawei.ism.cbb.base.sdk.service.IManagementProtocolService", Desc="", Interface=IManagementProtocolService.class)
public class ManagementProtocolServiceImpl
extends IsmBaseService
implements IManagementProtocolService {
    private static final String HQL_NE_MGR_PROTOCOL_EXTEND_BY_MOID = "FROM NeMgrProtocolExtend WHERE moId = ? ";

    public NeMgrProtocolExtend findByMoId(Long moId) {
        List list = CommonDAOLocator.getMoDao().getHibernateTemplate().find(HQL_NE_MGR_PROTOCOL_EXTEND_BY_MOID, new Object[]{moId});
        if (null == list || 0 == list.size()) {
            return null;
        }
        NeMgrProtocolExtend extParam = (NeMgrProtocolExtend)list.get(0);
        String password = extParam.getNetworkPassword();
        extParam.setNetworkPassword(WccEncryptor.decrypt((String)password));
        this.decryptPass(extParam);
        return extParam;
    }

    public void update(NeMgrProtocolExtend ne) {
        if (null == ne) {
            return;
        }
        String password = ne.getNetworkPassword();
        ne.setNetworkPassword(WccEncryptor.encrypt((String)password));
        this.encryptPass(ne);
        CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)ne);
    }

    public List<DatabaseInstance> queryDBInstByApplicaton(long hostMoId) {
        return super.getMoDao().getAllSubMo(hostMoId, DatabaseInstance.class);
    }

    private void encryptPass(NeMgrProtocolExtend ne) {
        Map extendParams = ne.getExtendParams();
        for (Map.Entry entry : extendParams.entrySet()) {
            if (((String)entry.getKey()).endsWith("appPass")) {
                entry.setValue(WccEncryptor.encrypt((String)((String)entry.getValue())));
            }
            if (((String)entry.getKey()).endsWith("hostPass")) {
                entry.setValue(WccEncryptor.encrypt((String)((String)entry.getValue())));
            }
            if (!((String)entry.getKey()).endsWith("pwd")) continue;
            entry.setValue(WccEncryptor.encrypt((String)((String)entry.getValue())));
        }
    }

    private void decryptPass(NeMgrProtocolExtend ne) {
        Map extendParams = ne.getExtendParams();
        for (Map.Entry entry : extendParams.entrySet()) {
            if (((String)entry.getKey()).endsWith("appPass")) {
                entry.setValue(WccEncryptor.decrypt((String)((String)entry.getValue())));
            }
            if (((String)entry.getKey()).endsWith("hostPass")) {
                entry.setValue(WccEncryptor.decrypt((String)((String)entry.getValue())));
            }
            if (!((String)entry.getKey()).endsWith("pwd")) continue;
            entry.setValue(WccEncryptor.decrypt((String)((String)entry.getValue())));
        }
    }

    public Host getHostInfo(Long moId) {
        return (Host)super.getMoDao().get(moId);
    }

    public NetworkEntity queryFaultArrayInfo(long moId) {
        return (NetworkEntity)super.getMoDao().get(moId);
    }

    public void updateNetworkEntity(NetworkEntity netWorkEntity) {
        CommonDAOLocator.getMoDao().getHibernateTemplate().update((Object)netWorkEntity);
    }
}

