/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.service.impl;

import com.huawei.ism.cbb.base.sdk.bo.Page;
import com.huawei.ism.cbb.base.sdk.service.IScopeManager;
import com.huawei.ism.cbb.base.service.IsmBaseService;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.cbb.resource.sdk.model.TopoObjectQueryCondition;
import com.huawei.lego.cbb.resource.sdk.service.IDataExplore;
import com.huawei.lego.cbb.user.sdk.service.IUserMgr;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service(Name="com.huawei.ism.cbb.base.sdk.service.IScopeManager", Desc="", Interface=IScopeManager.class)
public class ScopeManager
extends IsmBaseService
implements IScopeManager {
    private static IDataExplore dataexplore = null;
    private static IUserMgr usermgr = null;
    private final Log logger = LogFactory.getInstance(((Object)((Object)this)).getClass());

    private IDataExplore getDataExplore() {
        if (null != dataexplore) {
            return dataexplore;
        }
        dataexplore = (IDataExplore)ServiceContext.getInstance().lookup("ResourceApplication/DeviceDataExplore");
        return dataexplore;
    }

    private IUserMgr getUserMgr() {
        if (null != usermgr) {
            return usermgr;
        }
        usermgr = (IUserMgr)ServiceContext.getInstance().lookup("user/usermgr");
        return usermgr;
    }

    public Boolean checkUserGrandObject(long userId, long moId) {
        IUserMgr userMgr = this.getUserMgr();
        if (VerifyUtil.isEmpty((Object)userMgr)) {
            this.logger.error((Object)"can not get user/usermgr service", 90160758784001L);
            return false;
        }
        boolean isAdmin = userMgr.checkUserIsAdmin(userId);
        if (isAdmin) {
            return true;
        }
        ManagedObject mo = (ManagedObject)CommonDAOLocator.getMoDao().get(moId);
        if (VerifyUtil.isEmpty((Object)mo)) {
            this.logger.error((Object)("mo is null\uff1a " + moId), 90160758784001L);
            return false;
        }
        if (mo.getIsTopMo().booleanValue()) {
            return userMgr.checkUserGrandObject(userId, moId);
        }
        ManagedObject topMo = CommonDAOLocator.getMoDao().getMoByUuid(mo.getTopMoUuid(), true);
        if (VerifyUtil.isEmpty((Object)topMo)) {
            this.logger.error((Object)("topmo not found. the submo is " + mo), 90160758784023L);
            return false;
        }
        return userMgr.checkUserGrandObject(userId, topMo.getMoId().longValue());
    }

    public Boolean checkUserGrandObject(long userId, ManagedObject mo) {
        if (VerifyUtil.isEmpty((Object)mo)) {
            this.logger.error((Object)"mo is null", 90160758784001L);
            return false;
        }
        IUserMgr userMgr = this.getUserMgr();
        if (VerifyUtil.isEmpty((Object)userMgr)) {
            this.logger.error((Object)"can not get user/usermgr service", 90160758784001L);
            return false;
        }
        boolean isAdmin = userMgr.checkUserIsAdmin(userId);
        if (isAdmin) {
            return true;
        }
        if (mo.getIsTopMo().booleanValue()) {
            return userMgr.checkUserGrandObject(userId, mo.getMoId().longValue());
        }
        ManagedObject topMo = CommonDAOLocator.getMoDao().getMoByUuid(mo.getTopMoUuid(), true);
        if (VerifyUtil.isEmpty((Object)topMo)) {
            return false;
        }
        return userMgr.checkUserGrandObject(userId, topMo.getMoId().longValue());
    }

    public List<TopoObject> getUserGrandObject(TopoObjectQueryCondition topoobjectquerycondition) {
        IDataExplore dataExplore = this.getDataExplore();
        if (VerifyUtil.isEmpty((Object)dataExplore)) {
            this.logger.error((Object)"can not get ResourceApplication/DeviceDataExplore service", 90160758784001L);
            return new ArrayList<TopoObject>(0);
        }
        return dataExplore.getDataList(topoobjectquerycondition);
    }

    public long getUserGrandObjectCount(TopoObjectQueryCondition topoobjectquerycondition) {
        IDataExplore dataExplore = this.getDataExplore();
        if (VerifyUtil.isEmpty((Object)dataExplore)) {
            this.logger.error((Object)"can not get ResourceApplication/DeviceDataExplore service", 90160758784001L);
            return 0L;
        }
        return dataExplore.getTotalDataCount(topoobjectquerycondition);
    }

    private boolean checkContain(List<TopoObject> topoObectList, long moId) {
        for (TopoObject to : topoObectList) {
            if (moId != to.getMoId()) continue;
            return true;
        }
        return false;
    }

    public <T extends ManagedObject> List<T> filterScopedMo(long userId, List<T> moList) {
        if (VerifyUtil.isEmpty(moList)) {
            return moList;
        }
        IUserMgr userMgr = this.getUserMgr();
        if (VerifyUtil.isEmpty((Object)userMgr)) {
            this.logger.error((Object)"can not get user/usermgr service", 90160758784001L);
            return moList;
        }
        boolean isAdmin = userMgr.checkUserIsAdmin(userId);
        if (isAdmin) {
            return moList;
        }
        Map<String, List<T>> assortedMoMap = this.assortMo(moList);
        List<T> topMoList = assortedMoMap.get("topmolist");
        List<T> subMoList = assortedMoMap.get("submolist");
        return this.getGrandOjbectList(userId, topMoList, subMoList);
    }

    private <T extends ManagedObject> List<T> getGrandOjbectList(long userId, List<T> topMoList, List<T> subMoList) {
        ArrayList<T> grandOjbectList = new ArrayList<T>();
        if (!VerifyUtil.isEmpty(topMoList)) {
            grandOjbectList.addAll(this.dealTopMo(userId, topMoList));
        }
        if (!VerifyUtil.isEmpty(subMoList)) {
            grandOjbectList.addAll(this.dealSubMo(userId, subMoList));
        }
        return grandOjbectList;
    }

    private <T extends ManagedObject> Map<String, List<T>> assortMo(List<T> moList) {
        HashMap<String, List<T>> assortedMoMap = new HashMap<String, List<T>>();
        if (VerifyUtil.isEmpty(moList)) {
            return assortedMoMap;
        }
        ArrayList<ManagedObject> topMoList = new ArrayList<ManagedObject>();
        ArrayList<ManagedObject> subMoList = new ArrayList<ManagedObject>();
        for (ManagedObject mo : moList) {
            if (mo.getIsTopMo().booleanValue()) {
                topMoList.add(mo);
                continue;
            }
            subMoList.add(mo);
        }
        assortedMoMap.put("topmolist", topMoList);
        assortedMoMap.put("submolist", subMoList);
        return assortedMoMap;
    }

    private <T extends ManagedObject> List<T> dealTopMo(long userId, List<T> moList) {
        ArrayList<TopoObject> grandOjbectList = new ArrayList<TopoObject>();
        if (VerifyUtil.isEmpty(moList)) {
            return grandOjbectList;
        }
        Map<String, List<TopoObject>> assortedTopMoMap = this.assortTopMo(moList);
        Set<Map.Entry<String, List<TopoObject>>> assortedTopMoSet = assortedTopMoMap.entrySet();
        for (Map.Entry<String, List<TopoObject>> entry : assortedTopMoSet) {
            List<TopoObject> allGrandOjbectList;
            List<TopoObject> assortedTopoObjList = entry.getValue();
            if (VerifyUtil.isEmpty(assortedTopoObjList)) continue;
            TopoObject topoObject = assortedTopoObjList.get(0);
            TopoObjectQueryCondition condition = new TopoObjectQueryCondition();
            condition.setUserId(String.valueOf(userId));
            if (!VerifyUtil.isEmpty((String)topoObject.getMainType())) {
                condition.setMainDevTypeName(topoObject.getMainType());
            }
            if (!VerifyUtil.isEmpty((String)topoObject.getSubType())) {
                condition.setSubDevTypeName(topoObject.getSubType());
            }
            if (VerifyUtil.isEmpty(allGrandOjbectList = this.getUserGrandObject(condition))) continue;
            for (TopoObject to : assortedTopoObjList) {
                if (!this.checkContain(allGrandOjbectList, to.getMoId())) continue;
                grandOjbectList.add(to);
            }
        }
        return grandOjbectList;
    }

    private <T extends ManagedObject> List<T> dealSubMo(long userId, List<T> moList) {
        ArrayList<ManagedObject> grandOjbectList = new ArrayList<ManagedObject>();
        if (VerifyUtil.isEmpty(moList)) {
            return grandOjbectList;
        }
        Map<String, List<ManagedObject>> assortedSubMoMap = this.assortSubMo(moList);
        Set<Map.Entry<String, List<ManagedObject>>> assortedSubMoSet = assortedSubMoMap.entrySet();
        for (Map.Entry<String, List<ManagedObject>> entry : assortedSubMoSet) {
            List<TopoObject> allGrandOjbectList;
            String key = entry.getKey();
            List<ManagedObject> assortedSubMoList = entry.getValue();
            TopoObjectQueryCondition condition = new TopoObjectQueryCondition();
            condition.setUserId(String.valueOf(userId));
            String[] typeKey = key.split(",");
            if (typeKey.length > 1) {
                if (!VerifyUtil.isEmpty((String)typeKey[0])) {
                    condition.setMainDevTypeName(typeKey[0]);
                }
                if (!VerifyUtil.isEmpty((String)typeKey[1])) {
                    condition.setSubDevTypeName(typeKey[1]);
                }
            }
            if (VerifyUtil.isEmpty(allGrandOjbectList = this.getUserGrandObject(condition))) continue;
            for (ManagedObject subMo : assortedSubMoList) {
                if (!this.checkContain(allGrandOjbectList, NumberUtil.convertToLong((Object)subMo.getPath()))) continue;
                grandOjbectList.add(subMo);
            }
        }
        return grandOjbectList;
    }

    private Map<String, List<ManagedObject>> assortSubMo(List<ManagedObject> moList) {
        HashMap<String, List<ManagedObject>> assortedSubMoMap = new HashMap<String, List<ManagedObject>>();
        if (VerifyUtil.isEmpty(moList)) {
            return assortedSubMoMap;
        }
        for (ManagedObject mo : moList) {
            ManagedObject topMo = CommonDAOLocator.getMoDao().getMoByUuid(mo.getTopMoUuid(), true);
            mo.setPath(String.valueOf(topMo.getMoId()));
            if (VerifyUtil.isEmpty((Object)topMo)) {
                this.logger.error((Object)("topmo not found. the submo is " + mo), 90160758784023L);
                continue;
            }
            String key = ((TopoObject)topMo).getMainType() + "," + ((TopoObject)topMo).getSubType();
            ArrayList<ManagedObject> subMoList = (ArrayList<ManagedObject>)assortedSubMoMap.get(key);
            if (null == subMoList) {
                subMoList = new ArrayList<ManagedObject>();
            }
            subMoList.add(mo);
            assortedSubMoMap.put(key, subMoList);
        }
        return assortedSubMoMap;
    }

    private Map<String, List<TopoObject>> assortTopMo(List<TopoObject> moList) {
        HashMap<String, List<TopoObject>> assortedTopMoMap = new HashMap<String, List<TopoObject>>();
        if (VerifyUtil.isEmpty(moList)) {
            return assortedTopMoMap;
        }
        for (TopoObject topoObj : moList) {
            String key = topoObj.getMainType() + "," + topoObj.getSubType();
            ArrayList<TopoObject> topoObjList = (ArrayList<TopoObject>)assortedTopMoMap.get(key);
            if (null == topoObjList) {
                topoObjList = new ArrayList<TopoObject>();
            }
            topoObjList.add(topoObj);
            assortedTopMoMap.put(key, topoObjList);
        }
        return assortedTopMoMap;
    }

    public <T extends ManagedObject> Page filterScopedMo(long userId, int pageNo, int pageSize, List<T> allMoList) {
        List<T> scopedAllMoList = this.filterScopedMo(userId, allMoList);
        return Page.createPage((int)pageNo, (int)pageSize, scopedAllMoList);
    }

    public Boolean checkUserIsAdmin(long userId) {
        IUserMgr userMgr = this.getUserMgr();
        if (VerifyUtil.isEmpty((Object)userMgr)) {
            this.logger.error((Object)"can not get user/usermgr service", 90160758784001L);
            return false;
        }
        boolean isAdmin = userMgr.checkUserIsAdmin(userId);
        if (isAdmin) {
            return true;
        }
        return false;
    }

    public Long[] getUserGrandObjectMoId(long userId, String mainType, String subType) {
        List<TopoObject> topoObjList;
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            this.addDeviceCondition(mainType, subType, props);
            topoObjList = CommonDAOLocator.getMoDao().findMoBy(TopoObject.class, props);
        } else {
            TopoObjectQueryCondition cond = new TopoObjectQueryCondition();
            cond.setUserId(String.valueOf(userId));
            cond.setIsManaged(Boolean.valueOf(true));
            this.addQueryCondition(mainType, subType, cond);
            topoObjList = this.getUserGrandObject(cond);
        }
        if (VerifyUtil.isEmpty(topoObjList)) {
            return new Long[0];
        }
        Long[] arrayMoIds = new Long[topoObjList.size()];
        int index = 0;
        for (TopoObject topoObject : topoObjList) {
            arrayMoIds[index] = topoObject.getMoId();
            ++index;
        }
        return arrayMoIds;
    }

    public String[] getUserGrandObjectMoUuid(long userId, String mainType, String subType) {
        List<TopoObject> topoObjList;
        if (this.checkUserIsAdmin(userId).booleanValue()) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            this.addDeviceCondition(mainType, subType, props);
            topoObjList = CommonDAOLocator.getMoDao().findMoBy(TopoObject.class, props);
        } else {
            TopoObjectQueryCondition cond = new TopoObjectQueryCondition();
            cond.setUserId(String.valueOf(userId));
            cond.setIsManaged(Boolean.valueOf(true));
            this.addQueryCondition(mainType, subType, cond);
            topoObjList = this.getUserGrandObject(cond);
        }
        if (VerifyUtil.isEmpty(topoObjList)) {
            return new String[0];
        }
        String[] arrayMoUuids = new String[topoObjList.size()];
        int index = 0;
        for (TopoObject topoObject : topoObjList) {
            arrayMoUuids[index] = topoObject.getUuid();
            ++index;
        }
        return arrayMoUuids;
    }

    private void addDeviceCondition(String mainType, String subType, Map<String, Object> props) {
        if (!VerifyUtil.isEmpty((String)mainType)) {
            props.put("mainType", mainType);
        }
        if (!VerifyUtil.isEmpty((String)subType)) {
            props.put("subType", subType);
        }
    }

    private void addQueryCondition(String mainType, String subType, TopoObjectQueryCondition cond) {
        if (!VerifyUtil.isEmpty((String)mainType)) {
            cond.setMainDevTypeName(mainType);
        }
        if (!VerifyUtil.isEmpty((String)subType)) {
            cond.setSubDevTypeName(subType);
        }
    }
}

