/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.task;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.IBackTaskListener;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class AbstractBackTask
implements Runnable {
    private static final int DEFAULT_TIMEOUT = 1800;
    private final Log logger = LogFactory.getInstance(AbstractBackTask.class);
    private BackTask backTask;
    private boolean needUpdateDb = true;
    private IBackTaskService backTaskService;
    private String taskId;
    private int timeout = 1800;
    private long timeStamp;
    private String errorCode;
    private String[] errorParam;
    private Map<String, Object> extendParam;
    private IBackTaskListener listener;

    public AbstractBackTask(String taskId, BackTask backTask, boolean isNeedUpdateDb) {
        this.taskId = taskId;
        this.backTask = backTask;
        this.timeStamp = System.currentTimeMillis();
        this.needUpdateDb = isNeedUpdateDb;
    }

    public AbstractBackTask(String taskId, BackTask backTask, int timeout, boolean isNeedUpdateDb) {
        this(taskId, backTask, timeout, isNeedUpdateDb, null);
    }

    public AbstractBackTask(String taskId, BackTask backTask, int timeout, boolean isNeedUpdateDb, IBackTaskListener listener) {
        this.taskId = taskId;
        this.backTask = backTask;
        this.timeout = timeout;
        this.timeStamp = System.currentTimeMillis();
        this.needUpdateDb = isNeedUpdateDb;
        this.listener = listener;
    }

    public String[] getErrorParam() {
        return this.errorParam;
    }

    public void setErrorParam(String[] errorParam) {
        this.errorParam = errorParam;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    protected abstract void doWork();

    public boolean equals(Object obj) {
        return obj instanceof AbstractBackTask && this.taskId.equals(((AbstractBackTask)obj).taskId) && this.timeStamp == ((AbstractBackTask)obj).timeStamp;
    }

    public BackTask getBackTask() {
        return this.backTask;
    }

    public boolean isNeedUpdateDb() {
        return this.needUpdateDb;
    }

    public IBackTaskService getBackTaskService() {
        return this.backTaskService;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int hashCode() {
        return this.taskId.hashCode() + Long.valueOf(this.timeStamp).hashCode();
    }

    @Override
    public void run() {
        try {
            this.logger.info((Object)("Back task beginning. " + this.toString()), 90160758784000L);
            if (null != this.backTask) {
                this.backTask.setStartTime(new Date());
                this.logger.debug((Object)"Back task is created at %s and executed at %s", new Object[]{this.backTask.getCreatedTime(), this.backTask.getStartTime()});
            }
            this.doWork();
            this.succeed();
            this.logger.info((Object)("Back task run succeed." + this.toString()), 90160758784000L);
        }
        catch (LegoCheckedException e) {
            this.setErrorCode(String.valueOf(e.getErrorCode()));
            if (null != e.getParameters()) {
                String[] param = e.getParameters();
                List<String> paramList = AbstractBackTask.limitSize(param, 1000, 1000);
                this.setErrorParam(paramList.toArray(new String[paramList.size()]));
            }
            this.logger.error((Object)("Back task run fail." + this.toString()), (Throwable)e, 90160758784001L);
            this.failed((Exception)((Object)e));
        }
        catch (Exception e) {
            this.logger.error((Object)("Back task run fail." + this.toString() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
            this.failed(e);
        }
    }

    public static List<String> limitSize(String[] param, int singlength, int maxlength) {
        ArrayList<String> paramList = new ArrayList<String>();
        int sum = 0;
        for (String str : param) {
            if (str.length() > singlength) {
                str = str.substring(0, singlength);
            }
            if ((sum += str.length()) > maxlength) break;
            paramList.add(str);
        }
        return paramList;
    }

    public void setBackTask(BackTask backTask) {
        this.backTask = backTask;
    }

    public void setBackTaskService(IBackTaskService backTaskService) {
        this.backTaskService = backTaskService;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        Long backTaskId = null == this.backTask ? null : this.backTask.getTaskId();
        return "Back Task -- taskId: " + this.taskId + " backTask: " + backTaskId + " timeout: " + this.timeout + " timeStamp: " + this.timeStamp;
    }

    public void updateProgress(int progress) {
        if (!this.needUpdateDb) {
            return;
        }
        this.backTask.setTaskProgress(Integer.valueOf(progress));
        this.backTaskService.updateTask(this.backTask);
    }

    protected void processFailure() {
    }

    protected void processFailure(Exception error) {
        this.processFailure();
    }

    protected void resetBackTaskAfterFail() {
    }

    protected void resetBackTaskAfterSuccess() {
    }

    private void failed(Exception error) {
        try {
            if (null != this.listener) {
                this.listener.notify(false);
            }
            this.processFailure(error);
        }
        catch (Exception e) {
            this.logger.error((Object)("Updating back task failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        if (!this.needUpdateDb) {
            return;
        }
        this.backTask.setTaskProgress(Integer.valueOf(100));
        this.backTask.setTaskResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
        this.backTask.setEndTime(new Date());
        this.backTask.setTaskDetail(this.getErrorCode());
        if (null != this.getErrorParam()) {
            this.backTask.setTaskDetailParas(this.getErrorParam());
        }
        this.resetBackTaskAfterFail();
        try {
            this.backTaskService.updateTask(this.backTask);
        }
        catch (Exception e) {
            this.logger.error((Object)"Updating back task failed. Detail: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
        }
    }

    protected void succeed() {
        if (null != this.listener) {
            this.listener.notify(true);
        }
        if (!this.needUpdateDb) {
            return;
        }
        if (CommonConstant.BACKTASK_RESULT_PROCESS != this.backTask.getTaskResult()) {
            this.logger.info((Object)("Back task run succeed.But it is outtime." + this.toString()));
            return;
        }
        this.backTask.setTaskProgress(Integer.valueOf(100));
        this.backTask.setTaskResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_SUCCESS));
        this.backTask.setEndTime(new Date());
        this.resetBackTaskAfterSuccess();
        this.backTaskService.updateTask(this.backTask);
    }

    public Map<String, Object> getExtendParam() {
        return this.extendParam;
    }

    public void setExtendParam(Map<String, Object> extendParam) {
        this.extendParam = extendParam;
    }
}

