/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.task;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.base.thread.NamedThreadFactory;
import com.huawei.lego.core.base.thread.ThreadPoolConfig;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public final class BackTaskService {
    private static final long SECOND = 1000L;
    private static final long TIMER_SCHEDULE_DELAY_TIME = 10000L;
    private static final long TIMER_SCHEDULE_PERIOD_TIME = 10000L;
    private static final int CORE_POOL_LIMIT = 3000;
    private static final Map<String, BackTaskService> SERVICES = new HashMap<String, BackTaskService>();
    private static final AtomicInteger CORE_POOL_COUNTER = new AtomicInteger();
    private static final Log logger = LogFactory.getInstance(BackTaskService.class);
    private final Object lock = new Object();
    private IBackTaskService taskService;
    private ConcurrentLinkedQueue<TaskUnit> taskUnitQueue = new ConcurrentLinkedQueue();
    private ExecutorService threadPool;

    private BackTaskService(ExecutorService threadPool) {
        if (null == threadPool) {
            logger.error((Object)"Thread pool cannot be null");
            throw new LegoCheckedException(1073947393L);
        }
        this.threadPool = threadPool;
        new Timer(true).schedule(new TimerTask(){

            @Override
            public void run() {
                logger.debug((Object)"Begin timer");
                BackTaskService.this.checkTaskIsTimeout();
                logger.debug((Object)"End timer");
            }
        }, 10000L, 10000L);
    }

    private boolean cancelTask(Future<?> taskFuture) {
        return taskFuture.cancel(true);
    }

    private void checkTaskIsTimeout() {
        try {
            long currentTime = System.currentTimeMillis();
            logger.debug((Object)("currentTime" + currentTime));
            Iterator<TaskUnit> iterator = this.taskUnitQueue.iterator();
            while (iterator.hasNext()) {
                TaskUnit taskUnit = iterator.next();
                AbstractBackTask task = taskUnit.getTask();
                Future<?> future = taskUnit.getTaskFuture();
                long taskStartTime = task.getBackTask().getStartTime().getTime();
                logger.debug((Object)("Task info, taskId=" + task.getTaskId() + ", btId=" + task.getBackTask().getTaskId() + ", taskStartTime=" + taskStartTime));
                if (task.getTimeout() < 0) {
                    logger.info((Object)("task has not timeout, taskId=" + task.getTaskId() + ", backTaskId=" + task.getBackTask().getTaskId()));
                } else if (currentTime - taskStartTime > (long)task.getTimeout() * 1000L) {
                    boolean cancelResult = this.cancelTask(future);
                    logger.info((Object)("Cacel future, taskId=" + task.getTaskId() + ", backTaskId=" + task.getBackTask().getTaskId() + " " + cancelResult));
                }
                logger.debug((Object)("isDone=" + future.isDone()));
                if (future.isDone()) {
                    iterator.remove();
                    logger.debug((Object)("Remove future, taskId=" + task.getTaskId() + ", backTaskId=" + task.getBackTask().getTaskId()));
                }
                if (!task.isNeedUpdateDb() || !future.isCancelled()) continue;
                BackTask backTask = task.getBackTask();
                backTask.setTaskProgress(Integer.valueOf(100));
                backTask.setTaskResult(Integer.valueOf(CommonConstant.BACKTASK_RESULT_FAIL));
                backTask.setEndTime(new Date());
                backTask.setTaskDetail(String.valueOf(1073947433L));
                this.taskService.updateTask(backTask);
            }
        }
        catch (Throwable e) {
            logger.error((Object)("Iterator back task error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }

    private boolean isExistTask(String taskUUID) {
        for (TaskUnit taskUnit : this.taskUnitQueue) {
            AbstractBackTask task = taskUnit.getTask();
            logger.debug((Object)("in queue task(task id:" + task.getTaskId() + "), compared task(" + taskUUID + ") "), 90160758784001L);
            if (!task.getTaskId().equals(taskUUID)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackTaskService getBackTaskService(String poolName) {
        Map<String, BackTaskService> map = SERVICES;
        synchronized (map) {
            if (SERVICES.containsKey(poolName)) {
                return SERVICES.get(poolName);
            }
            ThreadPoolConfig config = ThreadPoolConfig.getThreadPoolConfig((String)poolName);
            if (CORE_POOL_COUNTER.get() + config.getCorePoolSize() > 3000) {
                logger.error((Object)"The core pool size of threads exceeds the limit");
                throw new LegoCheckedException(1073947395L);
            }
            NamedThreadFactory threadFactory = new NamedThreadFactory(poolName);
            ThreadPoolExecutor pool = new ThreadPoolExecutor(config.getCorePoolSize(), config.getMaximumPoolSize(), config.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(config.getWorkQueueSize()), (ThreadFactory)threadFactory);
            BackTaskService service = new BackTaskService(pool);
            SERVICES.put(poolName, service);
            CORE_POOL_COUNTER.addAndGet(config.getCorePoolSize());
            return service;
        }
    }

    public IBackTaskService getBackTaskService() {
        if (null == this.taskService) {
            ServiceContext context = ServiceContext.getInstance();
            this.taskService = (IBackTaskService)context.lookup("task/backTask");
        }
        return this.taskService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long submitTask(AbstractBackTask task) {
        Object object = this.lock;
        synchronized (object) {
            return this.submit(task);
        }
    }

    private long submit(AbstractBackTask task) {
        logger.debug((Object)("Submit Task. task: " + task), 90160758784000L);
        if (null == task) {
            logger.error((Object)"Submit Task Fail. task is null.", 90160758784001L);
            throw new LegoCheckedException(1073947393L);
        }
        if (this.isExistTask(task.getTaskId())) {
            logger.error((Object)("task already exist, id=" + task.getTaskId()), 90160758784001L);
            throw new LegoCheckedException(606L, task.getTaskId());
        }
        long taskId = -1L;
        try {
            if (task.isNeedUpdateDb()) {
                IBackTaskService service = this.getBackTaskService();
                task.setBackTaskService(service);
                taskId = service.addTask(task.getBackTask());
                task.getBackTask().setTaskId(Long.valueOf(taskId));
            }
            Future<?> taskFuture = this.threadPool.submit(task);
            this.taskUnitQueue.add(new TaskUnit(task, taskFuture));
            logger.info((Object)("Submit Task Succeed. task: " + task), 90160758784000L);
        }
        catch (Exception t) {
            logger.error((Object)("Submit Task Fail. task: " + task + ExceptionUtil.getErrorMessage((Throwable)t)), 90160758784001L);
        }
        return taskId;
    }

    private static class TaskUnit {
        private AbstractBackTask task;
        private Future<?> taskFuture;

        public TaskUnit(AbstractBackTask task, Future<?> taskFuture) {
            this.task = task;
            this.taskFuture = taskFuture;
        }

        public AbstractBackTask getTask() {
            return this.task;
        }

        public Future<?> getTaskFuture() {
            return this.taskFuture;
        }
    }
}

