/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.task;

import com.huawei.ism.cbb.base.sdk.constant.CommonConstant;
import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.service.IBackTaskService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Date;
import java.util.function.Supplier;
import org.apache.commons.lang3.math.NumberUtils;

public class BackTaskUtil {
    private static final Log logger = LogFactory.getInstance(BackTaskUtil.class);

    public static BackTask buildBackTask(String targetName, String taskName, String createUser, String taskDetail, String[] taskDetailParas) {
        BackTask backTask = new BackTask();
        backTask.setTargetName(targetName);
        backTask.setTaskName(taskName);
        backTask.setTaskNameLocal(Boolean.TRUE);
        backTask.setCreatedTime(new Date());
        backTask.setStartTime(new Date());
        backTask.setTaskProgress(Integer.valueOf(0));
        backTask.setCreateUser(createUser);
        backTask.setTaskDetail(taskDetail);
        backTask.setTaskDetailParas(taskDetailParas);
        backTask.setTaskLink("");
        return backTask;
    }

    public static BackTask buildBackTask(String targetName, String taskName, Boolean isTaskNameLocal, String createUser, String taskDetail, String[] taskDetailParas) {
        BackTask backTask = new BackTask();
        backTask.setTargetName(targetName);
        backTask.setTaskName(taskName);
        backTask.setTaskNameLocal(isTaskNameLocal);
        backTask.setCreatedTime(new Date());
        backTask.setStartTime(new Date());
        backTask.setTaskProgress(Integer.valueOf(0));
        backTask.setCreateUser(createUser);
        backTask.setTaskDetail(taskDetail);
        backTask.setTaskDetailParas(taskDetailParas);
        backTask.setTaskLink("");
        return backTask;
    }

    public static BackTask buildBackTask(String targetName, String taskName, String createUser, String type, String taskDetail, String[] taskDetailParas) {
        BackTask backTask = new BackTask();
        backTask.setTargetName(targetName);
        backTask.setTaskName(taskName);
        backTask.setTaskNameLocal(Boolean.TRUE);
        backTask.setCreatedTime(new Date());
        backTask.setStartTime(new Date());
        backTask.setTaskProgress(Integer.valueOf(0));
        backTask.setCreateUser(createUser);
        backTask.setType(type);
        backTask.setTaskDetail(taskDetail);
        backTask.setTaskDetailParas(taskDetailParas);
        backTask.setTaskLink("");
        return backTask;
    }

    public static boolean monitorTaskResult(long taskId, long timeOut, long interval) {
        IBackTaskService taskService = (IBackTaskService)ServiceLocator.getInstance().getService(IBackTaskService.class);
        return BackTaskUtil.monitorTaskResult(timeOut, interval, () -> taskService.readTask(taskId));
    }

    public static boolean monitorTaskResult(long timeOut, long interval, Supplier<BackTask> monitor) {
        BackTask task = monitor.get();
        if (null == task) {
            logger.error((Object)"task is null.");
            return false;
        }
        for (long times = timeOut / interval; times > 0L; --times) {
            CommonUtil.sleep((long)(interval * 1000L));
            task = monitor.get();
            if (null == task) {
                logger.error((Object)"task is null.");
                return false;
            }
            if (CommonConstant.BACKTASK_RESULT_FAIL != task.getTaskResult()) continue;
            logger.error((Object)("the task result is fail,targetName=" + task.getTargetName()));
            if (null != task && NumberUtils.isDigits((String)task.getTaskDetail())) {
                throw new LegoCheckedException(Long.parseLong(task.getTaskDetail()), task.getTaskDetailParas());
            }
            return false;
        }
        logger.error((Object)("the task is timeout,taskId=" + task.getTaskId() + "" + task.getTargetName()));
        return false;
    }
}

