/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.util;

import com.huawei.ism.cbb.util.EventCommonUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultDefine;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.IFaultDefineService;
import com.huawei.lego.nem.fault.sdk.service.IFaultGenerateService;

public class AlarmUtil {
    private static final Log LOGGER = LogFactory.getInstance(AlarmUtil.class);

    public static LegoAlarm getAlarm(String entityId) {
        IAlarmService alarmservice = (IAlarmService)ServiceContext.getInstance().lookup("fault/alarmService");
        if (null != alarmservice) {
            try {
                LegoAlarm alarms = alarmservice.getAlarm(EventCommonUtil.getFormatEntity((String)entityId));
                if (null == alarms) {
                    return null;
                }
                return alarms;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void restoreAlarm(String hexAlarmId, String ... params) {
        if (VerifyUtil.isEmpty((Object[])params)) {
            LOGGER.error((Object)"restoreAlarm error : params is empty", 90160758784519L);
            return;
        }
        long moID = 1L;
        String entity = "1" + hexAlarmId + params[0];
        LegoAlarm alarmInDB = AlarmUtil.getAlarm(entity);
        if (null == alarmInDB) {
            return;
        }
        try {
            AlarmUtil.setFaultDefine(alarmInDB);
            alarmInDB.setClearTime(System.currentTimeMillis());
            ((IFaultGenerateService)ServiceLocator.getInstance().getService(IFaultGenerateService.class)).generateLegoRestoreAlarm(alarmInDB);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"generate fault alarm failed", (Throwable)e, 90160758784001L);
        }
    }

    private static void setFaultDefine(LegoAlarm alarmInDB) {
        if (!"0x3230015".equals(alarmInDB.getAlarmId())) {
            alarmInDB.setFaultDefine(null);
            return;
        }
        try {
            ServiceContext context = ServiceContext.getInstance();
            IFaultDefineService service = (IFaultDefineService)context.lookup("fault/faultDefineService");
            if (null == service) {
                LOGGER.error((Object)"get alarm Service error.", 90160758784001L);
                return;
            }
            FaultDefine faultDefine = service.getFaultDefine(alarmInDB.getAlarmId(), alarmInDB.getMoMainType(), alarmInDB.getMoSubType());
            alarmInDB.setFaultDefine(faultDefine);
        }
        catch (Exception e) {
            LOGGER.error((Object)("setFaultDefine exception." + alarmInDB.getAlarmId() + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
    }
}

