/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.cbb.base.util;

import com.huawei.ism.base.sdk.model.NetworkEntity;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.MOUtilCallBack;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MOUtil {
    private static final Log logger = LogFactory.getInstance(MOUtil.class);

    public static void asList(ManagedObject mo, List<ManagedObject> moList) {
        moList.add(mo);
        Set children = mo.getChildMos();
        for (ManagedObject child : children) {
            MOUtil.asList(child, moList);
        }
    }

    public static List<ManagedObject> asList(ManagedObject root) {
        final ArrayList<ManagedObject> temp = new ArrayList<ManagedObject>();
        MOUtil.traverseMo(root, new MOUtilCallBack(){

            @Override
            public boolean call(ManagedObject mo) {
                temp.add(mo);
                return true;
            }
        });
        return temp;
    }

    public static Map<String, ManagedObject> asMap(ManagedObject root) {
        final HashMap<String, ManagedObject> temp = new HashMap<String, ManagedObject>();
        MOUtil.traverseMo(root, new MOUtilCallBack(){

            @Override
            public boolean call(ManagedObject mo) {
                temp.put(mo.getUuid(), mo);
                return true;
            }
        });
        return temp;
    }

    public static List<ManagedObject> searchMoByClass(ManagedObject root, final Class<?> clazz) {
        final ArrayList<ManagedObject> temp = new ArrayList<ManagedObject>();
        MOUtil.traverseMo(root, new MOUtilCallBack(){

            @Override
            public boolean call(ManagedObject mo) {
                if (clazz.isInstance(mo)) {
                    temp.add(mo);
                }
                return true;
            }
        });
        return temp;
    }

    public static ManagedObject searchMoByUuid(ManagedObject mo, final String uuid) {
        final ManagedObject[] temp = new ManagedObject[1];
        MOUtil.traverseMo(mo, new MOUtilCallBack(){

            @Override
            public boolean call(ManagedObject mo) {
                if (uuid.equals(mo.getUuid())) {
                    temp[0] = mo;
                    return false;
                }
                return true;
            }
        });
        return temp[0];
    }

    public static void traverseMo(ManagedObject root, MOUtilCallBack cb) {
        ManagedObject mo;
        ArrayDeque<ManagedObject> mos = new ArrayDeque<ManagedObject>();
        mos.add(root);
        while ((mo = (ManagedObject)mos.poll()) != null && cb.call(mo)) {
            Set children = mo.getChildMos();
            if (children == null || children.isEmpty()) continue;
            mos.addAll(children);
        }
    }

    public static void fillMOChildren(List<? extends ManagedObject> ... mos) {
        for (List<? extends ManagedObject> lmo : mos) {
            if (lmo == null) continue;
            MOUtil.fillMOChildren(lmo);
        }
    }

    public static void fillMOChildren(List<? extends ManagedObject> mos) {
        if (mos == null) {
            logger.error((Object)"NullPointerException !", 90160758784000L);
            return;
        }
        for (ManagedObject managedObject : mos) {
            MOUtil.fillMOChildren(managedObject);
        }
    }

    public static void fillMOChildren(ManagedObject mo) {
        if (mo == null) {
            logger.error((Object)"NullPointerException !", 90160758784000L);
            return;
        }
        if (mo.getParentMo() == null) {
            logger.warn((Object)("NO parent mo found in " + mo), 90160758784000L);
            return;
        }
        mo.getParentMo().getChildMos().add(mo);
    }

    public static void printMOList(Collection<? extends ManagedObject> moList) {
        for (ManagedObject managedObject : moList) {
            logger.debug((Object)("---> " + managedObject), 90160758784000L);
        }
    }

    public static void printMO(ManagedObject mo) {
        logger.debug((Object)("---> " + mo), 90160758784000L);
        Set nodes = mo.getChildMos();
        if (nodes != null) {
            for (ManagedObject tmo : nodes) {
                MOUtil.printMO(tmo);
            }
        }
    }

    public static void saveOrUpdateMoAndDeleteOldMo(IMoDao moDao, List<? extends ManagedObject> newMos, List<? extends ManagedObject> oldMos) {
        if (VerifyUtil.isEmpty(newMos) && VerifyUtil.isEmpty(oldMos)) {
            return;
        }
        HashMap<String, Long> uuidAndMoIdMap = new HashMap<String, Long>();
        if (!VerifyUtil.isEmpty(oldMos)) {
            for (ManagedObject managedObject : oldMos) {
                uuidAndMoIdMap.put(managedObject.getUuid(), managedObject.getMoId());
            }
        }
        if (!VerifyUtil.isEmpty(newMos)) {
            for (ManagedObject managedObject : newMos) {
                uuidAndMoIdMap.remove(managedObject.getUuid());
            }
            moDao.saveOrUpdateMoList(newMos);
        }
        if (!uuidAndMoIdMap.isEmpty()) {
            moDao.deleteMoList(new ArrayList<Long>(uuidAndMoIdMap.values()));
        }
    }

    public static List<Long> calRemovingMO(NetworkEntity ne, IMoDao moDao) {
        logger.info((Object)("Caculate removing mos : " + ne.getSn()), 90160777658624L);
        ArrayList<Long> needToRemove = new ArrayList<Long>();
        List results = moDao.getHibernateTemplate().find("select uuid, moId from ManagedObject where topMoUuid=?", new Object[]{ne.getUuid()});
        if (null == results || results.isEmpty()) {
            return needToRemove;
        }
        final HashMap<String, Long> temp = new HashMap<String, Long>();
        for (Object[] result : results) {
            if (result == null || result.length < 2) continue;
            temp.put(String.valueOf(result[0]), NumberUtil.parseLong((Object)result[1]));
        }
        MOUtil.traverseMo((ManagedObject)ne, new MOUtilCallBack(){

            @Override
            public boolean call(ManagedObject mo) {
                temp.remove(mo.getUuid());
                return true;
            }
        });
        needToRemove.addAll(temp.values());
        return needToRemove;
    }
}

