/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.ecs;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.connector.http.RequestInvocation;
import com.huawei.sdk.connector.http.RestHttpClient;
import com.huawei.sdk.connector.utils.RequestUtil;
import com.huawei.sdk.ecs.constants.EcsClientConsts;
import com.huawei.sdk.ecs.model.request.ListInstanceRequest;
import com.huawei.sdk.ecs.model.response.InstanceResponse;
import com.huawei.sdk.ecs.model.response.ListInstancesResponse;
import java.io.IOException;
import java.util.Locale;

public class EcsClient {
    private static final Log LOG = LogFactory.getInstance(EcsClient.class);

    public InstanceResponse queryInstance(Credential credential, String serverId) throws ResponseException, ClientException, IOException {
        String url = String.format(Locale.ENGLISH, EcsClientConsts.EcsRequestUriEnum.NOVA_QUERY_SERVER.getUri(), credential.getProjectId(), serverId);
        LOG.info((Object)"ECS queryInstance url: %s", new Object[]{url});
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(url);
        invocation.setHeader("X_OPENSTACK_NOVA_API_VERSION", "2.26");
        return (InstanceResponse)client.get(invocation, InstanceResponse.class);
    }

    public void startEcs(Credential credential, String serverId) throws ResponseException, ClientException, IOException {
        String url = String.format(Locale.ENGLISH, EcsClientConsts.EcsRequestUriEnum.NOVA_OPERATE_SERVER.getUri(), credential.getProjectId(), serverId);
        LOG.info((Object)"Start ECS url: %s", new Object[]{url});
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(url);
        invocation.setJsonStr(EcsClientConsts.EcsOperateJsonEnum.START.getOperateJson());
        client.post(invocation, String.class);
    }

    public void stopEcs(Credential credential, String serverId) throws ResponseException, ClientException, IOException {
        String url = String.format(Locale.ENGLISH, EcsClientConsts.EcsRequestUriEnum.NOVA_OPERATE_SERVER.getUri(), credential.getProjectId(), serverId);
        LOG.info((Object)"Stop Ecs url: %s", new Object[]{url});
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(url);
        invocation.setJsonStr(EcsClientConsts.EcsOperateJsonEnum.STOP.getOperateJson());
        client.post(invocation, String.class);
    }

    public ListInstancesResponse queryInstanceList(Credential credential, ListInstanceRequest request) throws ResponseException, ClientException, IOException {
        String url = String.format(Locale.ENGLISH, EcsClientConsts.EcsRequestUriEnum.NOVA_QUERY_SERVER_LIST.getUri(), credential.getProjectId());
        url = url + "?" + RequestUtil.buildQueryParamsStr((Object)request);
        LOG.info((Object)"ECS queryInstanceList url: %s", new Object[]{url});
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(url);
        invocation.setHeader("X_OPENSTACK_NOVA_API_VERSION", "2.26");
        return (ListInstancesResponse)client.get(invocation, ListInstancesResponse.class);
    }
}

