/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.rds;

import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.sdk.connector.auth.Credential;
import com.huawei.sdk.connector.exceptions.ClientException;
import com.huawei.sdk.connector.exceptions.ResponseException;
import com.huawei.sdk.connector.http.RequestInvocation;
import com.huawei.sdk.connector.http.RestHttpClient;
import com.huawei.sdk.connector.utils.RequestUtil;
import com.huawei.sdk.rds.model.request.ListInstancesRequest;
import com.huawei.sdk.rds.model.response.ListInstancesResponse;
import com.huawei.sdk.rds.model.response.ListJobInfoResponse;
import com.huawei.sdk.rds.model.response.StartFailoverResponse;
import java.io.IOException;
import java.util.Locale;

public class RdsClient {
    public ListInstancesResponse listInstances(ListInstancesRequest request, Credential credential) throws ResponseException, ClientException, IOException {
        String requestUrl = String.format(Locale.ENGLISH, "%s/instances", credential.getProjectId());
        String parametersUrl = RequestUtil.buildQueryParamsStr((Object)request);
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        if (!VerifyUtil.isEmpty((String)parametersUrl)) {
            requestUrl = requestUrl + "?" + parametersUrl;
        }
        invocation.setUrl(requestUrl);
        return (ListInstancesResponse)client.get(invocation, ListInstancesResponse.class);
    }

    public StartFailoverResponse startFailover(String projectId, String instanceId, Credential credential) throws ResponseException, ClientException, IOException {
        String requestUrl = String.format(Locale.ENGLISH, "%s/instances/%s/failover", projectId, instanceId);
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(requestUrl);
        return (StartFailoverResponse)client.put(invocation, StartFailoverResponse.class);
    }

    public ListJobInfoResponse listJobInfo(String projectId, String id, Credential credential) throws ResponseException, ClientException, IOException {
        String requestUrl = String.format(Locale.ENGLISH, "%s/jobs?id=%s", projectId, id);
        RestHttpClient client = new RestHttpClient(credential);
        RequestInvocation invocation = new RequestInvocation();
        invocation.setUrl(requestUrl);
        return (ListJobInfoResponse)client.get(invocation, ListJobInfoResponse.class);
    }
}

