/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.sdk.rds.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Datastore {
    private TypeEnum type;
    private String version;
    @JsonProperty(value="complete_version")
    private String completeVersion;

    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCompleteVersion() {
        return this.completeVersion;
    }

    public void setCompleteVersion(String completeVersion) {
        this.completeVersion = completeVersion;
    }

    public static final class TypeEnum {
        public static final TypeEnum MYSQL = new TypeEnum("MySQL");
        public static final TypeEnum POSTGRESQL = new TypeEnum("PostgreSQL");
        public static final TypeEnum SQLSERVER = new TypeEnum("SQLServer");
        private static final Map<String, TypeEnum> STATIC_FIELDS = TypeEnum.createStaticFields();
        private String value;

        private static Map<String, TypeEnum> createStaticFields() {
            HashMap<String, TypeEnum> map = new HashMap<String, TypeEnum>();
            map.put("MySQL", MYSQL);
            map.put("PostgreSQL", POSTGRESQL);
            map.put("SQLServer", SQLSERVER);
            return Collections.unmodifiableMap(map);
        }

        TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static Optional<TypeEnum> fromValue(String value) {
            if (value == null) {
                return Optional.empty();
            }
            TypeEnum result = STATIC_FIELDS.get(value);
            if (result == null) {
                result = new TypeEnum(value);
            }
            return Optional.of(result);
        }

        public static Optional<TypeEnum> valueOf(String value) {
            if (value == null) {
                return Optional.empty();
            }
            TypeEnum result = STATIC_FIELDS.get(value);
            if (result != null) {
                return Optional.of(result);
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeEnum) {
                return this.value.equals(((TypeEnum)obj).value);
            }
            return false;
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }
}

