/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.arb;

import com.huawei.ism.drm.arbitration.service.ArbitrationCenterHelper;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import com.huawei.jetcd.exception.EtcdAuthException;
import com.huawei.jetcd.exception.EtcdClientException;
import com.huawei.jetcd.exception.EtcdServerCheckException;
import com.huawei.jetcd.exception.EtcdServerException;
import java.util.Scanner;

public class ArbitrationCenter {
    public static void main(String[] args) {
        if ("getDetailStatus".equals(args[0])) {
            ArbitrationCenter.getDetailStatus(args[1]);
        } else {
            Scanner scanner = new Scanner(System.in);
            String password = scanner.nextLine();
            scanner.close();
            ArbitrationCenter.valiateEtcd(args, password);
        }
    }

    public static void valiateEtcd(String[] param, String password) {
        try {
            ArbitrationCenterHelper.getInstance().authUser(param, password);
            System.exit(0);
        }
        catch (Exception e) {
            if (e instanceof EtcdAuthException && 401 == ((EtcdAuthException)e).getCode()) {
                System.exit(2);
            }
            if (e instanceof EtcdClientException && 404L == ((EtcdClientException)e).getErrorCode()) {
                System.exit(3);
            }
            if (e instanceof EtcdAuthException && 400 == ((EtcdAuthException)e).getCode()) {
                System.exit(4);
            }
            if (e instanceof EtcdServerException && 500 == ((EtcdServerException)e).getErrorCode()) {
                System.exit(5);
            }
            if (e instanceof EtcdServerException && 100 == ((EtcdServerException)e).getErrorCode()) {
                System.exit(6);
            }
            System.exit(1);
        }
    }

    public static void getDetailStatus(String regionId) {
        try {
            String result = ArbitrationCenterHelper.getInstance().getDetailStatus(regionId);
            if (VerifyUtil.isEmpty((String)result)) {
                System.out.println(1);
                return;
            }
            JSONObject jsonObject = JSONObject.fromObject((Object)result);
            System.out.println("localDcStatus:" + jsonObject.get("localDcStatus"));
            System.out.println("remoteDcStatus:" + jsonObject.get("remoteDcStatus"));
            System.out.println("isMatch:" + jsonObject.get("isMatch"));
            System.exit(0);
        }
        catch (EtcdServerCheckException e) {
            System.out.println("localDcStatus:unknow");
            System.out.println("remoteDcStatus:unknow");
            System.out.println("isMatch:true");
            System.exit(0);
        }
        catch (Exception e) {
            System.exit(1);
        }
    }
}

