/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.nms.util;

import com.adventnet.nms.util.Response;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CmdLineImpl {
    static final int OK = 0;
    static final int NOT_CONNECTED = 9997;
    static final int EXEC_TIMEOUT = 9998;
    static final int PARAM_CHECK_ERROR = 9999;
    static final int UNKNOWN_FAILURE = 10000;
    private static final int DEFAULT_TIMEOUT = 15000;
    private static Log sLogger = LogFactory.getInstance(CmdLineImpl.class);

    public Response exec(long timeout, String ... cmdpara) {
        return this.exec(true, timeout, cmdpara);
    }

    public Response exec(String ... cmdpara) {
        return this.exec(true, 15000L, cmdpara);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response exec(boolean wait, long timeout, String ... cmdpara) {
        long timeOut;
        long l = timeOut = timeout > 0L ? timeout : 15000L;
        if (cmdpara == null || cmdpara.length == 0) {
            Response resp = new Response();
            resp.setStatusCode(9999);
            resp.setReasonPhrase("Command parameter cannot be null.");
            return resp;
        }
        if (cmdpara[0].contains(" ")) {
            StringTokenizer st = new StringTokenizer(cmdpara[0]);
            String[] cmdarray = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                cmdarray[i] = st.nextToken();
                ++i;
            }
            cmdpara = cmdarray;
        }
        ProcessBuilder processbuilder = new ProcessBuilder(cmdpara);
        processbuilder.redirectErrorStream(true);
        IOReader reader = new IOReader(processbuilder, wait, timeOut);
        Future<?> future = ExecutionService.submit(reader);
        try {
            future.get(timeOut, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            sLogger.error((Object)("Reading IO failed." + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
        finally {
            reader.close();
        }
        return reader.execresult;
    }

    private static class IOReader
    implements Runnable {
        static final int ARRAY_SIZE = 512;
        static final long SLEEP_TIME_OUT = 100L;
        private Response execresult = new Response();
        private boolean kout = true;
        private long timeOut = 15000L;
        private ByteArrayOutputStream bouts = new ByteArrayOutputStream();
        private ProcessBuilder pb = null;
        private Process process = null;
        private boolean terminate = false;

        IOReader(ProcessBuilder p, boolean keep, long timeout) {
            this.pb = p;
            this.kout = keep;
            this.timeOut = timeout;
        }

        public void close() {
            this.terminate = true;
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.pb == null) {
                return;
            }
            try {
                this.process = this.pb.start();
            }
            catch (Exception e) {
                this.execresult.setStatusCode(10000);
                this.execresult.setReasonPhrase(e.getMessage());
                return;
            }
            InputStream ins = this.process.getInputStream();
            byte[] buff = new byte[512];
            long start = System.currentTimeMillis();
            try {
                this.write(ins, buff, start);
            }
            catch (IOException e) {
                sLogger.error((Object)"", (Throwable)e);
            }
            finally {
                this.execresult.setContent(new String(this.bouts.toByteArray(), Charset.defaultCharset()));
                this.execresult.setReasonPhrase(this.execresult.getContent());
                this.releaseResources(ins);
            }
        }

        private void releaseResources(InputStream ins) {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException e) {
                    sLogger.error((Object)"", (Throwable)e);
                }
            }
            if (this.process != null) {
                this.process.destroy();
            }
        }

        private void write(InputStream ins, byte[] buff, long start) throws IOException {
            boolean shouldBreak = false;
            while (!this.terminate && System.currentTimeMillis() - start < this.timeOut && !shouldBreak) {
                shouldBreak = this.write(ins, buff);
            }
        }

        private boolean write(InputStream ins, byte[] buff) throws IOException {
            if (ins.available() > 0) {
                int len = ins.read(buff);
                if (this.kout && len > 0) {
                    this.bouts.write(buff, 0, len);
                }
            } else {
                try {
                    this.execresult.setStatusCode(this.process.exitValue());
                    return true;
                }
                catch (IllegalThreadStateException e1) {
                    sLogger.error((Object)"", (Throwable)e1);
                    CommonUtil.sleep((long)100L);
                }
            }
            return false;
        }
    }
}

