/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.license.util;

import com.huawei.lego.cbb.license.util.IEsnTool;
import com.huawei.lego.cbb.license.util.SignVerifier;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoCmdUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public abstract class EsnToolBase
implements IEsnTool {
    private static final int VALUE_2 = 2;
    private String toolpath = "";
    private transient Log logger = null;

    public EsnToolBase(String path) {
        this.toolpath = path;
        this.logger = LogFactory.getInstance(EsnToolBase.class);
    }

    @Override
    public List<String> getServerEsns() {
        ArrayList<String> arrayList;
        BufferedReader br;
        FileInputStream fis;
        Process process;
        String executeTxt;
        ArrayList<String> esnlist;
        block6: {
            esnlist = new ArrayList<String>();
            String executeCmd = this.getExecuteCmd();
            executeTxt = this.toolpath + "Esn.txt";
            this.logger.info((Object)("The execute cmd: " + executeCmd), 1L);
            this.logger.info((Object)("The esn txt: " + executeTxt), 1L);
            process = null;
            fis = null;
            br = null;
            this.deleteEsnFile(executeTxt, true);
            SignVerifier.getInstance().verify(executeCmd);
            process = Runtime.getRuntime().exec(executeCmd);
            if (null == process || 0 == LegoCmdUtil.waitProcessExecuteWithTimeout((Process)process)) break block6;
            ArrayList<String> arrayList2 = esnlist;
            CommonUtil.close(br);
            CommonUtil.close(fis);
            CommonUtil.destroyProcess((Process)process);
            this.deleteEsnFile(executeTxt, false);
            return arrayList2;
        }
        try {
            String[] strs;
            this.logger.info((Object)"End esn process.", 1L);
            File esnTxt = new File(executeTxt);
            fis = new FileInputStream(esnTxt);
            br = new BufferedReader(new InputStreamReader((InputStream)fis, Charset.defaultCharset()));
            StringBuffer strBuf = this.getStrBuf(br, esnlist);
            String str = strBuf.toString().trim();
            if (!"".equals(str) && this.getStrsLens(strs = str.split(":"))) {
                esnlist.add(strs[1]);
                this.logger.info((Object)("THE ESN: " + strs[1]), 1L);
            }
            this.logger.info((Object)"End getServerEsns", 1L);
            arrayList = esnlist;
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("getServerEsns error: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                throw new LegoUncheckedException("getServerEsns error: " + ExceptionUtil.getErrorMessage((Throwable)e));
            }
            catch (Throwable throwable) {
                CommonUtil.close(br);
                CommonUtil.close(fis);
                CommonUtil.destroyProcess(process);
                this.deleteEsnFile(executeTxt, false);
                throw throwable;
            }
        }
        CommonUtil.close((Closeable)br);
        CommonUtil.close((Closeable)fis);
        CommonUtil.destroyProcess((Process)process);
        this.deleteEsnFile(executeTxt, false);
        return arrayList;
    }

    private void deleteEsnFile(String executeTxt, boolean isThrowException) {
        boolean isDel;
        File esnTxt = new File(executeTxt);
        if (esnTxt.exists() && !(isDel = esnTxt.delete())) {
            this.logger.error((Object)"deleteEsnFile failed.", 1L);
            if (isThrowException) {
                throw new LegoUncheckedException(1073947439L);
            }
        }
    }

    public abstract String getExecuteCmd();

    private StringBuffer getStrBuf(BufferedReader br, List<String> esnlist) throws IOException {
        int tempChar;
        StringBuffer strBuf = new StringBuffer();
        while ((tempChar = br.read()) != -1) {
            if ((char)tempChar != '\n' && (char)tempChar != '\r') {
                strBuf.append((char)tempChar);
                continue;
            }
            String str = strBuf.toString().trim();
            this.readChar(esnlist, str);
            strBuf = new StringBuffer();
        }
        return strBuf;
    }

    private void readChar(List<String> esnlist, String str) {
        String[] strs;
        if (!"".equals(str) && (strs = str.split(":")).length != 0 && strs.length == 2) {
            esnlist.add(strs[1]);
            this.logger.info((Object)("THE ESN: " + strs[1]), 1L);
        }
    }

    private boolean getStrsLens(String[] strs) {
        return strs.length != 0 && strs.length == 2;
    }

    public Log getLogger() {
        return this.logger;
    }

    public String getToolpath() {
        return this.toolpath;
    }
}

