/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.license.util;

import com.huawei.lego.cbb.license.util.EsnToolLinuxImpl;
import com.huawei.lego.cbb.license.util.EsnToolWinImpl;
import com.huawei.lego.cbb.license.util.IEsnTool;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.PathUtil;
import java.io.File;
import java.util.List;

public final class ServerEsnBuilder {
    private static ServerEsnBuilder seb = null;
    private transient Log logger = LogFactory.getInstance(ServerEsnBuilder.class);
    private IEsnTool iet = null;

    private ServerEsnBuilder() {
        String sOs = "";
        try {
            String legoRuntimePath = PathUtil.getLegoRuntimePath();
            legoRuntimePath = legoRuntimePath + File.separator + "tools" + File.separator;
            this.logger.info((Object)"ServerEsnBuilder: ", 1L);
            sOs = System.getProperty("os.name");
            this.iet = null != sOs && sOs.contains("Linux") ? new EsnToolLinuxImpl(legoRuntimePath) : new EsnToolWinImpl(legoRuntimePath);
        }
        catch (Exception e) {
            this.logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    public static synchronized ServerEsnBuilder getInstance() {
        if (null == seb) {
            seb = new ServerEsnBuilder();
        }
        return seb;
    }

    public List<String> getServerEsns() {
        if (null != this.iet) {
            return this.iet.getServerEsns();
        }
        return null;
    }
}

