/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.license.util;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.security.SignatureException;

public class SignVerifier {
    public static final String SIGNFILE_POSTFIX = ".sign";
    private static final int BUFFSIZE = 500;
    private static SignVerifier instance;
    private static Log log;

    private SignVerifier() {
    }

    public static SignVerifier getInstance() {
        return instance;
    }

    public void verify(String fileName) throws SignatureException {
        File file = new File(fileName);
        this.verify(file);
    }

    public void verify(String[] fileNames) throws SignatureException {
        for (String fileName : fileNames) {
            File file = new File(fileName);
            this.verify(file);
        }
    }

    public void verify(File file) throws SignatureException {
        if (null == file || !file.exists()) {
            throw new SignatureException("Verify fail");
        }
        String path = file.getParent();
        File saltFile = new File(path, file.getName() + SIGNFILE_POSTFIX);
        FileInputStream input = null;
        try {
            String saltEncrypted = this.readEncryptedSign(saltFile);
            boolean isIntegrated = WccEncryptor.checkFileComplete((String)file.getCanonicalPath(), (String)saltEncrypted);
            if (!isIntegrated) {
                throw new SignatureException("Verify failed.");
            }
        }
        catch (Exception e) {
            log.error((Object)("Verify file failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            throw new SignatureException("Verify file failed." + ExceptionUtil.getErrorMessage((Throwable)e));
        }
        finally {
            this.closeStream(input);
        }
    }

    private void closeStream(FileInputStream input) {
        if (null != input) {
            try {
                input.close();
            }
            catch (IOException e) {
                log.error((Object)"close inputstream failed, ", (Throwable)e, 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readEncryptedSign(File file) throws IOException, SignatureException {
        String string;
        FileInputStream fileInputStream = null;
        InputStreamReader inputReader = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputReader = new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset());
            bufferedReader = new BufferedReader(inputReader, 500);
            char[] buffer = new char[500];
            int numRead = bufferedReader.read(buffer);
            string = new String(buffer).substring(0, numRead);
        }
        catch (Throwable throwable) {
            CommonUtil.close(bufferedReader);
            CommonUtil.close(inputReader);
            CommonUtil.close((Closeable)fileInputStream);
            throw throwable;
        }
        CommonUtil.close((Closeable)bufferedReader);
        CommonUtil.close((Closeable)inputReader);
        CommonUtil.close((Closeable)fileInputStream);
        return string;
    }

    static {
        log = LogFactory.getInstance(SignVerifier.class);
        instance = new SignVerifier();
    }
}

