/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.minister.northbound.alarm;

import com.huawei.lego.cbb.minister.northbound.alarm.I18nMrgUtil;
import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.base.LegoMoGenerator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.sdk.model.LegoEvent;
import com.huawei.lego.nem.fault.sdk.model.NorthFaultMsg;
import com.huawei.lego.nem.fault.sdk.util.FaultSdkUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public final class NorthTrapConverter {
    private static final String[] LEGO_NORTHALARM_OIDS = new String[28];
    private static Log sLogger;

    private NorthTrapConverter() {
    }

    private static String[] getAlarmVariables(LegoAlarm legoAlarm, FaultEnum.NorthTrapType trapType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String confirmTime;
            String clearTime;
            String[] alarmVariables = new String[28];
            alarmVariables[0] = String.valueOf(legoAlarm.getNmsSequence());
            alarmVariables[1] = String.valueOf(trapType.getValue());
            Date alarmDate = new Date(legoAlarm.getAlarmTime());
            alarmVariables[2] = sdf.format(alarmDate);
            alarmVariables[3] = legoAlarm.getMoName();
            alarmVariables[4] = legoAlarm.getProductName();
            String mainType = legoAlarm.getMoMainType();
            mainType = NorthTrapConverter.rebuildMainType(mainType);
            String subType = legoAlarm.getMoSubType();
            subType = NorthTrapConverter.rebuildSubType(subType);
            alarmVariables[5] = NorthTrapConverter.codeSnmpString(mainType + "," + subType);
            alarmVariables[6] = legoAlarm.getMoUuid();
            alarmVariables[7] = String.valueOf(legoAlarm.getAlarmSequence());
            alarmVariables[8] = legoAlarm.getAlarmId();
            alarmVariables[9] = String.valueOf(legoAlarm.getAlarmType());
            alarmVariables[10] = String.valueOf(legoAlarm.getAlarmLevel().getValue());
            alarmVariables[11] = String.valueOf(legoAlarm.getClearStatus().getValue());
            alarmVariables[12] = clearTime = NorthTrapConverter.getDateString(legoAlarm.getClearTime(), sdf);
            alarmVariables[13] = legoAlarm.getClearUser();
            alarmVariables[14] = String.valueOf(legoAlarm.getConfirmStatus().getValue());
            alarmVariables[15] = confirmTime = NorthTrapConverter.getDateString(legoAlarm.getConfirmTime(), sdf);
            alarmVariables[16] = legoAlarm.getConfirmUser();
            alarmVariables[17] = NorthTrapConverter.codeSnmpString(NorthTrapConverter.getString(legoAlarm.getAlarmName(), Locale.ENGLISH, new String[0]));
            alarmVariables[18] = NorthTrapConverter.codeSnmpString(NorthTrapConverter.getString(legoAlarm.getAlarmDesc(), Locale.ENGLISH, legoAlarm.getAlarmParam()));
            alarmVariables[19] = NorthTrapConverter.codeSnmpString(NorthTrapConverter.getString(legoAlarm.getSysEffect(), Locale.ENGLISH, new String[0]));
            alarmVariables[20] = NorthTrapConverter.codeSnmpString(NorthTrapConverter.getString(legoAlarm.getAdvice(), Locale.ENGLISH, new String[0]));
            alarmVariables[21] = NorthTrapConverter.getString(legoAlarm.getLocation(), Locale.ENGLISH, legoAlarm.getAlarmParam());
            alarmVariables[22] = NorthTrapConverter.codeSnmpString(legoAlarm.getEntity());
            alarmVariables[23] = FaultSdkUtil.convertParam((String[])legoAlarm.getAlarmParam());
            alarmVariables[24] = String.valueOf(legoAlarm.getMoId());
            alarmVariables[25] = legoAlarm.getGmt();
            alarmVariables[26] = legoAlarm.getNmsIp();
            alarmVariables[27] = legoAlarm.getMoIP();
            return alarmVariables;
        }
        catch (Exception e) {
            sLogger.error((Object)("getAlarmVariables error in NorthTrapConverter." + ExceptionUtil.getErrorMessage((Throwable)e)));
            return new String[0];
        }
    }

    private static String getDateString(long dateTime, SimpleDateFormat sdf) {
        String confirmTime = "";
        if (dateTime > 0L) {
            Date confirmDate = new Date(dateTime);
            confirmTime = sdf.format(confirmDate);
        }
        return confirmTime;
    }

    private static String rebuildMainType(String mainType) {
        if (null == mainType) {
            sLogger.error((Object)"mainType is null");
            mainType = "Application";
        } else {
            mainType = NorthTrapConverter.getString(mainType, Locale.ENGLISH, new String[0]);
        }
        return mainType;
    }

    private static String rebuildSubType(String subType) {
        if (null == subType) {
            sLogger.error((Object)"subType is null");
            subType = "Application";
        } else {
            String nodeSubType = NorthTrapConverter.getString(subType, Locale.ENGLISH, new String[0]);
            if (null != nodeSubType && !nodeSubType.trim().isEmpty() && !subType.equals(nodeSubType)) {
                subType = nodeSubType;
            }
        }
        return subType;
    }

    public static String[] convertTrapVariable(NorthFaultMsg faultMsg) {
        if (null == faultMsg) {
            sLogger.error((Object)"convertTrapVariable failed, param NorthFaultMsg is null.");
            return new String[0];
        }
        LegoAlarm legoAlarm = faultMsg.getLegoAlarm();
        LegoEvent legoEvent = faultMsg.getLegoEvent();
        FaultEnum.NorthTrapType trapType = faultMsg.getTrapType();
        TopoObject topoObject = faultMsg.getTopoObject();
        String ipAddress = new LegoMoGenerator().getInstallServerIp();
        if (null != legoAlarm) {
            legoAlarm.setNmsIp(ipAddress);
            return NorthTrapConverter.getAlarmVariables(legoAlarm, trapType);
        }
        if (null != topoObject && FaultEnum.NorthTrapType.EVENT == trapType) {
            topoObject.setLocation(ipAddress);
            return NorthTrapConverter.getTopoObjectVariables(topoObject, trapType);
        }
        return NorthTrapConverter.getEventVariables(legoEvent, trapType);
    }

    private static String[] getTopoObjectVariables(TopoObject topoObject, FaultEnum.NorthTrapType trapType) {
        try {
            String[] topoObjectVariables = new String[]{String.valueOf(topoObject.getMoId()), String.valueOf(trapType.getValue()), topoObject.getLocation(), topoObject.getIpAddress(), topoObject.getUuid(), "TopoObject", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""};
            return topoObjectVariables;
        }
        catch (Exception e) {
            sLogger.error((Object)("getEventVariables error in NorthTrapConverter: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return new String[0];
        }
    }

    private static String getString(String key, Locale local, String[] params) {
        if (null == key || "".equals(key)) {
            return "";
        }
        try {
            if (VerifyUtil.isEmpty((Object[])params)) {
                return I18nMrgUtil.getInstance().getI18nMgr().getString(key, local);
            }
            return I18nMrgUtil.getInstance().getI18nMgr().getString(key, local, params);
        }
        catch (Exception e) {
            sLogger.error((Object)("getString exception in NorthTrapConverter: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return key;
        }
    }

    private static String codeSnmpString(String str) {
        try {
            if (null != str) {
                return new String(str.getBytes(Charset.defaultCharset()), "ISO8859-1");
            }
        }
        catch (UnsupportedEncodingException e) {
            sLogger.error((Object)"codeSnmpString with ISO8859-1 failed in NorthTrapConverter.", (Throwable)e);
        }
        return str;
    }

    private static String[] getEventVariables(LegoEvent legoEvent, FaultEnum.NorthTrapType trapType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String[] eventVariables = new String[28];
            eventVariables[0] = String.valueOf(legoEvent.getId());
            eventVariables[1] = String.valueOf(trapType.getValue());
            Date eventDate = new Date(legoEvent.getEventTime());
            eventVariables[2] = sdf.format(eventDate);
            eventVariables[3] = legoEvent.getMoName();
            eventVariables[4] = legoEvent.getProductName();
            String mainType = legoEvent.getMoMainType();
            mainType = NorthTrapConverter.rebuildMainType(mainType);
            String subType = legoEvent.getMoSubType();
            subType = NorthTrapConverter.rebuildSubType(subType);
            eventVariables[5] = mainType + "," + subType;
            eventVariables[6] = legoEvent.getMoUuid();
            eventVariables[7] = String.valueOf(legoEvent.getSequence());
            eventVariables[8] = legoEvent.getEventId();
            eventVariables[9] = String.valueOf(legoEvent.getEventType());
            eventVariables[10] = String.valueOf(legoEvent.getEventLevel());
            eventVariables[11] = "";
            eventVariables[12] = "";
            eventVariables[13] = "";
            eventVariables[14] = "";
            eventVariables[15] = "";
            eventVariables[16] = "";
            eventVariables[17] = NorthTrapConverter.getString(legoEvent.getEventName(), Locale.ENGLISH, new String[0]);
            eventVariables[18] = NorthTrapConverter.getString(legoEvent.getEventDesc(), Locale.ENGLISH, legoEvent.getEventParam());
            eventVariables[19] = NorthTrapConverter.getString(legoEvent.getSysEffect(), Locale.ENGLISH, new String[0]);
            eventVariables[20] = NorthTrapConverter.getString(legoEvent.getAdvice(), Locale.ENGLISH, new String[0]);
            eventVariables[21] = NorthTrapConverter.getString(legoEvent.getLocation(), Locale.ENGLISH, legoEvent.getEventParam());
            eventVariables[22] = String.valueOf(legoEvent.getId());
            eventVariables[23] = FaultSdkUtil.convertParam((String[])legoEvent.getEventParam());
            eventVariables[24] = String.valueOf(legoEvent.getMoId());
            eventVariables[25] = "";
            eventVariables[26] = "";
            eventVariables[27] = "";
            return eventVariables;
        }
        catch (Exception e) {
            sLogger.error((Object)("getEventVariables error in NorthTrapConverter: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            return new String[0];
        }
    }

    public static String[] getNorthSnmpOID() {
        String[] oidsCopy = new String[LEGO_NORTHALARM_OIDS.length];
        System.arraycopy(LEGO_NORTHALARM_OIDS, 0, oidsCopy, 0, LEGO_NORTHALARM_OIDS.length);
        return oidsCopy;
    }

    static {
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[0] = ".1.3.6.1.4.1.34774.1.10.2.2.1";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[1] = ".1.3.6.1.4.1.34774.1.10.2.2.2";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[2] = ".1.3.6.1.4.1.34774.1.10.2.2.3";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[3] = ".1.3.6.1.4.1.34774.1.10.2.2.4";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[4] = ".1.3.6.1.4.1.34774.1.10.2.2.5";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[5] = ".1.3.6.1.4.1.34774.1.10.2.2.6";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[6] = ".1.3.6.1.4.1.34774.1.10.2.2.7";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[7] = ".1.3.6.1.4.1.34774.1.10.2.2.8";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[8] = ".1.3.6.1.4.1.34774.1.10.2.2.9";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[9] = ".1.3.6.1.4.1.34774.1.10.2.2.10";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[10] = ".1.3.6.1.4.1.34774.1.10.2.2.11";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[11] = ".1.3.6.1.4.1.34774.1.10.2.2.12";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[12] = ".1.3.6.1.4.1.34774.1.10.2.2.13";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[13] = ".1.3.6.1.4.1.34774.1.10.2.2.14";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[14] = ".1.3.6.1.4.1.34774.1.10.2.2.15";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[15] = ".1.3.6.1.4.1.34774.1.10.2.2.16";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[16] = ".1.3.6.1.4.1.34774.1.10.2.2.17";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[17] = ".1.3.6.1.4.1.34774.1.10.2.2.18";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[18] = ".1.3.6.1.4.1.34774.1.10.2.2.19";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[19] = ".1.3.6.1.4.1.34774.1.10.2.2.20";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[20] = ".1.3.6.1.4.1.34774.1.10.2.2.21";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[21] = ".1.3.6.1.4.1.34774.1.10.2.2.22";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[22] = ".1.3.6.1.4.1.34774.1.10.2.2.23";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[23] = ".1.3.6.1.4.1.34774.1.10.2.2.24";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[24] = ".1.3.6.1.4.1.34774.1.10.2.2.25";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[25] = ".1.3.6.1.4.1.34774.1.10.2.2.26";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[26] = ".1.3.6.1.4.1.34774.1.10.2.2.27";
        NorthTrapConverter.LEGO_NORTHALARM_OIDS[27] = ".1.3.6.1.4.1.34774.1.10.2.2.28";
        sLogger = LogFactory.getInstance(NorthTrapConverter.class);
    }
}

