/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.minister.northbound.alarm;

import com.huawei.lego.cbb.minister.northbound.alarm.NorthTrapConverter;
import com.huawei.lego.cbb.minister.northbound.alarm.NorthTrapMsgListener;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.sdk.model.NorthFaultMsg;
import java.util.HashSet;
import java.util.Set;

public class NorthTrapMsgCenter {
    private Log logger = LogFactory.getInstance(NorthTrapMsgCenter.class);
    private Set<NorthTrapMsgListener> listeners = new HashSet<NorthTrapMsgListener>();

    public void onMessage(NorthFaultMsg faultMsg) {
        String[] trapVariable;
        if (null != faultMsg && (trapVariable = NorthTrapConverter.convertTrapVariable(faultMsg)).length != 0) {
            this.logger.debug((Object)("recv a north fault msg in minister, entity: " + trapVariable[22]));
            for (NorthTrapMsgListener listener : this.listeners) {
                listener.notifyMsg(trapVariable);
            }
        }
    }

    public synchronized void addListener(NorthTrapMsgListener listener) {
        if (null != listener) {
            this.listeners.add(listener);
        }
    }

    public synchronized void deleteListener(NorthTrapMsgListener listener) {
        if (null != listener) {
            listener.stopListen();
            this.listeners.remove(listener);
        }
    }

    public synchronized void deleteAllListeners() {
        for (NorthTrapMsgListener listener : this.listeners) {
            listener.stopListen();
        }
        this.listeners.clear();
    }

    public void startAllListeners() {
        for (NorthTrapMsgListener listener : this.listeners) {
            if (listener.isListening()) continue;
            listener.startListen();
        }
    }

    public void stopAllListeners() {
        for (NorthTrapMsgListener listener : this.listeners) {
            if (!listener.isListening()) continue;
            listener.stopListen();
        }
    }

    public boolean hasListenerWorking() {
        for (NorthTrapMsgListener listener : this.listeners) {
            if (!listener.isListening()) continue;
            return true;
        }
        return false;
    }

    public Set<NorthTrapMsgListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(Set<NorthTrapMsgListener> listeners) {
        this.listeners = listeners;
    }
}

