/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.minister.northbound.trap.snmp;

import com.huawei.lego.cbb.minister.northbound.alarm.NorthTrapConverter;
import com.huawei.lego.cbb.minister.northbound.alarm.NorthTrapMsgListener;
import com.huawei.lego.cbb.nms.north.sdk.model.NorthNmsInfo;
import com.huawei.lego.cbb.nms.north.sdk.service.INorthNmsService;
import com.huawei.lego.cbb.nms.north.service.NorthNmsContainer;
import com.huawei.lego.cbb.nms.sdk.service.INmsSnmpV3ParamListener;
import com.huawei.lego.cbb.nms.sdk.service.SnmpV3ParamMgr;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;
import com.huawei.lego.com.south.snmp.SnmpAPI;
import com.huawei.lego.core.base.persistance.dao.ICommonDao;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class SnmpNorthTrapSender
implements Runnable,
NorthTrapMsgListener,
INmsSnmpV3ParamListener {
    private static final String ENGINID_COM_HW_IC_NMSS = "com.hw.ic.nmss";
    private static final String LOCAL_ENGINID_COM_HW_IC_TRAP = "com.hw.ic.north.trap";
    private static final int QUEUE_SIZE = 10240;
    private static String securityName = null;
    private static String oldEngineId = null;
    private static String securityNameForNms = null;
    private static SnmpAPI snmpApi = new SnmpAPI(SnmpEnum.SnmpVersion.VERSION3);
    private static SnmpAPI snmpApiForNms = new SnmpAPI(SnmpEnum.SnmpVersion.VERSION3);
    private static boolean isNmsEnable = true;
    private static Log logger = LogFactory.getInstance(SnmpNorthTrapSender.class);
    private BlockingQueue<String[]> northTrapVaribles = new LinkedBlockingQueue<String[]>(10240);
    private boolean listenStatus = false;
    private Thread thisThread = null;
    private ICommonDao commonDao;

    private static void setNmsEnable(boolean isEnable) {
        isNmsEnable = isEnable;
    }

    public ICommonDao getCommonDao() {
        return this.commonDao;
    }

    public void setCommonDao(ICommonDao commonDao) {
        this.commonDao = commonDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startListen() {
        String isEnableNMSStr = Boolean.TRUE.toString();
        if (isEnableNMSStr.equals(Boolean.FALSE.toString())) {
            SnmpNorthTrapSender.setNmsEnable(false);
            logger.info((Object)"The NMS is forbidden");
        }
        Class<SnmpNorthTrapSender> clazz = SnmpNorthTrapSender.class;
        synchronized (SnmpNorthTrapSender.class) {
            if (this.listenStatus) {
                logger.debug((Object)"Listen has started");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            SnmpV3ParamMgr.addListener((String)"KEY_TRAP_SEND_CONF", (INmsSnmpV3ParamListener)this);
            List<SnmpV3Param> v3Param = this.getV3Param();
            if (v3Param == null) {
                logger.error((Object)"Start Listener failed, get param error!");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            SnmpNorthTrapSender.initAPI(v3Param);
            if (null == this.thisThread) {
                this.thisThread = new Thread(this);
                this.thisThread.setName("snmp north trap send thread");
                this.thisThread.start();
            }
            this.listenStatus = true;
            this.northTrapVaribles.clear();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            logger.info((Object)"Start Listener succ");
            return;
        }
    }

    private List<SnmpV3Param> getV3Param() {
        String hql = "from SnmpV3Param s where s.type=1 or s.type=2";
        List<SnmpV3Param> ps = this.commonDao.findByHql(hql);
        if (ps == null || ps.isEmpty()) {
            logger.error((Object)"###\u3000SnmpNorthTrapSender start faild, cause by can't find the SNMP param.");
            return null;
        }
        logger.info((Object)"### init v3Param succ");
        return ps;
    }

    private static synchronized boolean initAPI(List<SnmpV3Param> ps) {
        for (SnmpV3Param snmpV3Param : ps) {
            if (snmpV3Param.getType() == 1) {
                SnmpNorthTrapSender.extractMethod();
                SnmpNorthTrapSender.initAPI(snmpApi, snmpV3Param);
                securityName = snmpV3Param.getSecurityName();
                if (snmpV3Param.getContextEngineId() == null || snmpV3Param.getContextEngineId().equals("")) continue;
                oldEngineId = snmpV3Param.getContextEngineId();
                continue;
            }
            if (snmpV3Param.getType() != 2 || !isNmsEnable) continue;
            if (securityNameForNms != null) {
                snmpApiForNms.removeUsmUser(securityNameForNms, ENGINID_COM_HW_IC_NMSS);
            }
            SnmpNorthTrapSender.initAPI(snmpApiForNms, snmpV3Param);
            snmpApiForNms.setEngineID(ENGINID_COM_HW_IC_NMSS.getBytes(Charset.defaultCharset()));
            securityNameForNms = snmpV3Param.getSecurityName();
        }
        return true;
    }

    private static void extractMethod() {
        if (securityName != null && oldEngineId != null) {
            snmpApi.removeUsmUser(securityName, oldEngineId);
        } else if (securityName != null) {
            snmpApi.removeUsmUser(securityName, LOCAL_ENGINID_COM_HW_IC_TRAP);
        }
    }

    private static boolean initAPI(SnmpAPI api, SnmpV3Param v3Param) {
        api.releaseResources();
        api.setAuthPassword(v3Param.getAuthPwd());
        api.setAuthProtocol(v3Param.getAuthProtocol());
        api.setSecurityName(v3Param.getSecurityName());
        api.setPrivPassword(v3Param.getPrivPwd());
        api.setPrivProtocol(v3Param.getPrivProtocol());
        api.setContextName(v3Param.getContextName());
        if (v3Param.getContextEngineId() != null && !v3Param.getContextEngineId().equals("")) {
            api.setEngineID(v3Param.getContextEngineId().getBytes(Charset.defaultCharset()));
        } else {
            api.setEngineID("".getBytes(Charset.defaultCharset()));
        }
        logger.info((Object)"###\u3000Init API succ.");
        return true;
    }

    @Override
    public void stopListen() {
        Thread tmpThread = this.thisThread;
        this.thisThread = null;
        if (null != tmpThread) {
            tmpThread.interrupt();
        }
        this.listenStatus = false;
        this.northTrapVaribles.clear();
    }

    @Override
    public boolean isListening() {
        return this.listenStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        INorthNmsService northService = (INorthNmsService)ServiceContext.getInstance().lookup("slave/northNmsService");
        Thread thread = Thread.currentThread();
        block5: while (this.thisThread == thread) {
            try {
                String[] snmpVarible = this.northTrapVaribles.take();
                List nmsNorthList = northService.getNorthNms("northIp", false);
                for (NorthNmsInfo nmsConfig : nmsNorthList) {
                    Class<SnmpNorthTrapSender> clazz = SnmpNorthTrapSender.class;
                    // MONITORENTER : com.huawei.lego.cbb.minister.northbound.trap.snmp.SnmpNorthTrapSender.class
                    this.sendTrap(snmpApi, nmsConfig.getNorthIp(), nmsConfig.getPort(), snmpVarible);
                    // MONITOREXIT : clazz
                }
                List<NorthNmsInfo> northNmsList = NorthNmsContainer.getInstance().getAllNorthNsm();
                if (null == northNmsList || northNmsList.size() <= 0) continue;
                Iterator<NorthNmsInfo> iterator = northNmsList.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block5;
                    NorthNmsInfo northNmsInfo = iterator.next();
                    if (null == northNmsInfo) continue;
                    this.sendTrap(snmpApi, northNmsInfo.getNorthIp(), northNmsInfo.getPort(), snmpVarible);
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)("interrupt Thread[snmp north trap send thread], exception: " + e.getMessage()));
                return;
            }
            catch (Exception e) {
                logger.error((Object)("throwable caught in SnmpNorthTrapThread: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    private void sendTrap(SnmpAPI api, String trapIp, int port, String[] snmpVarible) {
        boolean sendResult = false;
        for (int index = 0; index < 2 && !sendResult; ++index) {
            sendResult = this.sendAlarmTrap(api, trapIp, port, snmpVarible);
        }
    }

    private boolean sendAlarmTrap(SnmpAPI api, String trapIp, int port, String[] snmpVarible) {
        try {
            logger.debug((Object)("try to send north trap to: " + trapIp + ", entity: " + snmpVarible[22]));
            api.snmpSendV3Trap(trapIp, port, System.currentTimeMillis(), ".1.3.6.1.4.1.34774.1.10.1.1", NorthTrapConverter.getNorthSnmpOID(), snmpVarible);
            logger.info((Object)("send north trap to: " + trapIp + " successful, entity: " + snmpVarible[22] + ",alarmTime:" + snmpVarible[2] + ",clearTime:" + snmpVarible[12] + ",confirmTime:" + snmpVarible[15]));
            return true;
        }
        catch (Exception e) {
            if (e.getMessage().contains("snmp operation failed, errorCode: -1,")) {
                logger.info((Object)("send north trap to: " + trapIp + " successful, entity: " + snmpVarible[22] + ",alarmTime:" + snmpVarible[2] + ",clearTime:" + snmpVarible[12] + ",confirmTime:" + snmpVarible[15]));
                return true;
            }
            logger.error((Object)("send north trap exeption. Trap IP: " + trapIp + ", exception: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            if (null != e.getCause() && e.getCause().getMessage().contains("Error : MIB node unavailable for OID..1.3.6.1.4.1.34774.1.10.2.2.1")) {
                logger.info((Object)"repeat load mib.");
            }
            return false;
        }
    }

    @Override
    public void notifyMsg(String[] trapVariable) {
        if (this.northTrapVaribles.size() >= 10240) {
            logger.error((Object)"add a north trap variable in SnmpNorthTrapSender.");
            return;
        }
        this.northTrapVaribles.add(trapVariable);
    }

    public void onChanged() {
        logger.info((Object)"On Changed initAPI begin");
        List<SnmpV3Param> v3Param = this.getV3Param();
        if (v3Param != null) {
            SnmpNorthTrapSender.initAPI(v3Param);
            this.startListen();
            logger.info((Object)"On Changed initAPI succ");
            return;
        }
        logger.error((Object)"On Changed initAPI failed");
    }
}

