/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.nms.north.service;

import com.huawei.lego.cbb.nms.north.dao.INorthNmsDao;
import com.huawei.lego.cbb.nms.north.sdk.model.NorthNmsInfo;
import com.huawei.lego.cbb.nms.north.sdk.service.INorthNmsService;
import com.huawei.lego.cbb.nms.north.service.NorthNmsContainer;
import com.huawei.lego.cbb.nms.sdk.service.SnmpV3ParamMgr;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.ArrayList;
import java.util.List;

@Service(Name="northNmsService", Desc="", Interface=INorthNmsService.class)
public class NorthNmsServiceImpl
extends BaseService
implements INorthNmsService {
    private INorthNmsDao northNmsDao;

    public boolean addNorthNms(NorthNmsInfo northNmsInfo) {
        boolean exist = this.northNmsDao.isExist(northNmsInfo.getNorthIp(), northNmsInfo.getPort());
        if (exist) {
            throw new LegoCheckedException(1303L);
        }
        List<NorthNmsInfo> northNmsInfoList = this.northNmsDao.getNorthNms("id", true);
        if (null != northNmsInfoList && northNmsInfoList.size() >= 10) {
            throw new LegoCheckedException(1304L);
        }
        NorthNmsInfo northNms = new NorthNmsInfo();
        northNms.setNorthIp(northNmsInfo.getNorthIp());
        northNms.setPort(northNmsInfo.getPort());
        boolean result = this.northNmsDao.addNorthNms(northNms);
        NorthNmsContainer.getInstance().init();
        return result;
    }

    public BatchOperationResult deleteNorthNms(List<BatchOperation> batchOperationList) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (null != batchOperationList) {
            operCount = batchOperationList.size();
            for (BatchOperation batchOperation : batchOperationList) {
                fail = this.deleteSingleNorthNms(fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        NorthNmsContainer.getInstance().init();
        return result;
    }

    private synchronized int deleteSingleNorthNms(int fail, BatchOperation batchOperation) {
        try {
            NorthNmsInfo northNmsInfo = this.northNmsDao.getNorthNms(batchOperation.getTargetId());
            if (null == northNmsInfo) {
                throw new LegoCheckedException(1302L);
            }
            this.northNmsDao.deleteNorthNms(northNmsInfo);
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        return fail;
    }

    public List<NorthNmsInfo> getNorthNms(String orderByField, boolean orderByAscend) {
        return this.northNmsDao.getNorthNms(orderByField, orderByAscend);
    }

    public NorthNmsInfo getNorthNms(long id) {
        NorthNmsInfo northNmsInfo = this.northNmsDao.getNorthNms(id);
        if (null == northNmsInfo) {
            throw new LegoCheckedException(1302L);
        }
        return northNmsInfo;
    }

    public boolean modifyNorthNms(NorthNmsInfo northNms) {
        boolean isExist;
        NorthNmsInfo northNmsInfo = this.getNorthNms(northNms.getId());
        if (null == northNmsInfo) {
            throw new LegoCheckedException(1302L);
        }
        if ((!northNms.getNorthIp().equals(northNmsInfo.getNorthIp()) || northNms.getPort() != northNmsInfo.getPort()) && (isExist = this.northNmsDao.isExist(northNms.getNorthIp(), northNms.getPort()))) {
            throw new LegoCheckedException(1303L);
        }
        northNmsInfo.setNorthIp(northNms.getNorthIp());
        northNmsInfo.setPort(northNms.getPort());
        boolean result = this.northNmsDao.modifyNorthNms(northNmsInfo);
        NorthNmsContainer.getInstance().init();
        return result;
    }

    public INorthNmsDao getNorthNmsDao() {
        return this.northNmsDao;
    }

    public void setNorthNmsDao(INorthNmsDao northNmsDao) {
        this.northNmsDao = northNmsDao;
    }

    public SnmpV3Param getTrapConf(int type) {
        return this.northNmsDao.getTrapConf(type);
    }

    public void saveTrapConf(SnmpV3Param snmpv3) {
        this.northNmsDao.saveTrapConf(snmpv3);
        if (snmpv3.getType() == 1) {
            SnmpV3ParamMgr.notifyTrapSendConf();
        } else if (snmpv3.getType() == 2) {
            SnmpV3ParamMgr.notifyTrapReceiveConf();
        }
    }

    public String encrypt(String txt) {
        return WccEncryptor.encrypt((String)txt);
    }

    public String decrypt(String txt) {
        return WccEncryptor.decrypt((String)txt);
    }
}

