/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.messagesubscriber;

import com.huawei.lego.cbb.resource.dao.IResourceDao;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.util.DaoFactory;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.sql.Timestamp;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class MoOnLineMessageSubscriber
extends MessageTaskManager
implements InitializingBean {
    private static final Log LOGGER = LogFactory.getInstance(MoOnLineMessageSubscriber.class);
    private IMessageCenter mc = null;

    public void afterPropertiesSet() {
        this.mc.addSubscriberTo(this);
    }

    @Override
    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters(1);
        mrs[0].setMessageTopic(MessageTopic.COMMAND);
        mrs[0].addMessageCode(110L);
        return mrs;
    }

    @Override
    public void onMessage(MessageUnit mu) {
        if (110L == mu.getCmdcode()) {
            Object obj = mu.getObj();
            LOGGER.debug((Object)"MoOnLineMessage body is : ", 1L);
            if (!(obj instanceof Map)) {
                LOGGER.error((Object)"error message body in MoOnLineMessageSubscriber!!!", 1L);
                return;
            }
            Map map = (Map)obj;
            if (map.isEmpty()) {
                LOGGER.error((Object)"error message body in MoOnLineMessageSubscriber!!!", 1L);
                return;
            }
            if (map.containsKey(-1L)) {
                LOGGER.info((Object)"mo online message is received, but the message is send by myself, so i will not handle it", 1L);
                return;
            }
            Long moId = (Long)map.keySet().iterator().next();
            Integer status = (Integer)map.values().iterator().next();
            LOGGER.debug((Object)("mo online is arrived, moId is : " + moId), 1L);
            IResourceDao dao = DaoFactory.getInstance().getResourceDao();
            ManagedObject mo = dao.getMoByIdAndType(ManagedObject.class, moId, null);
            if (mo == null) {
                LOGGER.warn((Object)("in mo online, mo is nullllllllllll, moid is : " + moId), 1L);
                return;
            }
            if (this.checkMoOnline(mo)) {
                return;
            }
            mo.setStatus(status);
            this.processDiscoverTime(mo);
            dao.updateMo(mo);
        }
    }

    private void processDiscoverTime(ManagedObject mo) {
        Node node;
        if (mo instanceof Node && (node = (Node)mo).getDiscoveredTime() == null) {
            node.setDiscoveredTime(new Timestamp(System.currentTimeMillis()));
        }
    }

    private boolean checkMoOnline(ManagedObject mo) {
        return mo.getStatus() != null && mo.getStatus() == 0;
    }

    public IMessageCenter getMc() {
        return this.mc;
    }

    public void setMc(IMessageCenter mc) {
        this.mc = mc;
    }
}

