/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.resource.messagesubscriber;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.cbb.resource.util.DaoFactory;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.SnmpEnum;
import com.huawei.lego.com.south.sdk.model.SnmpPara;
import com.huawei.lego.com.south.sdk.model.SnmpV3Param;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.comm.internal.jms.MessageRegister;
import com.huawei.lego.comm.internal.jms.MessageTaskManager;
import com.huawei.lego.comm.internal.jms.MessageTopic;
import com.huawei.lego.comm.internal.jms.MessageUnit;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.sdk.service.IAlarmService;
import com.huawei.lego.nem.fault.sdk.service.ISnmpV3Service;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;

public class V3DeviceAccessMessageSubscriber
extends MessageTaskManager
implements InitializingBean {
    private static Log logger = LogFactory.getInstance(V3DeviceAccessMessageSubscriber.class);
    private static final int MAX_NUM = 255;
    private IMessageCenter mc = null;

    @Override
    public MessageRegister[] getTypes() {
        MessageRegister[] mrs = MessageRegister.getMessageRegisters(1);
        mrs[0].setMessageTopic(MessageTopic.DATA);
        mrs[0].addMessageCode(103L);
        mrs[0].addMessageCode(105L);
        mrs[0].addMessageCode(107L);
        return mrs;
    }

    public void afterPropertiesSet() {
        this.mc.addSubscriberTo(this);
    }

    @Override
    public void onMessage(MessageUnit mu) {
        switch ((int)mu.getCmdcode()) {
            case 103: {
                this.doAdd(mu);
                break;
            }
            case 105: {
                this.doDel(mu);
                break;
            }
            case 107: {
                logger.debug((Object)"message code:107");
                this.doUpdate(mu);
                break;
            }
        }
    }

    private void doUpdateV2(MessageUnit mu) {
        SnmpPara snmpParas = this.constructSnmpV2Param(mu);
        if (snmpParas == null) {
            return;
        }
        String uuids = this.getUuid(mu);
        if (uuids == null) {
            logger.error((Object)"Error add params, uuid is null", 1L);
            return;
        }
        logger.info((Object)"will insert V2 datas", 1L);
        try {
            ServiceContext contextx = ServiceContext.getInstance();
            ISnmpV3Service snmpV3Service = (ISnmpV3Service)contextx.lookup("fault/snmpV3Service");
            if (null == snmpV3Service) {
                logger.error((Object)"gets remote fault snmpv3service failue", 1L);
            } else {
                snmpV3Service.notifySnmpV2Param(snmpParas, uuids);
            }
        }
        catch (Exception e) {
            logger.error((Object)("get remote fault snmpv3service failue" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void doUpdate(MessageUnit mu) {
        SnmpV3Param snmpV3Param = this.constructSnmpV3Param(mu);
        if (snmpV3Param != null) {
            String hql = "from SnmpV3Param param where param.discoveredDeviceUuid = ?";
            HashMap<Integer, String> hqlParam = new HashMap<Integer, String>();
            hqlParam.put(0, snmpV3Param.getDiscoveredDeviceUuid());
            List<?> list = DaoFactory.getInstance().getResourceDao().findByHql(hql, hqlParam);
            if (list != null && !list.isEmpty()) {
                SnmpV3Param param = (SnmpV3Param)list.get(0);
                snmpV3Param.setSnmpV3ParamId(param.getSnmpV3ParamId());
                DaoFactory.getInstance().getResourceDao().update(snmpV3Param);
            } else {
                logger.warn((Object)("there is no related v3 data in DB, the new v3 data is : " + snmpV3Param), 1L);
            }
            try {
                ServiceContext contextz = ServiceContext.getInstance();
                ISnmpV3Service snmpV3Servicex = (ISnmpV3Service)contextz.lookup("fault/snmpV3Service");
                this.discoveryEngineIdV3(snmpV3Param, snmpV3Servicex);
                IAlarmService alarmServices = (IAlarmService)contextz.lookup("fault/alarmService");
                this.processV3Param(snmpV3Param, alarmServices);
            }
            catch (Exception e) {
                logger.error((Object)("get remote fault snmpv3service failue" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        } else {
            this.doUpdateV2(mu);
        }
    }

    private void discoveryEngineIdV3(SnmpV3Param snmpV3Param, ISnmpV3Service snmpV3Service) {
        if (null == snmpV3Service) {
            logger.error((Object)"gets remote fault snmpv3service failue", 1L);
        } else if (this.checkV3ParamEmpty(snmpV3Param)) {
            String engineId = snmpV3Service.discoveryEngineId(snmpV3Param);
            snmpV3Param.setEngineId(engineId);
        }
    }

    private boolean checkV3ParamEmpty(SnmpV3Param snmpV3Param) {
        return null == snmpV3Param.getEngineId() || "".equals(snmpV3Param.getEngineId());
    }

    private void processV3Param(SnmpV3Param snmpV3Param, IAlarmService alarmServices) {
        if (null == alarmServices) {
            logger.error((Object)"gets remote fault alarmService failue", 1L);
        } else {
            alarmServices.removeSnmpV3Param(snmpV3Param);
            alarmServices.updateSnmpV3Param(snmpV3Param);
        }
    }

    private void doDel(MessageUnit mu) {
        SnmpV3Param snmpV3Param = this.constructSnmpV3Param(mu);
        if (snmpV3Param != null) {
            this.doDel1(snmpV3Param);
        } else {
            logger.debug((Object)"doDel:snmpV3Param is null");
            this.doDel2(mu);
        }
    }

    private void doDel1(SnmpV3Param snmpV3Param) {
        String hql = "delete from SnmpV3Param param where param.discoveredDeviceUuid = ?";
        Object[] param = new Object[]{snmpV3Param.getDiscoveredDeviceUuid()};
        logger.info((Object)"will delete V3 data, v3 data is : ", 1L);
        DaoFactory.getInstance().getResourceDao().updateByHql(hql, param);
        try {
            ServiceContext context = ServiceContext.getInstance();
            IAlarmService alarmService = (IAlarmService)context.lookup("fault/alarmService");
            if (null == alarmService) {
                logger.error((Object)"get remote fault alarmService failue", 1L);
            } else {
                alarmService.removeSnmpV3Param(snmpV3Param);
            }
        }
        catch (Exception e) {
            logger.error((Object)("get remote fault snmpv3service failue" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void doDel2(MessageUnit mu) {
        SnmpPara snmpPara = this.constructSnmpV2Param(mu);
        if (snmpPara == null) {
            return;
        }
        String uuid = this.getUuid(mu);
        if (uuid == null) {
            logger.error((Object)"Error add param, uuid is null", 1L);
            return;
        }
        logger.info((Object)"will insert V2 data", 1L);
        try {
            ServiceContext context = ServiceContext.getInstance();
            ISnmpV3Service snmpV3Service = (ISnmpV3Service)context.lookup("fault/snmpV3Service");
            if (null == snmpV3Service) {
                logger.error((Object)"get remote fault snmpv3service failue", 1L);
            } else {
                snmpV3Service.removeSnmpV2Param(uuid);
            }
        }
        catch (Exception e) {
            logger.error((Object)("get remote fault snmpv3service failue" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void doAddV2(MessageUnit mu) {
        SnmpPara snmpParax = this.constructSnmpV2Param(mu);
        if (snmpParax == null) {
            return;
        }
        String uuids = this.getUuid(mu);
        if (uuids == null) {
            logger.error((Object)"Error add param, uuid is null", 1L);
            return;
        }
        logger.info((Object)"will insert V2 data", 1L);
        try {
            ServiceContext context = ServiceContext.getInstance();
            ISnmpV3Service snmpV3Service = (ISnmpV3Service)context.lookup("fault/snmpV3Service");
            if (null == snmpV3Service) {
                logger.error((Object)"get remote fault snmpv3service failue", 1L);
            } else {
                snmpV3Service.notifySnmpV2Param(snmpParax, uuids);
            }
        }
        catch (Exception e) {
            logger.error((Object)("get remote fault snmpv3service failue" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void doAdd(MessageUnit mu) {
        block5: {
            SnmpV3Param snmpV3Param = this.constructSnmpV3Param(mu);
            if (snmpV3Param != null) {
                logger.info((Object)("will insert V3 data, v3 data is:" + snmpV3Param.getSecurityName()), 1L);
                DaoFactory.getInstance().getResourceDao().save(snmpV3Param);
                try {
                    ServiceContext context = ServiceContext.getInstance();
                    ISnmpV3Service snmpV3Service = (ISnmpV3Service)context.lookup("fault/snmpV3Service");
                    this.discoveryEngineId(snmpV3Param, snmpV3Service);
                    IAlarmService alarmService = (IAlarmService)context.lookup("fault/alarmService");
                    if (null == alarmService) {
                        logger.error((Object)"get remote fault alarmService failue", 1L);
                        break block5;
                    }
                    alarmService.updateSnmpV3Param(snmpV3Param);
                }
                catch (Exception e) {
                    logger.error((Object)("get remote fault snmpv3service failue" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                }
            } else {
                this.doAddV2(mu);
            }
        }
    }

    private void discoveryEngineId(SnmpV3Param snmpV3Param, ISnmpV3Service snmpV3Service) {
        if (null == snmpV3Service) {
            logger.error((Object)"get remote fault snmpv3service failue", 1L);
        } else if (null == snmpV3Param.getEngineId() || "".equals(snmpV3Param.getEngineId())) {
            String engineId = snmpV3Service.discoveryEngineId(snmpV3Param);
            snmpV3Param.setEngineId(engineId);
        }
    }

    private String getUuid(MessageUnit mu) {
        Map msgObj = (Map)mu.getObj();
        Collection moList = msgObj.values();
        if (moList != null && !moList.isEmpty()) {
            ManagedObject mo = (ManagedObject)moList.iterator().next();
            return mo.getUuid();
        }
        logger.debug((Object)"getUuid:uuid is null");
        return null;
    }

    private SnmpV3Param constructSnmpV3Param(MessageUnit mu) {
        ManagedObject mo;
        Map msgObj = (Map)mu.getObj();
        Collection moList = msgObj.values();
        if (moList != null && !moList.isEmpty() && (mo = (ManagedObject)moList.iterator().next()) instanceof Node) {
            Protocol snmpPara = ((Node)mo).getManagementProtocol(SnmpPara.class.getName());
            return this.constructSnmpV3Param(snmpPara, mo);
        }
        logger.debug((Object)"constructSnmpV3Param(MessageUnit):SnmpV3Param is null");
        return null;
    }

    private SnmpV3Param constructSnmpV3Param(Protocol snmpPara, ManagedObject mo) {
        SnmpPara mySnmpPara;
        if (snmpPara != null && (mySnmpPara = (SnmpPara)snmpPara).getVersion() == 3) {
            SnmpV3Param snmpV3Param = new SnmpV3Param();
            snmpV3Param.setAuthProtocol(SnmpEnum.AuthProtocol.getAuthProtocol((int)mySnmpPara.getAuthProtocolNum()));
            snmpV3Param.setAuthPwd(mySnmpPara.getAuthPwd());
            snmpV3Param.setContextName(mySnmpPara.getContextName());
            snmpV3Param.setDiscoveredDeviceUuid(mo.getUuid());
            snmpV3Param.setEngineId(mySnmpPara.getContextEngineId());
            snmpV3Param.setPrivProtocol(SnmpEnum.PrivProtocol.getPrivProtocol((int)mySnmpPara.getEncryptProtocolNum()));
            snmpV3Param.setPrivPwd(mySnmpPara.getEncryptPwd());
            snmpV3Param.setIpAddress(mySnmpPara.getNode().getIpAddress());
            snmpV3Param.setPort(mySnmpPara.getPort());
            snmpV3Param.setUserName(mySnmpPara.getSecurityName());
            this.extractMethod(snmpV3Param, mo);
            return snmpV3Param;
        }
        logger.debug((Object)"constructSnmpV3Param(Protocol,ManagedObject):SnmpV3Param is null");
        return null;
    }

    private void extractMethod(SnmpV3Param snmpV3Param, ManagedObject mo) {
        try {
            if (null != mo.getType() && "com.huawei.ism.drm.galax.sdk.model.VRG".equals(mo.getType())) {
                byte[] authoritativeengineID = this.convert(mo.getUuid().replaceAll("-", ""));
                snmpV3Param.setEngineId(new String(authoritativeengineID, "ISO-8859-1"));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"covert authoritativeengineID failue", (Throwable)e, 1L);
        }
    }

    private byte[] convert(String oldEnginedId) {
        char[] arr = oldEnginedId.toCharArray();
        byte[] authoritativeengineID = new byte[oldEnginedId.length() / 2];
        int i = 0;
        int j = 0;
        int l = oldEnginedId.length();
        while (i < l) {
            String swap = "" + arr[i++] + arr[i];
            try {
                int byteint = Integer.parseInt(swap, 16) & 0xFF;
                authoritativeengineID[j] = Integer.valueOf(byteint).byteValue();
            }
            catch (NumberFormatException e) {
                logger.error((Object)"toByteArray Exception", (Throwable)e, 1L);
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
            ++i;
            ++j;
        }
        return authoritativeengineID;
    }

    private SnmpPara constructSnmpV2Param(MessageUnit mu) {
        ManagedObject mo;
        Map msgObj = (Map)mu.getObj();
        Collection moList = msgObj.values();
        if (moList != null && !moList.isEmpty() && (mo = (ManagedObject)moList.iterator().next()) instanceof Node) {
            return this.constructSnmpV2Param(mo);
        }
        logger.debug((Object)"constructSnmpV2Param(MessageUnit):Snmpara is null");
        return null;
    }

    private SnmpPara constructSnmpV2Param(ManagedObject mo) {
        SnmpPara mySnmpPara;
        Protocol snmpPara = ((Node)mo).getManagementProtocol(SnmpPara.class.getName());
        if (snmpPara != null && (mySnmpPara = (SnmpPara)snmpPara).getVersion() == 1) {
            return mySnmpPara;
        }
        logger.debug((Object)"constructSnmpV2Param(ManagedObject):Snmpara is null");
        return null;
    }

    public IMessageCenter getMc() {
        return this.mc;
    }

    public void setMc(IMessageCenter mc) {
        this.mc = mc;
    }
}

