/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.manager;

import com.huawei.lego.cbb.task.dao.ITaskDAO;
import com.huawei.lego.cbb.task.dao.ITaskResultDAO;
import com.huawei.lego.cbb.task.manager.ITaskManager;
import com.huawei.lego.cbb.task.manager.service.ISchedulerService;
import com.huawei.lego.cbb.task.sdk.TaskTimeUtil;
import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskType;
import com.huawei.lego.cbb.task.sdk.service.TaskExecuteType;
import com.huawei.lego.cbb.task.sdk.service.TaskPeriodType;
import com.huawei.lego.cbb.task.sdk.service.TaskStatus;
import com.huawei.lego.core.sdk.base.event.StatusChangedEvent;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.impl.JobDetailImpl;
import org.springframework.beans.factory.DisposableBean;

public class TaskManager
implements ITaskManager,
SystemStatusChangedListener,
DisposableBean {
    private ISchedulerService scheduler;
    private ITaskDAO taskDao;
    private ITaskResultDAO taskResultDao;
    private Log log = LogFactory.getInstance(TaskManager.class);
    private Map<String, Class> jobBeanMap = new HashMap<String, Class>();
    private Map<Long, Long> taskExcuteTime = new Hashtable<Long, Long>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void start(Task task) {
        Date now;
        TaskType type = task.getTaskType();
        if (null == type) return;
        Class cl = this.getTaskTypeClass(type);
        if (null == cl) {
            return;
        }
        JobDetailImpl jobDetail = new JobDetailImpl(type.getTaskTypeName(), "DEFAULT", cl);
        jobDetail.setDurability(true);
        JobDataMap data = this.getJobData(task);
        String name = this.getTaskName(task);
        if (TaskExecuteType.single.getValue() == task.getExecuteType().intValue()) {
            Date currentTime;
            Date baseTime = task.getBaseTime();
            if (baseTime.after(currentTime = new Date())) {
                this.scheduler.schedule((JobDetail)jobDetail, name, task.getBaseTime(), data);
                return;
            }
            task.setTaskStatus(Integer.valueOf(TaskStatus.finish.getValue()));
            task.setNextTime(null);
            this.taskDao.updateTask(task);
            this.log.error((Object)(name + " should be finish! "), 1L);
            return;
        }
        Date endDate = this.extractComplexity(task);
        if (this.isCompStatus(endDate, now = new Date())) {
            task.setTaskStatus(Integer.valueOf(TaskStatus.finish.getValue()));
            task.setNextTime(null);
            this.taskDao.updateTask(task);
            this.log.error((Object)(name + " should be finish! "), 1L);
            return;
        }
        Date nextTime = task.getNextTime();
        Date excuteTime = this.changeExeTime(task, now, nextTime);
        this.calculateExcuteTime(task, excuteTime);
        Calendar runTime = Calendar.getInstance();
        runTime.setTime(excuteTime);
        StringBuilder cronExpression = this.getCronExpression(runTime, task);
        this.log.info((Object)("task type:" + task.getTaskName() + ",baseTime=" + excuteTime + ",time:" + excuteTime.getTime() + ",taskId:" + task.getTaskId()), 1L);
        this.scheduler.schedule((JobDetail)jobDetail, this.getTaskName(task), excuteTime, endDate, cronExpression.toString(), data);
    }

    private Date changeExeTime(Task task, Date now, Date nextTime) {
        if (null == nextTime) {
            this.log.debug((Object)("now:" + now + ",nextTime:null"));
            nextTime = task.getBaseTime();
        } else {
            this.log.debug((Object)("now:" + now + ",nextTime:" + nextTime));
        }
        Date excuteTime = new Date(nextTime.getTime());
        if (excuteTime.before(new Date(now.getTime() + 5000L))) {
            excuteTime.setTime(now.getTime() + 30000L);
        }
        return excuteTime;
    }

    private Class getTaskTypeClass(TaskType type) {
        Class<?> cl = null;
        try {
            ClassLoader clzzLoader;
            cl = this.jobBeanMap.get(type.getTaskTypeClassName());
            if (null == cl && null != (clzzLoader = this.getClass().getClassLoader())) {
                cl = clzzLoader.loadClass(type.getTaskTypeClassName());
            }
        }
        catch (Exception e) {
            this.log.error((Object)(type.getTaskTypeClassName() + " Not Found! " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return cl;
    }

    private boolean isCompStatus(Date endDate, Date now) {
        return null != endDate && endDate.before(now);
    }

    private Date extractComplexity(Task task) {
        Date endDate = null;
        endDate = null != task.getEndTime() ? task.getEndTime() : TaskTimeUtil.getEndDateWithCount((Task)task);
        this.log.debug((Object)("endDate:" + endDate));
        return endDate;
    }

    private void calculateExcuteTime(Task task, Date excuteTime) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timeTemp = sdf.format(excuteTime);
        try {
            excuteTime.setTime(sdf.parse(timeTemp).getTime());
        }
        catch (ParseException e) {
            this.log.error((Object)("parse date exception,baseTime:" + timeTemp), (Throwable)e, 1L);
        }
        while (this.isExist(excuteTime.getTime())) {
            excuteTime.setTime(excuteTime.getTime() + 5000L);
        }
        this.taskExcuteTime.put(task.getTaskId(), excuteTime.getTime());
    }

    private boolean isExist(long time) {
        Set<Map.Entry<Long, Long>> entrySet = this.taskExcuteTime.entrySet();
        for (Map.Entry<Long, Long> entry : entrySet) {
            if (entry.getValue() != time) continue;
            return true;
        }
        this.log.debug((Object)("time:" + time));
        return false;
    }

    private StringBuilder getCronExpression(Calendar runTime, Task task) {
        StringBuilder cronExpression = new StringBuilder();
        cronExpression.append(runTime.get(13));
        cronExpression.append(" ");
        cronExpression.append(runTime.get(12));
        cronExpression.append(" ");
        if (TaskPeriodType.hour.getValue() == task.getPeriodType().intValue()) {
            cronExpression.append(" ");
            cronExpression.append("* * * ?");
        } else if (TaskPeriodType.date.getValue() == task.getPeriodType().intValue()) {
            cronExpression.append(runTime.get(11));
            cronExpression.append(" ");
            cronExpression.append("* * ?");
        } else if (TaskPeriodType.week.getValue() == task.getPeriodType().intValue()) {
            cronExpression.append(runTime.get(11));
            cronExpression.append(" ");
            cronExpression.append("? * ");
            cronExpression.append(runTime.get(7));
        } else if (TaskPeriodType.month.getValue() == task.getPeriodType().intValue()) {
            cronExpression.append(runTime.get(11));
            cronExpression.append(" ");
            cronExpression.append(runTime.get(5));
            cronExpression.append(" * ?");
        } else if (TaskPeriodType.year.getValue() == task.getPeriodType().intValue()) {
            cronExpression.append(runTime.get(11));
            cronExpression.append(" ");
            cronExpression.append(runTime.get(5));
            cronExpression.append(" ");
            cronExpression.append(runTime.get(2) + 1);
            cronExpression.append(" ");
            cronExpression.append("?");
        }
        this.log.debug((Object)("cronExpression:" + cronExpression));
        return cronExpression;
    }

    @Override
    public void stop(Task task) {
        this.log.debug((Object)"stop task.");
        this.scheduler.stop(this.getTaskName(task));
    }

    @Override
    public void pause(Task task) {
        this.log.debug((Object)"pause task.");
        this.scheduler.pause(this.getTaskName(task));
    }

    @Override
    public void resume(Task task) {
        this.log.debug((Object)"resume task.");
        this.scheduler.resume(this.getTaskName(task));
    }

    @Override
    public void runAtOnce(Task task) {
        this.log.debug((Object)"runAtOnce task.");
        this.scheduler.runAtOnce(this.getTaskName(task), this.getJobData(task), task.getTaskType().getTaskTypeName());
    }

    private String getTaskName(Task task) {
        String name = null;
        if (null != task && null != task.getTaskType()) {
            name = task.getTaskType().getTaskType() + "-" + task.getTaskId();
        }
        return name;
    }

    private JobDataMap getJobData(Task task) {
        JobDataMap data = new JobDataMap();
        data.put("task", (Object)task);
        data.put("taskdao", (Object)this.taskDao);
        data.put("taskresultdao", (Object)this.taskResultDao);
        return data;
    }

    public void afterPropertiesSet() {
        List<Task> tasks;
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("taskStatus", TaskStatus.idle.getValue());
        params.put("bundleName", "lego");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("taskStatus", TaskStatus.running.getValue());
        List<Task> taskRunings = this.taskDao.queryTask(param);
        if (null != taskRunings && !taskRunings.isEmpty()) {
            for (Task task : taskRunings) {
                task.setTaskStatus(Integer.valueOf(TaskStatus.idle.getValue()));
                this.taskDao.updateTask(task);
            }
        }
        if (null != (tasks = this.taskDao.queryTask(params)) && !tasks.isEmpty()) {
            for (Task task : tasks) {
                try {
                    this.start(task);
                }
                catch (Exception e) {
                    this.log.error((Object)(task.getTaskName() + " start error   " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                }
            }
        }
    }

    public void destroy() {
        this.scheduler.shutdown();
    }

    public void setTaskDao(ITaskDAO taskDao) {
        this.taskDao = taskDao;
    }

    public void setTaskResultDao(ITaskResultDAO taskResultDao) {
        this.taskResultDao = taskResultDao;
    }

    public void setScheduler(ISchedulerService scheduler) {
        this.scheduler = scheduler;
    }

    public void onStatusChangedEvent(StatusChangedEvent event) {
        if (event.getStatus() == Status.STATUS_STARTED) {
            this.afterPropertiesSet();
        }
    }
}

