/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.manager.service;

import com.huawei.lego.cbb.task.manager.service.CustomCronTrigger;
import com.huawei.lego.cbb.task.manager.service.ISchedulerService;
import com.huawei.lego.cbb.task.manager.service.SchedulerInfo;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;
import org.quartz.CronExpression;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.SimpleTriggerImpl;

public class SchedulerServiceImpl
implements ISchedulerService {
    private Log log = LogFactory.getInstance(SchedulerServiceImpl.class);
    private Scheduler scheduler;

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public String schedule(JobDetail jobDetail, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, null, null, null, cronExpression, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, String name, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, name, null, null, cronExpression, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, Date startTime, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, null, startTime, null, cronExpression, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, Date startTime, Date endTime, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, null, startTime, endTime, cronExpression, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, String name, Date startTime, String cronExpression, JobDataMap map) {
        return this.schedule(jobDetail, name, startTime, null, cronExpression, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, String name, Date startTime, Date endTime, String cronExpression, JobDataMap map) {
        if (name == null || name.trim().equals("")) {
            name = UUID.randomUUID().toString();
        }
        try {
            this.scheduler.addJob(jobDetail, true);
            CustomCronTrigger cronTrigger = new CustomCronTrigger(name, "DEFAULT", jobDetail.getKey().getName(), "DEFAULT");
            cronTrigger.setJobDataMap(map);
            cronTrigger.setCronExpression(new CronExpression(cronExpression));
            if (null != startTime) {
                cronTrigger.setStartTime(startTime);
            }
            if (null != endTime) {
                cronTrigger.setEndTime(endTime);
            }
            cronTrigger.setMisfireInstruction(2);
            this.scheduler.scheduleJob((Trigger)cronTrigger);
        }
        catch (SchedulerException e) {
            StringBuffer buff = new StringBuffer();
            buff.append("Task scheduler error! cronExpression = ");
            buff.append(cronExpression);
            buff.append(" starttime = ");
            buff.append(startTime);
            buff.append(" endtime = ");
            buff.append(endTime);
            this.log.error((Object)buff.toString(), (Throwable)e, 0L);
        }
        catch (ParseException e) {
            this.log.error((Object)"CronExpression parse error! ", (Throwable)e, 0L);
        }
        return name;
    }

    @Override
    public String schedule(JobDetail jobDetail, Date startTime, JobDataMap map) {
        return this.schedule(jobDetail, startTime, null, 0, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, String name, Date startTime, JobDataMap map) {
        return this.schedule(jobDetail, name, startTime, null, 0, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, Date startTime, Date endTime, JobDataMap map) {
        return this.schedule(jobDetail, startTime, endTime, 0, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, String name, Date startTime, Date endTime, JobDataMap map) {
        return this.schedule(jobDetail, name, startTime, endTime, 0, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, Date startTime, Date endTime, int repeatCount, JobDataMap map) {
        return this.schedule(jobDetail, null, startTime, endTime, 0, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, String name, Date startTime, Date endTime, int repeatCount, JobDataMap map) {
        SchedulerInfo schedulerInfo = new SchedulerInfo();
        schedulerInfo.setName(null);
        schedulerInfo.setStartTime(startTime);
        schedulerInfo.setEndTime(endTime);
        schedulerInfo.setRepeatCount(0);
        schedulerInfo.setRepeatInterval(0L);
        return this.schedule(jobDetail, schedulerInfo, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, Date startTime, Date endTime, int repeatCount, long repeatInterval, JobDataMap map) {
        SchedulerInfo schedulerInfo = new SchedulerInfo();
        schedulerInfo.setName(null);
        schedulerInfo.setStartTime(startTime);
        schedulerInfo.setEndTime(endTime);
        schedulerInfo.setRepeatCount(repeatCount);
        schedulerInfo.setRepeatInterval(repeatInterval);
        return this.schedule(jobDetail, schedulerInfo, map);
    }

    @Override
    public String schedule(JobDetail jobDetail, SchedulerInfo schedulerInfo, JobDataMap map) {
        String name = schedulerInfo.getName();
        Date startTime = schedulerInfo.getStartTime();
        Date endTime = schedulerInfo.getEndTime();
        int repeatCount = schedulerInfo.getRepeatCount();
        long repeatInterval = schedulerInfo.getRepeatInterval();
        if (name == null || name.trim().equals("")) {
            name = UUID.randomUUID().toString();
        }
        try {
            this.scheduler.addJob(jobDetail, true);
            SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(name, "DEFAULT", jobDetail.getKey().getName(), "DEFAULT", startTime, endTime, repeatCount, repeatInterval);
            simpleTrigger.setJobDataMap(map);
            simpleTrigger.setMisfireInstruction(4);
            TriggerKey triggerKey = new TriggerKey(name, "DEFAULT");
            this.scheduler.scheduleJob((Trigger)simpleTrigger);
            this.scheduler.rescheduleJob(triggerKey, (Trigger)simpleTrigger);
        }
        catch (SchedulerException e) {
            this.log.error((Object)("Task scheduler error! repeatCount = " + repeatCount + " repeatInterval = " + repeatInterval), (Throwable)e, 0L);
        }
        return name;
    }

    @Override
    public void runAtOnce(String name, JobDataMap map) {
        try {
            Trigger trigger = this.scheduler.getTrigger(new TriggerKey(name, "DEFAULT"));
            if (null == trigger) {
                return;
            }
            JobKey jobKey = trigger.getJobKey();
            if (null == jobKey) {
                return;
            }
            JobDetail jobDetail = this.scheduler.getJobDetail(new JobKey(jobKey.getName(), "DEFAULT"));
            if (null == jobDetail) {
                return;
            }
            String newName = UUID.randomUUID().toString();
            SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(newName, "DEFAULT", jobDetail.getKey().getName(), "DEFAULT", new Date(), null, 0, 0L);
            simpleTrigger.setJobDataMap(map);
            simpleTrigger.setMisfireInstruction(4);
            this.scheduler.scheduleJob((Trigger)simpleTrigger);
            this.scheduler.rescheduleJob(new TriggerKey(newName, "DEFAULT"), (Trigger)simpleTrigger);
        }
        catch (SchedulerException e) {
            this.log.error((Object)"Task scheduler run at once error! ", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void runAtOnce(String name, JobDataMap map, String taskType) {
        try {
            String newName = UUID.randomUUID().toString();
            TriggerKey triggerKey = new TriggerKey(newName, "DEFAULT");
            SimpleTriggerImpl simpleTrigger = new SimpleTriggerImpl(newName, "DEFAULT", taskType, "DEFAULT", new Date(), null, 0, 0L);
            simpleTrigger.setJobDataMap(map);
            simpleTrigger.setMisfireInstruction(4);
            this.scheduler.scheduleJob((Trigger)simpleTrigger);
            this.scheduler.rescheduleJob(triggerKey, (Trigger)simpleTrigger);
        }
        catch (SchedulerException e) {
            this.log.error((Object)"[*******]Task scheduler run at once error! ", (Throwable)e, 603L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public boolean stop(String name) {
        try {
            TriggerKey triggerKey = new TriggerKey(name, "DEFAULT");
            this.scheduler.pauseTrigger(triggerKey);
            return this.scheduler.unscheduleJob(triggerKey);
        }
        catch (SchedulerException e) {
            this.log.error((Object)"Task scheduler stop error! ", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void pause(String name) {
        try {
            this.scheduler.pauseTrigger(new TriggerKey(name, "DEFAULT"));
        }
        catch (SchedulerException e) {
            this.log.error((Object)"Task scheduler pause error! ", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void resume(String name) {
        try {
            this.scheduler.resumeTrigger(new TriggerKey(name, "DEFAULT"));
        }
        catch (SchedulerException e) {
            this.log.error((Object)"Task scheduler resume error! ", (Throwable)e, 0L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void shutdown() {
        if (null != this.scheduler) {
            try {
                this.scheduler.shutdown(false);
            }
            catch (SchedulerException e) {
                this.log.error((Object)"Task scheduler shutdown error! ", (Throwable)e, 0L);
                throw LegoExceptionTranslator.convert((Throwable)e);
            }
        }
    }
}

