/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.task.sysjob;

import com.huawei.lego.cbb.task.sdk.model.Task;
import com.huawei.lego.cbb.task.sdk.model.TaskParameter;
import com.huawei.lego.cbb.task.sdk.service.ITaskService;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.system.syslog.sdk.service.ISysOptLog;
import com.huawei.lego.nem.fault.sdk.service.IFaultBackupService;
import java.io.File;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageFactory {
    private static final int SLEEPCOUNT = 100;
    private static final long SLEEPTIME = 1000L;
    private ISysOptLog sysOpLog = null;
    private IFaultBackupService faultBackupService = null;
    private ITaskService taskService = null;
    private TaskParameter taskParameter = null;
    private Log log = LogFactory.getInstance(StorageFactory.class);
    private String cvsstyleValue = "1";
    private String langValue = "1";
    private String sysOptType = "log_bk";
    private String alarmType = "alarm_bk";
    private String currentAlarmType = "current_alarm_bk";
    private String fileStyle = "";
    private String lang = "";
    private String reserDate;
    private String filePath;
    private Map<String, Object> condition;

    public String dateStorage(String dateType) {
        String resultLink = "";
        Task task = null;
        this.log.info((Object)("System dateStorage begin dateType is " + dateType), 1L);
        try {
            this.getTaskService();
            if (null != this.taskService) {
                this.log.info((Object)"taskService is  not null", 1L);
                this.getCondition(dateType);
                if (dateType.equals(this.currentAlarmType)) {
                    this.fileStyle = this.cvsstyleValue;
                    this.reserDate = "0";
                    this.lang = this.langValue;
                    resultLink = this.dateStorageByType(dateType);
                    return resultLink;
                }
                List taskList = this.taskService.queryTasks(this.condition);
                if (null == taskList || taskList.isEmpty()) {
                    return "";
                }
                task = (Task)taskList.get(0);
                this.taskParameter = task.getParameter();
                if (null != this.taskParameter) {
                    this.fileStyle = this.taskParameter.getParameter1();
                    this.reserDate = this.taskParameter.getParameter2();
                    this.lang = this.taskParameter.getParameter3();
                    resultLink = this.dateStorageByType(dateType);
                }
            } else {
                this.log.info((Object)"taskService is null", 1L);
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Exception" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return resultLink;
    }

    private void getCondition(String dateType) {
        if (dateType.equals(this.sysOptType)) {
            this.filePath = "datastorage" + File.separator + "sysoptlog";
            this.condition = new HashMap<String, Object>();
            this.condition.put("taskType", this.sysOptType);
            this.sysOpLog = this.getISysOptLogService();
        } else if (dateType.equals(this.alarmType)) {
            this.condition = new HashMap<String, Object>();
            this.condition.put("taskType", this.alarmType);
            this.faultBackupService = this.getFaultBackupService();
            this.filePath = "datastorage" + File.separator + "alarm";
        } else if (dateType.equals(this.currentAlarmType)) {
            this.condition = new HashMap<String, Object>();
            this.condition.put("taskType", this.currentAlarmType);
            this.faultBackupService = this.getFaultBackupService();
            this.filePath = "datastorage" + File.separator + "currentAlarm";
        }
    }

    private void getTaskService() throws InterruptedException {
        for (int i = 0; null == this.taskService && i < 100; ++i) {
            try {
                this.taskService = (ITaskService)ServiceContext.getInstance().lookup("task/task");
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("taskService is null" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                continue;
            }
            finally {
                CommonUtil.sleep((long)1000L);
            }
        }
    }

    private IFaultBackupService getFaultBackupService() {
        for (int i = 0; null == this.faultBackupService && i < 100; ++i) {
            try {
                this.faultBackupService = (IFaultBackupService)ServiceContext.getInstance().lookup("fault/faultBackupService");
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("taskService is null" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                continue;
            }
            finally {
                CommonUtil.sleep((long)1000L);
            }
        }
        return this.faultBackupService;
    }

    private ISysOptLog getISysOptLogService() {
        for (int i = 0; null == this.sysOpLog && i < 100; ++i) {
            try {
                this.sysOpLog = (ISysOptLog)ServiceContext.getInstance().lookup("system/sysLogService");
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)("taskService is null" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                continue;
            }
            finally {
                CommonUtil.sleep((long)1000L);
            }
        }
        return this.sysOpLog;
    }

    private String dateStorageByType(String dateType) {
        String resultLink = "";
        String fileTypes = this.getFileType(this.fileStyle);
        if (dateType.equals(this.sysOptType)) {
            if (null != this.sysOpLog) {
                resultLink = this.sysOpLog.transferLog(fileTypes, this.getEndTime(this.reserDate), this.getLang(this.lang), this.filePath);
            } else {
                this.log.info((Object)"System dateStorage ISysOptLog is null", 1L);
            }
        } else if (dateType.equals(this.alarmType) || dateType.equals(this.currentAlarmType)) {
            if (null != this.faultBackupService) {
                resultLink = this.faultBackupService.transferAlarm(fileTypes, this.getEndTime(this.reserDate), this.getLang(this.lang), this.filePath);
            } else {
                this.log.info((Object)"System dateStorage IFaultBackupService is null", 1L);
            }
        }
        return resultLink;
    }

    private long getEndTime(String resDate) {
        long endTime = -1L;
        if (null != resDate && !resDate.equals("")) {
            int reserDate1 = NumberUtil.convertToInteger((Object)resDate);
            Calendar cal = Calendar.getInstance();
            cal.add(5, -reserDate1);
            endTime = cal.getTime().getTime();
        }
        return endTime;
    }

    private String getFileType(String fileType) {
        String file = "";
        file = fileType.equals("1") ? "csv" : "excel";
        return file;
    }

    public String getAlarmType() {
        return this.alarmType;
    }

    public void setAlarmType(String alarmType) {
        this.alarmType = alarmType;
    }

    private String getLang(String language) {
        String langUa = "";
        langUa = language.equals("1") ? "en" : "zh";
        return langUa;
    }
}

