/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cbb.user.hibernate;

import com.huawei.lego.cbb.user.dao.IRoleDao;
import com.huawei.lego.cbb.user.sdk.hibernate.model.RoleInfo;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.dao.DataAccessException;

public class RoleDaoImpl
extends HibernateDaoSupportWrapper
implements IRoleDao {
    private transient Log log = LogFactory.getInstance(RoleDaoImpl.class);

    @Override
    public synchronized long addRoleInfo(RoleInfo roleinfo) {
        String hql = "select count(r.roleIdx) from RoleInfo r";
        List conutList = this.getHibernateTemplate().find(hql, new Object[0]);
        if ((Long)conutList.get(0) >= 512L) {
            this.logger.error((Object)"role quantity is more than 512");
            throw new SpecCheckedException("role_quantity", 512L, ((Long)conutList.get(0)).longValue());
        }
        try {
            return (Long)this.getHibernateTemplate().save((Object)roleinfo);
        }
        catch (DataAccessException e) {
            this.log.error((Object)e.getMessage(), 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public synchronized void deleteRole(long roleId) {
        try {
            RoleInfo roleInfo = this.getRoleInfRelUser(roleId, Boolean.TRUE);
            if (null != roleInfo) {
                if (null != roleInfo.getUserSet() && !roleInfo.getUserSet().isEmpty()) {
                    throw new LegoCheckedException(296L);
                }
            } else {
                String[] pama = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(206L, pama);
            }
            this.getHibernateTemplate().delete((Object)roleInfo);
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public synchronized RoleInfo getRoleById(long iRoleId, boolean isFetchOper) {
        try {
            RoleInfo oRole = null;
            if (isFetchOper) {
                String hql = "FROM RoleInfo u left join fetch u.operationSet where u.roleIdx = '" + iRoleId + "'";
                List allUserList = this.getHibernateTemplate().find(hql, new Object[0]);
                if (null != allUserList && !allUserList.isEmpty()) {
                    oRole = (RoleInfo)allUserList.get(0);
                }
            } else {
                oRole = (RoleInfo)this.getHibernateTemplate().get(RoleInfo.class, (Serializable)Long.valueOf(iRoleId));
            }
            if (null == oRole) {
                String[] pama = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(206L, pama);
            }
            return oRole;
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public synchronized RoleInfo getRoleByName(String roleName, boolean isFetchOper) {
        try {
            RoleInfo oRole = null;
            if (isFetchOper) {
                String hql = "FROM RoleInfo u left join fetch u.operationSet where u.roleName = ?";
                List allUserList = this.getHibernateTemplate().find(hql, new Object[]{roleName});
                if (null != allUserList && !allUserList.isEmpty()) {
                    oRole = (RoleInfo)allUserList.get(0);
                }
            } else {
                Set set;
                oRole = (RoleInfo)this.getHibernateTemplate().find("FROM RoleInfo u where u.roleName = ?", new Object[]{roleName});
                if (null != oRole && !VerifyUtil.isEmpty((Collection)(set = oRole.getOperationSet()))) {
                    set.clear();
                }
            }
            if (null == oRole) {
                String[] pama = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(206L, pama);
            }
            return oRole;
        }
        catch (DataAccessException e) {
            this.log.error((Object)("get role error . " + ExceptionUtil.getErrorMessage((Throwable)e)));
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public RoleInfo getRoleInfRelUser(long iRoleId, boolean isFetchUser) {
        try {
            RoleInfo oRole = null;
            if (isFetchUser) {
                String hql = "FROM RoleInfo r left join fetch r.userSet where r.roleIdx = " + iRoleId;
                List allUserLists = this.getHibernateTemplate().find(hql, new Object[0]);
                if (null != allUserLists && !allUserLists.isEmpty()) {
                    oRole = (RoleInfo)allUserLists.get(0);
                }
            } else {
                oRole = (RoleInfo)this.getHibernateTemplate().get(RoleInfo.class, (Serializable)Long.valueOf(iRoleId));
            }
            if (null == oRole) {
                String[] pamas = new String[]{"lego.lab.usrgroup.info"};
                throw new LegoCheckedException(206L, pamas);
            }
            return oRole;
        }
        catch (DataAccessException ex) {
            throw LegoExceptionTranslator.convert((Throwable)ex);
        }
    }

    @Override
    public synchronized void updataRole(RoleInfo roleInfo) {
        try {
            RoleInfo roleinfo = this.getRoleById(roleInfo.getRoleIdx(), false);
            if (null == roleinfo) {
                this.log.error((Object)"updataRole-role is null", 1L);
                throw new LegoCheckedException(262L);
            }
            this.getHibernateTemplate().update((Object)roleInfo);
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public List<RoleInfo> getAllRoles(boolean isFetchOper) {
        String hql = "FROM RoleInfo";
        try {
            List tmpSingleRoleInfolst = this.getHibernateTemplate().find(hql, new Object[0]);
            return tmpSingleRoleInfolst;
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void checkRoleNameSingle(String sRoleName) {
        try {
            String hql = "FROM RoleInfo where roleName = ? ";
            List result = this.getHibernateTemplate().find(hql, (Object[])new String[]{sRoleName});
            if (!result.isEmpty()) {
                throw new LegoCheckedException(259L);
            }
        }
        catch (DataAccessException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }
}

